local unescape = function (s)
     s = string.gsub(s, "+", " ")
     s = string.gsub(s, "%%(%x%x)", function (h)
          return string.char(tonumber(h, 16))
         end)
     return s
end

-- run_config.lua
local function parseRequest(input) 
    local _, _, method, path, vars = string.find(input, "([A-Z]+) (.+)?(.+) HTTP");
    
    if(method == nil)then
        _, _, method, path = string.find(input, "([A-Z]+) (.+) HTTP");
    end
    
    local _GET = {}
    
    if (vars ~= nil)then
        for k, v in string.gmatch(vars, "([_%w]+)=([^%&]+)&*") do
            _GET[k] = unescape(v)
        end
    end
              
    if (_GET.password ~= nil and _GET.ssid ~= nil) then
        writeConfig()
    end
end

local function writeConfig() 
    file.open("config.lua", "w")
        
    file.writeline('wifiStation = "' .. _GET.ssid .. '"')
    file.writeline('wifiPW = "' .. _GET.password .. '"')
    file.writeline('devName = "' .. devName .. '"')
    
    file.writeline('thingsSpeakKey = "' .. thingsSpeakKey .. '"')
    file.writeline('tsChannel = "' .. tsChannel .. '"')
    file.writeline('timeUpdate = "' .. timeUpdate .. '"')
    
    file.close()
        
    -- node.compile("config.lua")
    -- file.remove("config.lua")
    -- node.restart();
end