--init.lua

-- basic config
wifiStation=""
wifiPW=""
devName=""
thingsSpeakKey=""
tsChannel=""  
timeUpdate=60000
time=0

-- Status LEDs
led0 = 3
gpio.mode(led0, gpio.OUTPUT); 
gpio.write(led0, gpio.LOW); 

led1 = 4
gpio.mode(led1, gpio.OUTPUT); 
gpio.write(led1, gpio.LOW); 

-- load config
if pcall(function () dofile("config.lua") end) then
    uart.write(0,"Config loaded\r\n")
end

-- turn second LED on
gpio.write(led0, gpio.HIGH);

-- wait to settle WLAN client mode in seconds
iMax = 10

-- AP config
APWIFIcfg = 
{
     ssid="ESP" ..node.chipid(),
     pwd=node.chipid()
}

APIPcfg =
{
    ip="192.168.1.1",
    netmask="255.255.255.0",
    gateway="192.168.1.1"
}

-- Serial Setup
uart.setup(0,9600,8,0,0)

-- ThingSpeak Values
field1=0;
field2=0;
field3=0;
field4=0;
field5=0;
field6=0;
field7=0;
time=0;

-- compile
-- node.compile("run_config.lua")
-- file.remove("run_config.lua")

-- load reset
-- dofile("reset.lc");

-- load google.time
-- dofile("googleTime.lc");

-- Start
print("Setting up WIFI...")
wifi.setmode(wifi.STATION)
wifi.sta.config(wifiStation,wifiPW)
wifi.sta.connect()

i = 0
tmr.alarm(1, 1000, 1, function() 
     if wifi.sta.getip()==nil and wifi.ap.getip()==nil then 
          uart.write(0,"Try "..i..": IP unavaiable, Waiting...\r\n") 

          if i==iMax then
               -- tmr.stop(1)
               uart.write(0,"Start AP\r\n")
               wifi.setmode(wifi.SOFTAP)
               wifi.ap.setip(APIPcfg)
               wifi.ap.config(APWIFIcfg)
               -- gpio.write(led1, gpio.HIGH)
               -- dofile("localServer.lua")
               i = 0
          end
          
     else 
          tmr.stop(1)
          -- uart.write(0,"Config done.\r\n")
          
          gpio.write(led0, gpio.LOW);
                    
          if wifi.ap.getip()~=nil then
               -- dofile("run_config.lc")
               dofile("localServer.lc")
               dofile("wifiConfig.lc")
               
               lighton=0
               tmr.alarm(3,1000,1,function()
                    if lighton==0 then
                         gpio.write(led0, gpio.HIGH);
                         lighton=1
                    else
                         gpio.write(led0, gpio.LOW);
                         lighton=0
                    end
               end) 
          end
          
          if wifi.sta.getip()~=nil then
               gpio.write(led1, gpio.HIGH);
               dofile("tempArduino.lc");
               dofile("localServer.lc");
               dofile("googleTime.lc");

               uart.write(0,"WS1\r\n")
               
               -- send data every X ms to thing speak
               -- tmr.alarm(2, timeUpdate, 1, function() 
               --      sendData()
               -- end )
          end
     end 
     
     i = i+1
end)


