void wakeUpNow()        // Required for the interrupt for waking up
{
  // No code will be run here
}

void sleepNow()
{
  pinMode(boostButtonPin, INPUT); // Reduce power consumption.
  OCR1B = 0;
  digitalWrite(driverPwmPin, LOW); // Prevents PWM pin from floating.
  // Go to sleep
  adc_disable(); // Disable ADC to save energy
  set_sleep_mode(SLEEP_MODE_PWR_DOWN);   // Sleep mode with the most power saving
  sleep_enable(); // enables the sleep bit in the mcucr register
  attachInterrupt(0, wakeUpNow, LOW); // use interrupt 0 and run function
  sleep_mode();     // The chip is put to sleep here

  // Wake up
  sleep_disable(); // When button is pressed, wake up
  detachInterrupt(0); // disables interrupt 0 on pin 2 to prevent executing wakeUpNow while running
  adc_enable();

  powerButtonState = digitalRead(powerButtonPin);

  delayCounts = 0;
  while (powerButtonState == LOW) {
    delay(debounceDelay);
    delayCounts++;
    powerButtonState = digitalRead(powerButtonPin);
  }

  if (delayCounts <= 2) { // Button must be pressed long enough to turn it on.
    sleepNow();
  }
  if (delayCounts >= 10) { // Toggle battery chemistry.
    liionSelected = !liionSelected;
    EEPROM.write(0, liionSelected);
  }

  // Use the right setting for the LED driver's PWM pin. Must be used after setting its pin to LOW.
  TCCR1A = _BV(COM1B1) | _BV(WGM11);
  TCCR1B = _BV(WGM13) | _BV(WGM12) | _BV(CS10);
  ICR1 = period;
  OCR1B = 0;
  onTime = 0;

  boostMode = false;

  pinMode(boostButtonPin, INPUT_PULLUP); // Re-enable input.

  // Blinking patterns indicate the battery chemistry selected .
  if (liionSelected == false) {
    lowBattADC = lifepo4LowADC;
    deadBattADC = lifepo4deadADC;
    analogWrite(sidesPwmPin, 255);
    delay(50);
    analogWrite(sidesPwmPin, 0);
    delay(50);
    analogWrite(sidesPwmPin, 255);
    delay(50);
    analogWrite(sidesPwmPin, 0);
    delay(250);
  }
  else {
    lowBattADC = liionLowADC;
    deadBattADC = liionDeadADC;
    analogWrite(sidesPwmPin, 255);
    delay(250);
    analogWrite(sidesPwmPin, 0);
    delay(250);
    analogWrite(sidesPwmPin, 255);
    delay(250);
    analogWrite(sidesPwmPin, 0);
    delay(250);
  }
  batteryReading = analogRead(batteryMonitorPin);
}

