// The times spent in each phase of the patterns were multiplied by 64 because the prescaler was adjusted for the boost converter.

// Conditions: Vf=10V, capacity=1.8Ah, Vbatt=3.2V
// Average ADC:62.55
// Average current: 33 mA
// Average power: 0.33W
// Battery life:17h
void dayPulse() { // Inverted pulses for safety while improving detection by other road users and vision at night.

  elapsedMillis = millis() - prevMillis;
  if (elapsedMillis > 64000) {
    prevMillis = millis();
  }
  else if ((elapsedMillis > 51200) && (elapsedMillis < 64000)) {
    desiredFeedback = 0;
  }
  else if ((elapsedMillis > 48000) && (elapsedMillis < 51200)) {
    desiredFeedback = 200;
  }
  else if ((elapsedMillis > 35200) && (elapsedMillis < 48000)) {
    desiredFeedback = 0;
  }
  else if ((elapsedMillis > 32000) &&( elapsedMillis < 35200)) {
    desiredFeedback = 200;
  }
  else if ((elapsedMillis > 19200) &&( elapsedMillis < 32000)) {
    desiredFeedback = 0;
  }
  else if ((elapsedMillis > 16000) && (elapsedMillis < 19200)) {
    desiredFeedback = 200;
    batteryReading = analogRead(batteryMonitorPin); // Avoids underestimating the battery life by measuring it at a lower drive current.
  }
  else if ((elapsedMillis > 3200) && (elapsedMillis < 16000)) {
    desiredFeedback = 0;
  }
  else if (elapsedMillis < 3200) {
    desiredFeedback = 651 ;
  }
}

// Average ADC:30
// Average current: 33 mA
// Average power: 0.16W
// Battery life: 35h
void triplePulse() { // Inverted pulses for safety while improving detection by other road users and vision at night.
  elapsedMillis = millis() - prevMillis;
  if (elapsedMillis > 96000) {
    prevMillis = millis();
  }
  else if ((elapsedMillis > 24000) && (elapsedMillis < 96000)) {
    desiredFeedback = 20;
  }
  else if ((elapsedMillis > 19200) && (elapsedMillis < 24000) ) {
    desiredFeedback = 100;
  }
  else if ((elapsedMillis > 14400) && (elapsedMillis < 19200) ) {
    desiredFeedback = 0;
  }
  else if ((elapsedMillis > 9600) && (elapsedMillis <14400) ) {
    desiredFeedback = 100;
  }
  else if ((elapsedMillis > 4800) && (elapsedMillis < 9600) ) {
    desiredFeedback = 0;
  }
  else if (elapsedMillis < 4800) {
    desiredFeedback = 100 ;
  }
}

// Average ADC:22
// Average current: 11 mA
// Average power: 0.11W
// Battery life: 48h
void fade() {
  if (millis() - prevMillis > 25 * prescalerCompensate) { // 1 Hz fade
    prevMillis = millis();
    if (stepLevel < 39) {
      stepLevel++;
    }
    else if (stepLevel >= 39) {
      stepLevel = 0;
    }
  }
  desiredFeedback = fadeLevels[stepLevel];
}

