const byte defaultModesTop = 2;
const byte otherModesTop = 5;
const byte modeTypeTop = 1;

void readButton() {
  buttonState = digitalRead(buttonPin);

  if (buttonState == LOW) {
    // Set the brightness levels to zero.
    OCR0B = 0;
    onTime = 0;
    
    delayCounts = 0;

    while (buttonState == LOW) {
      delay(debounceDelay);
      delayCounts++;
      buttonState = digitalRead(buttonPin);
    }
    if (delayCounts <= 1) { // Increment mode.
      if (modeType == 0) {
        if (mode < defaultModesTop) {
          mode++;
        }
        else if (mode >= defaultModesTop) {
          mode = 0;
        }
      }
      else if (modeType == 1) {
        if (mode < otherModesTop) {
          mode++;
        }
        else if (mode >= otherModesTop) {
          mode = defaultModesTop + 1;
        }
      }
    }
    else if (delayCounts > 1 && delayCounts <= 5) { // Go to sleep.
      sleepNow();
    }
    else if (delayCounts > 5) { // Increment mode type.
      if (modeType < modeTypeTop) {
        modeType++;
        mode = defaultModesTop + 1;
      }
      else if (modeType >= modeTypeTop) {
        modeType = 0;
        mode = 0;
      }
    }
  }
}
