void wakeUpNow()        // Required for the interrupt for waking up
{
  // No code will be run here
}

void sleepNow()
{
  OCR0B = 0;
  digitalWrite(driverPwmPin, LOW); // Prevents the PWM pin from floating.
  // Go to sleep
  adc_disable(); // Disable ADC to save energy
  set_sleep_mode(SLEEP_MODE_PWR_DOWN);   // Sleep mode with the most power saving
  sleep_enable(); // enables the sleep bit in the mcucr register
  attachInterrupt(0, wakeUpNow, LOW); // use interrupt 0 and run function
  sleep_mode();     // The chip is put to sleep here

  // Wake up
  sleep_disable(); // When button is pressed, wake up
  detachInterrupt(0); // disables interrupt 0 on pin 2 to prevent executing wakeUpNow while running
  adc_enable();

  buttonState = digitalRead(buttonPin);

  delayCounts = 0;
  while (buttonState == LOW) {
    delay(debounceDelay);
    delayCounts++;
    buttonState = digitalRead(buttonPin);
  }

  if (delayCounts <= 2) { // Button must be pressed long enough to turn it on.
    sleepNow();
  }
  if (delayCounts >= 10) { // Toggle battery chemistry.
    liionSelected = !liionSelected;
    EEPROM.write(0, liionSelected);
  }

  // Use the right setting for the LED driver's PWM pin. Must be used after setting its pin to LOW.
  TCCR0A = _BV(WGM01) | _BV(WGM00) | _BV(COM0B1);
  TCCR0B = _BV(WGM02) | _BV(CS00);
  OCR0A = period;
  OCR0B = 0;

  // Blinking patterns indicate the battery chemistry selected.
  if (liionSelected == false) {
    lowBattADC = lifepo4LowADC;
    deadBattADC = lifepo4deadADC;
    
    // 50ms flashes with 250ms delay.
    enableBoostConverter();
    delay(3200);
    digitalWrite(driverPwmPin, LOW);
    delay(3200);
    enableBoostConverter();
    delay(3200);
    digitalWrite(driverPwmPin, LOW);
    delay(3200);
    enableBoostConverter();
    delay(3200);
    digitalWrite(driverPwmPin, LOW);
    delay(3200);
    enableBoostConverter();
    delay(3200);
    digitalWrite(driverPwmPin, LOW);
    delay(16000);
  }
  else {
    lowBattADC = liionLowADC;
    deadBattADC = liionDeadADC;
  
    // 250ms flashes.
    enableBoostConverter();
    delay(16000);
    digitalWrite(driverPwmPin, LOW);
    delay(16000);
    enableBoostConverter();
    delay(16000);
    digitalWrite(driverPwmPin, LOW);
    delay(16000);
  }
  enableBoostConverter();
  batteryReading = analogRead(batteryMonitorPin);
}

