/* GPS positioning
 * NodeMCU, GPS (Ublox NEO6-FM) and OLED 128x64
 * Results on the OLED screen
 * store poi_NN.txt in NodeMCU SPIFFS flash
*/

#include <SPI.h>                    // SD
#include <Wire.h>                   // I2C->OLED
#include <Adafruit_GFX.h>           // OLED
#include <Adafruit_SSD1306.h>       // OLED
#include <TinyGPS.h>                // GPS
#include <SoftwareSerial.h>         // GPS
#include "FS.h"                     // SPIFFS file system
//#include <ESP8266WiFi.h>            // WiFi access point

#define OLED_RESET LED_BUILTIN
Adafruit_SSD1306 oled(OLED_RESET);
SoftwareSerial mySerial(12, 14);    // RX, TX for GPS reading
TinyGPS gps;
File poi;
//WiFiServer server(80);

String ver = "v06e";                 // program version
float R = 6371.0;                   // radius of the Globe [km]
float pi = 3.1415926;               // Pi konstant
float minpoidist;                   // the distance of the nearest POI
float alert = 0.50;                 // alert distance [km]
float warning = 1.00;               // warning distance [km]
float big_dist = 10.00;             // big distance [km]
float prev_dist = 0.00;             // previous distance
boolean to_poi = false;            // True, if the distance getting shorter

void setup() {
  Wire.begin();
//  Serial.begin(115200);           // needed only for debug
  mySerial.begin(9600);             // needed for the GPS
//  WiFi.mode(WIFI_AP);
//  WiFi.softAP("POI_hunter", "nodemcuv1");
//  server.begin();
  oled.begin(SSD1306_SWITCHCAPVCC, 0x3C);
  oled.setTextColor(WHITE);
  oled_init();
}

void oled_init() {
  oled.clearDisplay();
  oledre(0, 5, "VEDA " + ver, 2, 1);
  oledre(40, 27, "GPS", 2, 1);
  oledre(20, 45, "search", 2, 1);
  oled.display();
}

void loop() {
  bool newData = false;               // data reading from GPS
  for (unsigned long start = millis(); millis() - start < 800;) {
    while (mySerial.available()) {
      char c = mySerial.read();
      if (gps.encode(c))
        newData = true;
    }
  }
  String kozel;                      // data record of the nearest POI
  if (newData) {
    float gpslat, gpslon, fspeed;
    unsigned long fix_age;
    gps.f_get_position(&gpslat, &gpslon, &fix_age);
    byte sat = gps.satellites();
    fspeed = gps.f_speed_kmph();
    if (sat >= 3) {                                     // number of sincronized satelites >= 3
      kozel = the_nearest(gpslat, gpslon);             // data record of the nearest POI
      if (minpoidist < prev_dist) {
        to_poi = true;
      } else {
        to_poi = false;
      }
      prev_dist = minpoidist;
      if (minpoidist <= alert && to_poi == true) {     // alert screen call
        oled.invertDisplay(true);
        oled_alert(format(minpoidist * 1000, "m"), kozel);
        }
      if (minpoidist <= warning && minpoidist > alert && to_poi == true) { // warning screen call
        oled.invertDisplay(true);
        oled_normal(format(minpoidist, "km"), kozel);
        }
      if ((minpoidist <= big_dist && minpoidist > warning) || to_poi == false) { // general screen call
        oled.invertDisplay(false);
        oled_normal(format(minpoidist, "km"), kozel);
      }
      if (minpoidist > big_dist) {                          // big distance screen call
        oled_big_dist(format(minpoidist, "km"), sat, fspeed);
      }
    } else {
      oled_init();                     // number of sincronized satelites < 3 init screen call
    }
    newData = false;
  }
//  WiFiClient client = server.available();
//  if (client) {site(client, kozel, format(minpoidist, "km"));}
}

/*void site(WiFiClient client, String lista, String distance) {
  String request = client.readStringUntil('\r');
  Serial.println(request);
  client.flush();
  client.println("HTTP/1.1 200 OK");
  client.println("Content-Type: text/html");
  client.println(""); //  do not forget this one
  client.println("<!DOCTYPE HTML>");
  client.println("<html>");
  client.println("<center><H1>POI hunter</H1>");
  client.println("Version: " + ver);
  client.println("<HR WIDTH=600>");
  client.println("<font size=5>");
  client.print("Distance of the nearest POI: <b>");
  client.println(distance);
  client.println("</b><br>");
  client.println(cut(lista, 4) + " ut, ");
  client.println(cut(lista, 5) + ", " + cut(lista, 6));
  client.println("<br><br>");
  client.println("<br><a href=http://192.168.4.1><button>Reload</button></a>");
  client.println("</center>");
  client.println("</html>");
}*/

String format(float ftav, String measure) {       // format the value and the measure of the distance
  byte digit;
  if (ftav < 10) {digit = 3;}
  if (ftav < 100 && ftav >= 10) {digit = 2;}
  if (ftav < 1000 && ftav >= 100) {digit = 1;}
  if (ftav >= 1000) {digit = 0;}
  return String(ftav, digit) + measure;
}

void oled_big_dist(String distance, byte sats, float fspeed) {   // big distance screen definition
  oled.clearDisplay();
  oledre(0,2, "Sats: " + String(sats), 2, 1);
  oledre(0,25, String(fspeed, 0) + "km/h", 2, 1);
  oledre(0, 48, distance, 2, 1);
  oled.display();
}

void oled_normal(String distance, String adatok) {             // normal and warning screen def.
  byte digit;
  oled.clearDisplay();
  oledre(1, 1, cut(adatok, 4), 2, 0);
  oledre(76, 1, cut(adatok, 3), 2, 2);
  oledre(22, 25, cut(adatok, 5), 1, 1);
  oledre(0, 42, distance, 3, 1);
  oled.display();
}

void oled_alert(String distance, String adatok) {             // alert screen def.
  oled.clearDisplay();
  oledre(0, 5, cut(adatok, 3), 3, 1);
  oledre(0, 35, distance, 3, 1);
  oled.display();
}

void oledre(byte x, byte y, String text, byte charsize, byte align) {    // writes texts to the OLED
  byte column = x;                                                          // left alignment
  byte hossz = text.length();
  if (align == 1) {column = (127-(charsize*5*hossz)-hossz*charsize)/2;}   // centered alignment
  if (align == 2) {column = (127-(charsize*5*hossz)-(hossz*charsize));}   // right alignment
  oled.setTextSize(charsize);
  oled.setCursor(column, y);
  oled.print(text);
}

String the_nearest(float real_lat, float real_long) {      // search for the nearest POI
  if (SPIFFS.begin()) {
    double calcdist, mindist = 1000.0;
    String minrecord;
    char reading = 0;
    poi = SPIFFS.open("/poi_04.txt", "r");
    if (poi) {
      while (poi.available()) {
        String datarec;
        while (reading != 13) {
          reading = poi.read();
          datarec += reading;
        }
        reading = poi.read();
        float f_lat = cut(datarec, 1).toFloat();
        float f_long = cut(datarec, 2).toFloat();
        calcdist = distance(real_lat, real_long, f_lat, f_long);
        if (calcdist < mindist) {
          mindist = calcdist;
          minrecord = datarec;
        }
      }
    }
    poi.close();
    minpoidist = mindist;
    return minrecord;
  }
  SPIFFS.end();
}

float distance(float lat1, float long1, float lat2, float long2) {      // distance between two points
  float dlong = rad(long2 - long1);
  float dlat = rad(lat2 - lat1);
  float a = pow(sin(dlat / 2.0), 2) + cos(rad(lat1)) * cos(rad(lat2)) * pow(sin(dlong / 2.0), 2);
  float c = 2 * atan2(sqrt(a), sqrt(1 - a));
  float d = R * c;
  return d;
}

float rad(float szog) {return szog * pi / 180.0;}     // degree -> radian

String cut(String datarec, byte pos) {          // reads the Nth field from the data record
  byte counter = 0;
  String data;
  while (counter < pos) {
    byte pos = datarec.indexOf(';');
    data = datarec.substring(0, pos);
    datarec = datarec.substring(pos + 1);
    counter += 1;
  }
  return data;
}
