/* GPS helymeghatározás
 * NodeMCU, GPS (Ublox NEO6-FM) és OLED 128x64
 * Eredmények megjelenítése az OLED kijelzőn.
 * poi.txt tárolása NodeMCU SPIFFS flashben
 * http://arduiniana.org/libraries/tinygps/
 * v05w: WiFi access pointbekapcsolva, az adatok lekérdezhetőek
 * v06: Access point torolve, POI-tól távolodva inverz képernyő megszűnik
 */

#include <SPI.h>                    // SD
#include <Wire.h>                   // I2C->OLED
#include <Adafruit_GFX.h>           // OLED
#include <Adafruit_SSD1306.h>       // OLED
#include <TinyGPS.h>                // GPS
#include <SoftwareSerial.h>         // GPS
#include "FS.h"                     // SPIFFS file system
//#include <ESP8266WiFi.h>            // WiFi access point

#define OLED_RESET LED_BUILTIN
Adafruit_SSD1306 oled(OLED_RESET);
SoftwareSerial mySerial(12, 14);    // RX, TX GPS olvasása
TinyGPS gps;
File poi;
//WiFiServer server(80);

String ver = "v06";                 // Programverzió
float R = 6371.0;                   // Föld sugár [km]
float pi = 3.1415926;               // Pi konstans
float minpoitav;                    // A legkozelebbi POI tavolsaga
float riaszt = 0.50;                // Riasztás távolsága [km]
float figyelmeztet = 1.00;          // Figyelmeztetés távolsága [km]
float tavol = 10.00;
float elozo_tav = 0.00;             // Az előző összehasonlításból származó távolság
boolean kozelit = false;            // True, ha az autó közelít a POI-hoz
//int sat = 0;                        // Szinkronizált műholdak száma
//unsigned long blink_timer;          // Villogtatás timere
//boolean blink = false;              // Villogtatás beállítása
//boolean inverz = 1;                // Inverz aktuális értéke

void setup() {
  Wire.begin();
//  Serial.begin(115200);
  mySerial.begin(9600);
//  WiFi.mode(WIFI_AP);
//  WiFi.softAP("POI_hunter", "nodemcuv1");
//  server.begin();
  oled.begin(SSD1306_SWITCHCAPVCC, 0x3C);
  oled.setTextColor(WHITE);
  oled_init();
}

void oled_init() {
  oled.clearDisplay();
  oledre(0, 5, "VEDA " + ver, 2, 1);
  oledre(40, 27, "GPS", 2, 1);
  oledre(20, 45, "kereses", 2, 1);
  oled.display();
}

void loop() {
/*  if (blink == true && (blink_timer + 250) < millis()) {
    oled.invertDisplay(b_value);
    oled.display();
    blink_timer = millis();
    b_value = abs(b_value-1);
  }*/
  bool newData = false;
  for (unsigned long start = millis(); millis() - start < 500;) {
    while (mySerial.available()) {
      char c = mySerial.read();
      if (gps.encode(c))
        newData = true;
    }
  }
  String kozel;
  if (newData) {
    float gpslat, gpslon, fspeed;
    unsigned long fix_age;
    gps.f_get_position(&gpslat, &gpslon, &fix_age);
    byte sat = gps.satellites();
    fspeed = gps.f_speed_kmph();
    if (sat >= 3) {
      kozel = legkozelebbi(gpslat, gpslon);             // A legközelebbi poi adatsora
      if (minpoitav < elozo_tav) {
        kozelit = true;
      } else {
        kozelit = false;
      }
      elozo_tav = minpoitav;
      if (minpoitav <= riaszt && kozelit == true) {
        //blink = true;
        oled.invertDisplay(true);
        oled_riaszt(formaz(minpoitav * 1000, "m"), kozel);
        }
      if (minpoitav <= figyelmeztet && minpoitav > riaszt && kozelit == true) {
        //blink = true;
        oled.invertDisplay(true);
        oled_normal(formaz(minpoitav, "km"), kozel);
        }
      if ((minpoitav <= tavol && minpoitav > figyelmeztet) || kozelit == false) {
//      if (minpoitav > figyelmeztet) {
/*        if (blink) {
          blink = false;
          b_value = false;
          oled.invertDisplay(b_value);
        }*/
        oled.invertDisplay(false);
        oled_normal(formaz(minpoitav, "km"), kozel);
      }
      if (minpoitav > tavol) {
        oled_tavol(formaz(minpoitav, "km"), sat, fspeed);
      }
    } else {
      oled_init();
    }
    newData = false;
  }
//  WiFiClient client = server.available();
//  if (client) {honlap(client, kozel, formaz(minpoitav, "km"));}
}

/*void honlap(WiFiClient kliens, String lista, String tavolsag) {
  String request = kliens.readStringUntil('\r');
  Serial.println(request);
  kliens.flush();
  kliens.println("HTTP/1.1 200 OK");
  kliens.println("Content-Type: text/html");
  kliens.println(""); //  do not forget this one
  kliens.println("<!DOCTYPE HTML>");
  kliens.println("<html>");
  kliens.println("<center><H1>POI hunter</H1>");
  kliens.println("Verzio: " + ver);
  kliens.println("<HR WIDTH=600>");
  kliens.println("<font size=5>");
  kliens.print("A legkozelebbi VEDA tavolsaga: <b>");
  kliens.println(tavolsag);
  kliens.println("</b><br>");
  kliens.println(vagas(lista, 4) + " ut, ");
  kliens.println(vagas(lista, 5) + ", " + vagas(lista, 6));
  kliens.println("<br><br>");
  kliens.println("<br><a href=http://192.168.4.1><button>Frissit</button></a>");
  kliens.println("</center>");
  kliens.println("</html>");
}*/

String formaz(float ftav, String merte) {
  byte digit;
  if (ftav < 10) {digit = 3;}
  if (ftav < 100 && ftav >= 10) {digit = 2;}
  if (ftav < 1000 && ftav >= 100) {digit = 1;}
  if (ftav >= 1000) {digit = 0;}
  return String(ftav, digit) + merte;
}

void oled_tavol(String tavolsag, byte sats, float fspeed) {
  oled.clearDisplay();
//  oled.invertDisplay(true);
  oledre(0,2, "Sats: " + String(sats), 2, 1);
  oledre(0,25, String(fspeed, 0) + "km/h", 2, 1);
  oledre(0, 48, tavolsag, 2, 1);
  oled.display();
}

void oled_normal(String tavolsag, String adatok) {             // Normál és figyelmeztető képernyő
  byte digit;
  oled.clearDisplay();
  oledre(1, 1, vagas(adatok, 4), 2, 0);
  oledre(76, 1, vagas(adatok, 3), 2, 2);
  oledre(22, 25, vagas(adatok, 5), 1, 1);
  oledre(0, 42, tavolsag, 3, 1);
  oled.display();
}

void oled_riaszt(String tavolsag, String adatok) {             // Riasztás képernyő
  oled.clearDisplay();
  oledre(0, 5, vagas(adatok, 3), 3, 1);
  oledre(0, 35, tavolsag, 3, 1);
  oled.display();
}

void oledre(byte x, byte y, String szoveg, byte betumeret, byte align) {    // Szöveg OLED-re
  byte oszlop = x;
  byte hossz = szoveg.length();
  if (align == 1) {oszlop = (127-(betumeret*5*hossz)-hossz*betumeret)/2;}   // Kozepre igazit
  if (align == 2) {oszlop = (127-(betumeret*5*hossz)-(hossz*betumeret));}   // Jobbra igazit
  oled.setTextSize(betumeret);
  oled.setCursor(oszlop, y);
  oled.print(szoveg);
}

String legkozelebbi(float teny_lat, float teny_long) {      // A legkozelebbi POI megkeresése
  if (SPIFFS.begin()) {
    double tav, mintav = 1000.0;                            // km-ben szamol
    String minadatsor;
    char beolvas = 0;
    poi = SPIFFS.open("/poi_04.txt", "r");
    if (poi) {
      while (poi.available()) {
        String adatsor;
        while (beolvas != 13) {
          beolvas = poi.read();
          adatsor += beolvas;
        }
        beolvas = poi.read();
        float f_lat = vagas(adatsor, 1).toFloat();
        float f_long = vagas(adatsor, 2).toFloat();
        tav = tavolsag(teny_lat, teny_long, f_lat, f_long);
        if (tav < mintav) {
          mintav = tav;
          minadatsor = adatsor;
        }
      }
    }
    poi.close();
    minpoitav = mintav;
    return minadatsor;
  }
  SPIFFS.end();
}

float tavolsag(float lat1, float long1, float lat2, float long2) {      // Két pont közötti távolság kiszámítása
  float dlong = rad(long2 - long1);
  float dlat = rad(lat2 - lat1);
  float a = pow(sin(dlat / 2.0), 2) + cos(rad(lat1)) * cos(rad(lat2)) * pow(sin(dlong / 2.0), 2);
  float c = 2 * atan2(sqrt(a), sqrt(1 - a));
  float d = R * c;
  return d;
}

float rad(float szog) {return szog * pi / 180.0;}

String vagas(String adatsor, byte sorszam) {          // Adatsor feldarabolása pontosvesszőknél
  byte szamlalo = 0;
  String adat;
  while (szamlalo < sorszam) {
    byte pos = adatsor.indexOf(';');
    adat = adatsor.substring(0, pos);
    adatsor = adatsor.substring(pos + 1);
    szamlalo += 1;
  }
  return adat;
}
