class Triangle {
	PVector n;
	PVector[] v;
	PVector v1;
	PVector	v2;
	PVector v3;
	float minZ, maxZ, avgZ;
	float spanZ;
	PVector centroid;
	int zBin; // bin triangles by Z height as a rough sorting method
	PVector zAxis;
	float slope; // slope is the angle [in radians] between triangle normal and Zaxis. 


	Triangle(PVector n_, PVector v1_, PVector v2_, PVector v3_){
		n = new PVector(0,0,0);
   		v = new PVector[3];
   		for(int i = 0; i < v.length; i++) {
   		  v[i] = new PVector(0,0,0);
   		}
		zAxis = new PVector(0,0,1);
		v[0].set(v1_);
		if(zUp == true){
			v[1].set(v2_);
			v[2].set(v3_);
		} else {
			v[1].set(v3_);
			v[2].set(v2_);
		}
		
		normalFromVertices();

		setMinZ();
		setMaxZ();
		setSlope();
    	setAvgZ();
    	setSpanZ();
	}


	void setMinZ(){
		minZ = v[0].z;
		if(v[1].z < minZ){
			minZ = v[1].z;
		} 
		if(v[2].z < minZ){
			minZ = v[2].z;
		}
	}

   
	void setMaxZ(){
		maxZ = v[0].z;
		if(v[1].z > maxZ){
			maxZ = v[1].z;
		} 
		if(v[2].z > maxZ){
			maxZ = v[2].z;
		}
	}
	

	void setSpanZ(){
		spanZ = maxZ-minZ;
	}

	void setSlope(){
		PVector nNorm = new PVector(0,0,0);
		nNorm.set(n.normalize());
		slope=acos(nNorm.z);
	}

  void setAvgZ() {
    avgZ = (v[0].z + v[1].z + v[2].z)/3;
  }

  void normalFromVertices(){
  	// normalDirection = (B-A) x (C-A)
  	// The normal is calculated here instead of from STL because of an apparent bug in Meshmixer. If YZ axes are flipped in Meshmixer, the Y and Z coordinates of the triangle vertices are switched, but the normal vector is not changed.
  	PVector cross1 = PVector.sub(v[1], v[0]);
  	PVector cross2 = PVector.sub(v[2], v[0]);
  	PVector normalCross = cross1.cross(cross2);
  	normalCross.normalize();
  	n.set(normalCross);
  }

}
