
void parseTheBunny() {
  // This function reads the stl at stlPath and populates the list triangles and the value numTriangles.
  // Our first STL we tested was the Stanford Bunny.
  String lines[] = loadStrings(stlPath);
  //count the triangles to speed up array allocation
  for(int i = 0; i < lines.length; i++) {
    if(lines[i].substring(2,7).equals("facet")) {
      numTriangles++;
    }
  }
  
  //put all the triangles in an array
  triangles = new Triangle[numTriangles];

  numTriangles = 0;
  for(int i = 0; i < lines.length; i++) {
    if(lines[i].substring(2,7).equals("facet")) {
      float[] tVector = parseVectorFromLine(lines[i]);
      PVector n = new PVector(tVector[0], tVector[1], tVector[2]);
      tVector = parseVectorFromLine(lines[i+2]);
      PVector v1 = new PVector(tVector[0], tVector[1], tVector[2]);
      tVector = parseVectorFromLine(lines[i+3]);
      PVector v2 = new PVector(tVector[0], tVector[1], tVector[2]);
      tVector = parseVectorFromLine(lines[i+4]);
      PVector v3 = new PVector(tVector[0], tVector[1], tVector[2]);
      triangles[numTriangles] = new Triangle(n, v1, v2, v3);
      numTriangles++;
    }
  }
  println("triangles in STL: "+numTriangles);
}


  
float[] parseVectorFromLine(String s) {
  //remove ending newline
  s = s.substring(0,(s.length()));
  float[] components = new float[3];
  for(int i = components.length-1; i >= 0; i--) {
    int SI = spaceIndex(s);
    //println("s.sub: "+ s.substring(SI,s.length()));
    components[i] = float(s.substring(SI,s.length()));
    if(Float.isNaN(components[i])) {
     // components[i] = 0;
    }
    s = s.substring(0, SI-1);
  }
  return components;
}

// helper function for parseVectorFromLine()
int spaceIndex(String s) {
  for(int i=s.length()-1; i > 0; i--) {
    if(s.charAt(i) == ' ') {
      return (i+1);
    }    
  }
  return 0;
}


