
// global variables
float[] layerHeights;
float[] absoluteHeights;
float[] minSlopes;
int[] triInLayers;
float[] variableLayers = {0.100, 0.095, 0.090, 0.085, 0.080, 0.075, 0.070, 0.065, 0.060, 0.055, 0.050, 0.045, 0.040, 0.035, 0.030, 0.025, 0.020, 0.015, 0.010}; // must start with thickest layers first
//float[] variableLayers = {0.025, 0.020, 0.015, 0.010}; // Use this line if you want slices to range between 25 and 10 µm.

void buildLayers(){
	// Knowing the height of the STL and the smallest the layer sizes can be, we can find out the maximum number of slices possible.
	// We'll create our arrays this size so they shouldn't go out of bounds, but will have excess empty slots
	float minLayerSize = min(variableLayers);
	stlHeight = calcSTLheight();
	int maxLayers = int(stlHeight/minLayerSize);
	maxLayers *=2;
	println("maxLayers: " + maxLayers);

	// Create an arraylist of triangles to temporarily hold triangles of interest
	ArrayList<Triangle> tempTriangles = new ArrayList<Triangle>();

	layerHeights = new float[maxLayers];
	absoluteHeights = new float[maxLayers];
	minSlopes = new float[maxLayers];
	triInLayers = new int[maxLayers];

	float zLevel; 
	float zInspect; 		

	for (int k = 0; k < maxLayers; k++){
		if (k==0) {
			zLevel =0;
		} else {
			zLevel = absoluteHeights[k-1];
		}		 

		// j iterates through the list of layer thicknesses that we'll consider
		for(int j = 0; j< variableLayers.length; j++){
	
			zInspect = variableLayers[j]; 
	
			// i iterates through every triangle to see if it is within the window/range of interest 
			tempTriangles.clear();
			for(int i = 0; i < triangles.length; i++){
				if(isTriangleInRangeOfInterest(triangles[i], zLevel, zLevel+zInspect) == true){
					tempTriangles.add(triangles[i]);
				}
			}			
		
			float layerSlope = findMinSlope(tempTriangles);

			// Is this layer thickness small enough? If so build it! Or if we're on the thinnest layer thickness possible, build it.
			// Assumes variable layers go from thick to thin.
			if(smallEnough(layerSlope, variableLayers[j], stepoverThreshold) == true || j == variableLayers.length-1){
				layerHeights[k] = variableLayers[j];
				absoluteHeights[k] = zLevel + variableLayers[j];
				minSlopes[k] = layerSlope;
				triInLayers[k]=tempTriangles.size();
				break;
			}
			tempTriangles.clear();
		}
		if(tempTriangles.size()==0){
			break;
		}
		tempTriangles.clear();
	}
} // end Build layers


void createTable(){
	// This table is useful for debugging purposes. Also, it can be used to visualize the layer thicknesses using the drawLayersGeneral.pde sketch
	Table data = new Table();
	data.addColumn("Layer");
	data.addColumn("Thickness");
	data.addColumn("Height");
	data.addColumn("MinSlopeRad");
	data.addColumn("MinSlopeDeg");
	data.addColumn("TriInLayers");

	for (int i = 0; i<layerHeights.length; i++){
		// if statement to break when some value is zero.
		if(layerHeights[i]==0 || triInLayers[i]==0 ){
			totalVariableLayers = i;
			println("totalVariableLayers: " + totalVariableLayers);
			break;
		}
		TableRow newRow = data.addRow();

		newRow.setInt("Layer", i+1);
		newRow.setFloat("Thickness", layerHeights[i]*1000); // x1000 to convert mm to µm
		newRow.setFloat("Height", round(absoluteHeights[i]*1000)); // x1000 to convert mm to µm
		newRow.setFloat("MinSlopeRad", minSlopes[i]);
		newRow.setFloat("MinSlopeDeg", degrees(minSlopes[i]));
		newRow.setInt("TriInLayers", triInLayers[i]);
	}
	saveTable(data, "output/drawData"+exportNumber+".csv");
}


void createLayerSettings(){
	// This file is necessary for printing on Ember!
	Table layersettings = new Table();
	layersettings.addColumn("Layer");
	layersettings.addColumn("LayerThicknessMicrons");
	layersettings.addColumn("ModelExposureSec");

	for(int i = 0; i<layerHeights.length; i++){
		if(layerHeights[i]==0 || triInLayers[i]==0){break;}

		TableRow newRow = layersettings.addRow();
		newRow.setInt("Layer", i+1);
		newRow.setInt("LayerThicknessMicrons", round(layerHeights[i]*1000)); // must convert mm (sketch units) to µm (Ember units)

		float exp =1.2228*pow(2.71828, 2.9978*layerHeights[i]);  // emprical formula for calculating the exposure times (seconds) for Autodesk PR57 K resin on Ember
		newRow.setFloat("ModelExposureSec", exp*exposureScale);

		saveTable(layersettings, savePath+"/layersettings.csv"); // file must be called layersettings.csv
	}
}


void selectSlices(){
	// This function looks through an image stack and selects only the appropriate slices and renames them

	float sliceInterval = 0.005; // layer thickness that STL was slices at (in mm)
	for (int i = 0; i<totalVariableLayers; i++){
		int sliceNumber = int(absoluteHeights[i]/sliceInterval);

		if(absoluteHeights[i] > stlHeight){
			break;
		}

		PImage slice = loadImage(slicesPath+"/slice_"+sliceNumber+".png");	
		String savePathSlice = savePath(savePath+"/slice_"+(i+1)+".png");
		slice.save(savePathSlice);
		if((i+1) % 100 == 0 || i==0){
			println("slice "+(i+1)+" done, "+millis()/1000.+" seconds");
		}
	}
}


boolean isTriangleInRangeOfInterest(Triangle tri, float lo, float hi){
	if(tri.maxZ > lo && tri.minZ < lo) {return true;}      // case 1: top of triangle is in RoI
	else if(tri.minZ < hi && tri.maxZ > hi) {return true;} // case 2: bottom of triangle is in RoI
	else if(tri.minZ < lo && tri.maxZ > hi) {return true;} // case 3: triangle spans above and below RoI
	else if(tri.maxZ < hi && tri.minZ > lo) {return true;} // case 4: triangle is completely within RoI
	else {return false;}
}

float findMinSlope(ArrayList<Triangle> interestingTriangles){
	// find the slope closest to zero or to pi (in radians)
	float tempSlope;
	float minSlope = 999;
	for(int i = 0; i < interestingTriangles.size(); i++){
		tempSlope = interestingTriangles.get(i).slope;
		// Wether or not a triangle is on the top or bottom surface of the STL does not matter. So if angle is greater than 90° (pi/2), subtract pi.
		if(tempSlope > PI/2){
			tempSlope = PI - tempSlope;
		}
		if(tempSlope < minSlope){
			minSlope = tempSlope;
		}
	}
	return minSlope;
}


boolean smallEnough(float slope, float thickness, float threshold){
	float stepover = thickness/tan(slope);
	if(stepover <= threshold){
		return true;
	} else {
		return false;
	}
}


float calcSTLheight(){
	// finds the highest (z) point of any triangle in the STL. this is the overall height of the STL
	// ASSUMES LOWEST Z VALUE IS ZERO!!!!!!!!!!
	float maxHeight = 0;
	float minHeight = 99999999;
	for (int i = 0; i<triangles.length; i++){
		if(triangles[i].maxZ > maxHeight){
			maxHeight = triangles[i].maxZ;
		}
		if(triangles[i].minZ < minHeight){
			minHeight = triangles[i].minZ;
		}
	}
	println("STL max Height: " + maxHeight);
	println("STL min Height: " + minHeight);
	return maxHeight;
}


void calcSlopeRange(){
	// for debugging purposes. 0 degrees means surface normal is pointing upwards, 180 degrees normal points downward
	float maxSlope = -9999999;
	float minSlope = 9999999;
	for(int i = 0; i<triangles.length; i++){
		if(triangles[i].slope > maxSlope){
			maxSlope = triangles[i].slope;
		}
		if(triangles[i].slope < minSlope){
			minSlope = triangles[i].slope;
		}
	}
	println("maxSlope: "+degrees(maxSlope)+" degrees");
	println("minSlope: "+degrees(minSlope)+" degrees");
}

