# cc-by-sa 
# By: 連宏城 ted99.tw@gmail.com 
# Date: 2019.10.10
# 電腦視覺：花朵辨識
import car, sensor, image, KPU as kpu
car.init()
sensor.set_pixformat(sensor.RGB565)
sensor.set_windowing((224, 224)) #設定有效視窗大小   
sensor.set_vflip(0)
sensor.set_hmirror(0)
lcd.clear()
lcd.draw_string(100,112,"Loading labels...")
# 讀取花朵標簽[雛菊,蒲公英,玫瑰,向日葵,鬱金香]
labels=['daisy','dandelion','roses','sunflowers','tulips']
# 讀取花朵模型
task = kpu.load("/sd/model/flowers.kmodel") 
while(True):
    img = sensor.snapshot()    
    fmap = kpu.forward(task, img)   # 辨認，並輸出特徵圖
    plist=fmap[:]                   # 取出特徵圖全部數字結果    
    pmax=max(plist)                 # 取出信心值最高者    
    max_index=plist.index(pmax)     # 取出該索引值
    a = lcd.display(img, oft=(50,0))
    # 信心值：花朵名稱
    lcd.draw_string(0, 224, "%.2f:%s "%(pmax, 
        labels[max_index].strip()))  
a = kpu.deinit(task)                # 釋放資源 
