# cc-by-sa 
# By: 連宏城 ted99.tw@gmail.com 
# Date: 2019.10.10
# 電腦視覺：10種交通號誌
import car, sensor, image, KPU as kpu
car.init()
lcd.init()
sensor.set_pixformat(sensor.RGB565)
sensor.set_windowing((224, 224)) #設定有效視窗大小   
sensor.set_vflip(0)
sensor.set_hmirror(0)
lcd.draw_string(100,96,"MobileNet Demo")
# 讀取10種交通號誌標簽
labels=['left','park','stop','lim40','lim110','noentry','children','walker','bike','right']
task = kpu.load("/sd/model/traffic10.kmodel") # 讀取交通號誌模型
while(True):
    img = sensor.snapshot()
    # 辨認，並輸出特徵圖
    fmap = kpu.forward(task, img)   
    fps=clock.fps()
    # 取出特徵圖全部數字結果
    plist=fmap[:]
    # 取出信心值最高者
    pmax=max(plist)	
    # 取出該索引值
    max_index=plist.index(pmax)	
    a = lcd.display(img, oft=(50,0))
    # 信心值：號誌名稱
    lcd.draw_string(0, 224, "%.2f:%s "%(pmax, labels[max_index].strip()))
# 釋放資源    
a = kpu.deinit(task)
