# cc-by-sa 
# By: 連宏城 ted99.tw@gmail.com 
# Date: 2019.10.10
# 類神經AI：臉部辨識（使用yolo神經網路）
import car, sensor, image, KPU as kpu
car.init()
sensor.set_pixformat(sensor.RGB565)
# 載入模型檔
task = kpu.load('/sd/model/facedetect.kmodel')
# 設定參數，並初始化yolo神經網路
anchor = (1.889, 2.5245, 2.9465, 3.94056, 3.99987, 
    5.3658, 5.155437, 6.92275, 6.718375, 9.01025)
a = kpu.init_yolo2(task, 0.5, 0.3, 5, anchor)
while(True):
    img = sensor.snapshot()
    # 進行辨識
    code = kpu.run_yolo2(task, img)
    if code:
        for i in code:
            print(i)
            a = img.draw_rectangle(i.rect())
    a = lcd.display(img)
a = kpu.deinit(task)
