# qrcode Example
# cc-by-sa 
# By: 連宏城 ted99.tw@gmail.com 
# Date: 2019.10.10
# 電腦視覺：QR碼識別
import car, sensor, image
car.init()
sensor.set_pixformat(sensor.RGB565)
# 讀取qrcode, apriltag等二維條碼時，sensor需要上下顛倒
sensor.set_vflip(1) 
lcd.init()
# LCD旋轉2次以正常顯示上下顛倒過的顯像
lcd.rotation(2)
while True:
    img = sensor.snapshot()
    res = img.find_qrcodes()
    if len(res) > 0:
        img.draw_string(2,2, res[0].payload(), 
            color=(255,0,0), scale=2)
        img.draw_rectangle(res[0].rect())
        print(res[0].payload())
    lcd.display(img)

