# cc-by-sa 
# By: 連宏城 ted99.tw@gmail.com 
# Date: 2019.10.10
# 電腦視覺：灰階色塊追踪，本例追踪超亮部
import car, sensor, image, math
car.init()
thresholds = (245, 255) 
sensor.set_auto_gain(False) 
sensor.set_auto_whitebal(False) 
lcd.mirror(True)
while(True):
    img = sensor.snapshot()
    # 超過200個像素並且面積達100(大約長寬各10個像素)才通過
    for blob in img.find_blobs([thresholds], pixels_threshold=100, 
        area_threshold=100, merge=True):
        # These values are stable all the time.
        img.draw_rectangle(blob.rect(), color=127)
        img.draw_cross(blob.cx(), blob.cy(), color=127)
        # 畫出色塊關鍵點
        img.draw_keypoints([(blob.cx(), blob.cy(), 
          int(math.degrees(blob.rotation())))], size=40, color=127)
    lcd.display(img)
