# cc-by-sa 
# By: 連宏城 ted99.tw@gmail.com 
# Date: 2019.10.10
# 電腦視覺：多色塊追踪
# 畫面稍暗，因為自動增益將關閉
import car, sensor, image, math
car.init()
# 使用LAB色彩模式(L Min, L Max, A Min, A Max, B Min, B Max)
# 調整A，B可得到不同顏色閾值，最多16組
# 增色LAB(範圍擴大各5)
thresholds = [(12, 67,   50,  68,  12,  40),  # 紅
              (57, 74,  -64, -44,  10,  38),  # 綠
              (54, 100,  -34, -0,  35,  57),  # 黃
              (20, 36,   15,  47, -78, -50)]  # 藍
sensor.set_pixformat(sensor.RGB565)
while(True):
    img = sensor.snapshot()
    # 超過200個像素並且面積達200(大約長寬各15個像素)才通過
    for blob in img.find_blobs(thresholds, 
        pixels_threshold=200, area_threshold=200, merge=True):
        img.draw_rectangle(blob.rect(),color=(0,255,0))
        img.draw_cross(blob.cx(), blob.cy())
    lcd.display(img)
