# cc-by-sa 
# By: 連宏城 ted99.tw@gmail.com 
# Date: 2019.10.10
# 電腦視覺：多色塊追踪
# 畫面稍暗，因為自動增益將關閉
import car, sensor, image, math
car.init()
# 使用LAB色彩模式(L Min, L Max, A Min, A Max, B Min, B Max)
# 調整A，B可得到不同顏色閾值，最多16組
thresholds = [(30, 100, 15, 127, 15, 127), # 紅
              (20, 100, -128, -20, -10, 127), # 綠
              (0, 15, 0, 40, -80, -20)]    # 藍
sensor.set_pixformat(sensor.RGB565)
sensor.set_auto_gain(False) 
sensor.set_auto_whitebal(False) 
while(True):
    img = sensor.snapshot()
    # 超過200個像素並且面積達200(大約長寬各15個像素)才通過
    for blob in img.find_blobs(thresholds, 
        pixels_threshold=200, area_threshold=200):
        img.draw_rectangle(blob.rect())
        img.draw_cross(blob.cx(), blob.cy())
        # 畫出色塊關鍵點
        img.draw_keypoints([(blob.cx(), blob.cy(), 
            int(math.degrees(blob.rotation())))], size=20)
    lcd.display(img)
