# cc-by-sa 
# By: 連宏城 ted99.tw@gmail.com 
# Date: 2019.10.10
# 電腦視覺：透過關鍵點追踪場景
import car, sensor, image
car.init()
sensor.set_contrast(3)
sensor.set_gainceiling(16)
sensor.set_auto_gain(False, value=100)
lcd.mirror(True)
# 繪制關鍵點
def draw_keypoints(img, kpts):
    if kpts:
        img.draw_keypoints(kpts)
        lcd.display(img)
        img = sensor.snapshot()
        
while (True):
    img = sensor.snapshot()
    if (kpts1 == None):
        # 找初始場景關鍵點
        kpts1 = img.find_keypoints(max_keypoints=150, threshold=10, scale_factor=1.2)
        draw_keypoints(img, kpts1)         
        time.sleep(1)
    else:
        # 隨意移動鏡頭再移回來，看能否找到原場景
        kpts2 = img.find_keypoints(max_keypoints=150, threshold=10, normalized=True)
        if (kpts2):
            match = image.match_descriptor(kpts1, kpts2, threshold=85)
            # 關鍵點至少10個相同才算有找到
            if (match.count()>10):
                img.draw_rectangle(match.rect())
                img.draw_cross(match.cx(), match.cy(), size=10)
                lcd.draw_string(10,30,str(match.count()), lcd.RED, lcd.BLACK)
                img.draw_keypoints(kpts2, size=10, matched=True)
    lcd.display(img)
