# cc-by-sa 
# By: 連宏城 ted99.tw@gmail.com 
# Date: 2019.10.10
# 電腦視覺：檢測直線，使用Hough Transform
# http://en.wikipedia.org/wiki/Hough_transform
import car, sensor, image
car.init()
sensor.set_pixformat(sensor.RGB565) 
lcd.mirror(True)
# 直線的方法 "x1() y1() x2() y2()" 依次傳回端點值
# line()則為2端點所組成元組，可給"draw_line()"來畫線
while(True):
    img = sensor.snapshot()
    # theta_margin = 50 若二線角度相差小於50則合併
    # rho_margin = 50 若二線距離相差小於50則合併
    for l in img.find_lines(roi=(0,0,320,240), 
        threshold = 1000, theta_margin = 50, rho_margin = 50):
        img.draw_line(l.line(), color = (255, 0, 0), thickness=5)
    lcd.display(img)
