# cc-by-sa 
# By: 連宏城 ted99.tw@gmail.com 
# Date: 2019.10.10
# 電腦視覺：瞳孔偵測
import car, sensor, image
car.init()
sensor.set_contrast(3)
sensor.set_gainceiling(16)
lcd.mirror(True)
# 載入臉睛特徵
eyes_cascade = image.HaarCascade("eye", stages=24)
while (True):
    img = sensor.snapshot()
    # 偵測眼睛
    eyes = img.find_features(eyes_cascade, threshold=0.5, 
      scale_factor=1.5)
    # 偵測瞳孔
    for e in eyes:
        iris = img.find_eye(e)
        img.draw_rectangle(e)
        img.draw_cross(iris[0], iris[1])
    lcd.display(img)
