// Language: Processing
// thumbDragsterControl.pde

// by Sam Thongrong July 3, 2013
 
// load the serial library for Processing
import processing.serial.*; 
// instance of the serial class
Serial port;

// control commands array:
int[] controls = new int[] { 
  0x47, 0x67, 0x57, 0x77, 0x45, 0x65, 
  0x53, 0x73, 0x42, 0x62, 0x4c, 0x6c, 0x2c, 0x58 };
                   
// Image button. 
// Loading images and using them to create a button. 
ImageButtons LeftTurn;
ImageButtons RightTurn;
ImageButtons Stop;

ImageButtons Speed01;
ImageButtons Speed02;
ImageButtons Speed03;
ImageButtons Speed04;
ImageButtons Speed05;
ImageButtons Speed06;


// background
PImage bg;

// set the font
PFont myFont;

PImage speedImg;
int speed;

void controlGUI()
{
  bg = loadImage("background.jpg");
  background(bg);

  PImage turnSelected = loadImage("turnSelected.png");
  //left
  PImage leftImage = loadImage("left.png");
  PImage leftOver = loadImage("leftOver.png");
  LeftTurn = new ImageButtons(47, 110, 68, 65, 
                               leftImage, leftOver, turnSelected);
                               
  //right
  PImage rightImage = loadImage("right.png");
  PImage rightOver = loadImage("rightOver.png");
  RightTurn = new ImageButtons(362, 110, 68, 65, 
                               rightImage, rightOver, turnSelected);
                               
  //Stop
  PImage stopSelected = loadImage("stopSelected.png");
  PImage stopImage = loadImage("stop.png");
  PImage stopOver = loadImage("stopOver.png");
  Stop = new ImageButtons(362, 226, 52, 50, 
                               stopImage, stopOver, stopSelected);
  
  PImage speedSelected = loadImage("speedSelected.png");                            
  //Speed 1
  PImage speed1Image = loadImage("speed1.png");
  PImage speed1Over = loadImage("speed1Over.png");
  Speed01 = new ImageButtons(147, 110, 51, 65, 
                               speed1Image, speed1Over, speedSelected);

  //Speed 2
  PImage speed2Image = loadImage("speed2.png");
  PImage speed2Over = loadImage("speed2Over.png");
  Speed02 = new ImageButtons(216, 110, 51, 65, 
                               speed2Image, speed2Over, speedSelected);
                               
  //Speed 3
  PImage speed3Image = loadImage("speed3.png");
  PImage speed3Over = loadImage("speed3Over.png");
  Speed03 = new ImageButtons(287, 110, 51, 65, 
                               speed3Image, speed3Over, speedSelected);

  //Speed 4
  PImage speed4Image = loadImage("speed4.png");
  PImage speed4Over = loadImage("speed4Over.png");
  Speed04 = new ImageButtons(147, 195, 51, 65,  
                               speed4Image, speed4Over, speedSelected);
                               
  //Speed 5
  PImage speed5Image = loadImage("speed5.png");
  PImage speed5Over = loadImage("speed5Over.png");
  Speed05 = new ImageButtons(216, 195, 51, 65, 
                               speed5Image, speed5Over, speedSelected);

  //Speed 6
  PImage speed6Image = loadImage("speed6.png");
  PImage speed6Over = loadImage("speed6Over.png");
  Speed06 = new ImageButtons(287, 195, 51, 65, 
                               speed6Image, speed6Over, speedSelected);
                               
}

void setup()  {
  //===================
  // Mac OS 
  // List all the available serial ports in the output pane. 
  // You will need to choose the port that the Arduino board is 
  // connected to from this list. The first port in the list is 
  // port #0 and the third port in the list is port #2. 
  //println(Serial.list()); 
  // Open the port that the Arduino board is connected to 
  // (in this case #0) 
  // Make sure to open the port at the same speed Arduino is 
  // using (9600bps)
  // Change number in [...] of Serial list accordingly
  //port = new Serial(this, Serial.list()[1], 9600); 
  //===================
  //Windows (XP)
  // Bluetooth
  // On Windows, use "Outgoing" of the bluetooth device
  // Change COM port in "..." accordingly!
  //port = new Serial(this, "COM16", 115200);
  
  // XBee
  // Configure your XBee module to use 38400 baud rate
  // Change COM port in "..." accordingly!
  port = new Serial(this, "COM6", 38400);
  
  // screen size of the program
  size(480, 320);
  smooth();
  
  // test ellipse
  ellipseMode(RADIUS);
  textFont(createFont("Verdana", 14));
  
  speed = 0;
  
  controlGUI();
  
}

void renderSpeed(int speedVal)
{
  //speedImg = loadImage("speedN1.gif");
  //image(speedImg, 245, 35);
  
  if(speedVal == 0){
    speedImg = loadImage("speedN0.gif");
  }
  else if(speedVal == 1){
    speedImg = loadImage("speedN1.gif");
  }
  else if(speedVal == 2){
    speedImg = loadImage("speedN2.gif");
  }
  else if(speedVal == 3){
    speedImg = loadImage("speedN3.gif");
  }
  else if(speedVal == 4){
    speedImg = loadImage("speedN4.gif");
  }
  else if(speedVal == 5){
    speedImg = loadImage("speedN5.gif"); 
  }
  else if(speedVal == 6){
    speedImg = loadImage("speedN6.gif");
  }
  
  image(speedImg, 245, 35);
}

void updateDisplay() {
  
  LeftTurn.update();
  LeftTurn.display();
  
  RightTurn.update();
  RightTurn.display();
  
  Stop.update();
  Stop.display();
  
  Speed01.update();
  Speed01.display();
  
  Speed02.update();
  Speed02.display();
  
  Speed03.update();
  Speed03.display();
  
  Speed04.update();
  Speed04.display();
  
  Speed05.update();
  Speed05.display();
  
  Speed06.update();
  Speed06.display();
  
}

//Send Commands 
void sendCommands() {

  // left
  if(LeftTurn.pressed) {
      port.write(controls[0]);
      //println("Grip In: " + (char)controls[0]);
  }
  // right
  if(RightTurn.pressed) {
      port.write(controls[1]);
      //println("Grip Out: " + (char)controls[1]);
  }

  // stop
  if(Stop.pressed) {
      speed = 0;
      port.write(controls[2]);
      //println("Wrist Up: " + (char)controls[2]);
  } 
  
  //Speed01
  if(Speed01.pressed) {
      speed = 1;
      port.write(controls[3]);
      //println("Wrist Down: " + (char)controls[3]);
  }

  // Speed02
  if(Speed02.pressed) {
      speed = 2;
      port.write(controls[4]);
      //println("Elbow Up: " + (char)controls[4]);
  }
  
  // Speed03
  if(Speed03.pressed) {
      speed = 3;
      port.write(controls[5]);
      //println("Elbow Down: " + (char)controls[5]);
  }

  //Speed 4
  if(Speed04.pressed) {
      speed = 4;
      port.write(controls[6]);
      //println("Shoulder Up: " + (char)controls[6]);
  } 
  // Speed 5  
  if(Speed05.pressed) {
      speed = 5;
      port.write(controls[7]);
      //println("Shoulder Down: " + (char)controls[7]);
  }
  
  // Base
  if(Speed06.pressed) {
      speed = 6;
      port.write(controls[8]);
      //println("Base Rotate CW: " + (char)controls[8]);
  } 
}

void draw()
{
  renderSpeed(speed);
  updateDisplay();
  
  sendCommands();
}

// Button & ImageButtons Classes
class Button
{
  int x, y;
  int w, h;
  color basecolor, highlightcolor;
  color currentcolor;
  boolean over = false;
  boolean pressed = false;   
  
  void pressed() {
    if(over && mousePressed) {
      pressed = true;
    } else {
      pressed = false;
    }    
  }
  
  boolean overRect(int x, int y, int width, int height) {
  if (mouseX >= x && mouseX <= x+width && 
      mouseY >= y && mouseY <= y+height) {
    return true;
  } else {
    return false;
  }
 }
}

class ImageButtons extends Button 
{
  PImage base;
  PImage roll;
  PImage down;
  PImage currentimage;

  ImageButtons(int ix, int iy, int iw, int ih, 
               PImage ibase, PImage iroll, PImage idown) 
  {
    x = ix;
    y = iy;
    w = iw;
    h = ih;
    base = ibase;
    roll = iroll;
    down = idown;
    currentimage = base;
  }
  
  void update() 
  {
    over();
    pressed();
    if(pressed) {
      currentimage = down;
    } else if (over){
      currentimage = roll;
    } else {
      currentimage = base;
    }
  }
  
  void over() 
  {
    if( overRect(x, y, w, h) ) {
      over = true;
    } else {
      over = false;
    }
  }
  
  void display() 
  {
    image(currentimage, x, y);
  }
}
