// 12 Thumbs Dragster with drv8833 motor driver
// June 29, 13

// Software Serial
#include <SoftwareSerial.h>
// Servo
#include <Servo.h>

#define ServoPin 8

Servo servoTurn;
int angle = 90;
int trimAngle = 3;

//  2 - receive  TX   (Send from XBee, Receive to Arduino)
//  3 - send     RX   (Send from Arduino, Receive to XBee) 
SoftwareSerial thumbSerial = SoftwareSerial(2, 3);

// control commands array
int controls[14] = {0x47, 0x67, 0x57, 0x77, 0x45, 0x65, 0x53, 
                    0x73, 0x42, 0x62, 0x4c, 0x6c, 0x2c, 0x58};

int incomingByte;

// Motor#1
int motorP = 5;   //used Arduino D5 PWM pin, for adjustable motor speed
int motorN = 6;   //used Arduino D6 PWM pin, for adjustable motor speed

// LED ON and OFF action
int ledLight = 13;

void motorForward(int speedVal) {
  digitalWrite(motorP, HIGH);  
  analogWrite(motorN, speedVal);
}

void motorStop() {
  digitalWrite(motorP, LOW);  
  digitalWrite(motorN, LOW);
}

// Servo
void trimLeft(){ 
  servoTurn.write(angle + trimAngle);               
  delay(5); 
  servoTurn.write(angle);
  delay(5); 

}

void trimRight(){
  servoTurn.write(angle - trimAngle);               
  delay(5); 
  servoTurn.write(angle);
  delay(5);
}


void setup() {
  
 pinMode(ledLight, OUTPUT);
 digitalWrite(ledLight, LOW);
  
 // Motor
 pinMode(motorP, OUTPUT);
 pinMode(motorN, OUTPUT);
 
 digitalWrite(motorP, LOW);
 digitalWrite(motorN, LOW);
  
 // Xbee Comm. via SoftwareSerial pin 2, 3
 thumbSerial.begin(38400);
 
 servoTurn.attach(ServoPin);
 servoTurn.write(angle);
 delay(20);
 
}

void loop() {
  
  // XBee Comm.
  if(thumbSerial.available()) {
    incomingByte = thumbSerial.read();
    
    // left trim
    if(incomingByte == controls[0]){
      trimLeft();
    }
    // right trim
    else if(incomingByte == controls[1]){
      // right trim
      trimRight();
    }
    // stop
    else if(incomingByte == controls[2]){
      // stop
      motorStop();
      //
    }
    // Speed 1
    else if(incomingByte == controls[3]){
      // Speed 1
      motorForward(1);
    }
    // speed 2
    else if(incomingByte == controls[4]){
      // Speed 2
      motorForward(2);
    } 
    // speed 3 
    else if(incomingByte == controls[5]){
      // Speed 3
      motorForward(3);
    }
    // speed 4
    else if(incomingByte == controls[6]){
      // Speed 4
      motorForward(4);
    }
    // speed 5
    else if(incomingByte == controls[7]){
      // Speed 5
      motorForward(5);
    }
    // speed 6
    else if(incomingByte == controls[8]){
      // Speed 6
      motorForward(6);
    }
  } 
  // pause for 100 milliseconds
  delay(100);
}

