#define pin A1// distance sensor to analog 1

int E1 = 5;     //M1 Speed Control
int E2 = 6;     //M2 Speed Control
int M1 = 4;     //M1 Direction Control
int M2 = 7;     //M1 Direction Control
void stop(void)                    //stop
{
  digitalWrite(E1,0); 
  digitalWrite(M1,LOW);    
  digitalWrite(E2,0);   
  digitalWrite(M2,LOW);    
}   
void advance(char a,char b)          //forward
{
  analogWrite (E1,a);      //PWM Speed Control
  digitalWrite(M1,LOW);    
  analogWrite (E2,b);    
  digitalWrite(M2,LOW);
}  
void back_off (char a,char b)          //backward
{
  analogWrite (E1,a);
  digitalWrite(M1,HIGH);   
  analogWrite (E2,b);    
  digitalWrite(M2,HIGH);
}
void turn_L (char a,char b)             //left
{
  analogWrite (E1,a);
  digitalWrite(M1,LOW);    
  analogWrite (E2,b);    
  digitalWrite(M2,HIGH);
}
void turn_R (char a,char b)             //right
{
  analogWrite (E1,a);
  digitalWrite(M1,HIGH);    
  analogWrite (E2,b);    
  digitalWrite(M2,LOW);
}
void setup() {
  // put your setup code here, to run once:
  int i;
  for(i=4;i<=7;i++)
    pinMode(i, OUTPUT); 
    pinMode(8,INPUT);
    pinMode(9,INPUT);
    pinMode (pin,INPUT);
    Serial.begin(9600);
}
int left=0;
int right=0;

void loop() {
  // put your main code here, to run repeatedly:
uint16_t value = analogRead (pin);
int x= get_gp2d120x (value); 
  left=digitalRead(8);
  right=digitalRead(9);
  Serial.println(x);
  if(!left && !right && x>15)
   {
     advance(100,100);
   } 
   else if((!left && !right&& x>8 && x<15)||(left &&right))
   {
    stop();
   }
   else if(!left && !right&& x<8)
   {
    back_off(100,100);
   }
   else if(!left && right)
   {
   turn_L(100,100);
   }
   else if(left && !right)
   {
   turn_R(100,100);
   }

}
double get_gp2d120x (uint16_t value) {
        if (value < 16)  value = 16;
        return 2076.0 / (value - 11.0);
}
    

