/*
  fingerprint.ino

  Author:Vigoss.kk
  www.elecrow.com
  2013-10-6
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include <Adafruit_Fingerprint.h>
#include <SoftwareSerial.h>
#include <Streaming.h>
#include <Servo.h>

#define __Debug         1                               // if debug mode

const int pinServo      = 6;                            // servo pin
const int angleServo    = 60;                           // Rotation angle

#if __Debug
#define DBG(X)          Serial.println(X)
#else
#define DBG(X)
#endif

SoftwareSerial mySerial(A5, A4);                                // tx, rx

Adafruit_Fingerprint finger = Adafruit_Fingerprint(&mySerial);
Servo myservo;                                                  // create servo object to control a servo

void open_close_door()
{
    myservo.attach(pinServo);
    for(int i=20; i<angleServo; i++)
    {
        myservo.write(i);
        delay(5);
    }

    delay(2000);

    for(int i=(angleServo-1); i>=20; i--)
    {
        myservo.write(i);
        delay(5);
    }
    myservo.detach();


}


void setup()
{

    Serial.begin(38400);
    finger.begin(19200);
    delay(500);
    DBG("setup ok!");
}

void loop()                     // run over and over again
{
    if(getFingerprintIDez()>=0)
    {
        open_close_door();
        DBG("get right finger, open door now!!");
        
        delay(2000);
    }
    delay(50);
}


// returns -1 if failed, otherwise returns ID #
int getFingerprintIDez()
{

    if (!finger.verifyPassword())
    {
        DBG("Did not find fingerprint sensor :(");
        return -1;
    }

    uint8_t p = finger.getImage();
    if (p != FINGERPRINT_OK)
    {
        return -1;
    }

    p = finger.image2Tz();
    if (p != FINGERPRINT_OK)
    {
        return -1;
    }

    p = finger.fingerFastSearch();
    if (p != FINGERPRINT_OK)
    {
        return -1;
    }

#if __Debug
    Serial.print("Found ID #");
    Serial.print(finger.fingerID);
    Serial.print(" with confidence of ");
    DBG(finger.confidence);
#endif

    return finger.fingerID;

}

/*********************************************************************************************************
  END FILE
*********************************************************************************************************/