#include <Wire.h>
#include <ServoShield2.h>

ServoShield2 servos = ServoShield2(127);//Address of 127, using 50Hz mode

const int trig = A3; //trigger input pin - must use analog
const int min = 600; //servo min and max positions
const int max = 2600;
const int thresh = 300; //threshold for trigger
int pinValue = 0;
int trigDelay = 600; //debounce delay for trigger

void setup() {
  Serial.begin(9600); 
  Serial.println("Initializing...");
  servos.start();
  
  for (int servo = 0; servo < 16; servo++)//Initialize all 16 servos
  {
    servos.setbounds(servo, min, max);  //Set the minimum and maximum pulse duration of the servo
    servos.setposition(servo, (max-min)/2);      //Set the initial position of the servo
  }
  
  digitalWrite(trig, LOW);
  Serial.println("Init Done");
  delay (500);
}

void loop() {
  
  pinValue = analogRead(trig);
  Serial.println(pinValue);
  
  // if the trigger value is high enough, set a random position for each of the 6 attached servos
  if (pinValue > thresh) {
    for (int i = 0; i < 6; i++){
      int j = map(random(1000), 0, 1000, min, max);
      servos.setposition(i, j);
    }
    Serial.println("Servos set");
    
    //debounce trigger by delaying
    delay(trigDelay);
  }
}
