/*ServoMath v1
By Steven R. Cypherd 2/10/2013
using my Servo Math from my article 'Servos Unscrambled'
A standard servo is 5.556 microseconds(us)per degree(UPD)
The low range is 400 - 1000
Find your angle in 78 * 5.556 + 1000 = 1433.368us
Use this with delayMicrosecons() with Arduinos
Use your Pulsout unit to calculate the pulsout integer
In this case it is 5, 1433.368 / 5 = 287
Pulsout port, 287 is 78 degrees on a sevo
Most of my servo are 8 UPD
Tower Pro SG90 UPD-8, LR-450, HA-220
hitec HS-300   UPD-8, LR-800, HA 200
Micro ?        UPD-8, LR-800, HA-180
You must open a Serial Monitor to run my program.
You need a port button and light setup
Set low range first
run set UPD
Adjust for square 90
adjust High angle
us-Microseconds, ms-Milliseconds
Push the button for commands
10 - Angle
20 - Low Range
30 - Set Microseconds Per Degree
35 - Auto set UPD
40 - High Angle
50 - Run full test
55 - Auto run test
60 - True 90
70 - Info
75 - Show Angle
100 - Turn of servo
*/

//Ports
#define servo1      11
#define btn1        10 //B1-Port-10K to G, B2-V+
#define lit1        9 //Led+470R to port, Led- G
//Defines - Bit flags
#define lit1On      0 //System Flags
#define svr1On      1
#define setA90      2
#define runTest     3
#define btnDwn      4
#define shwCmd      5
#define svrOff      6
#define stLtlAng    7
#define nwAngLess   8
#define fTrue90     9
#define autRunT     10
#define autRunP     11
#define comRdy      12
#define setUPD      13
#define shwAngle    14
//Constants
//5.556 is not used anymore. Most servos are 8UPD
#define svrUPD      8.0 //Microseconds(us) Per Degree(UPD)
#define rFrshRate   50 //Nornal refresh
#define svrSetRsh   20 //Set up refresh
#define svrSetCnt   15 //Set up count
#define sLowRset    1000 //Low Range
#define sHiAset     180 //High Angle
#define testSet     1000 //Test delay
#define litSet      200 //Light blink

//Variables
int    litCnt = litSet;
int    tmp1 = 0;
int    tmp2 = 0;
int    btnIn = 0;
int    cmd1 = 0;
int    cntTest = testSet;
int    cntSetSrv = 0;
int    rshSetSrv = svrSetRsh;
int    reFresh = rFrshRate;
int    svr1Lrng = sLowRset;
int    svr1Hang = sHiAset;
int    sAngle = 90;
int    lastAng = 0;
int    tmpAng = 0;
unsigned int  pulsAng = 0;
unsigned int  sFlags = 0;
float  curUPD = svrUPD;
float  fTmp1;
float  fTmp2;
byte   testA = 1;

void setup() {
  pinMode(servo1, OUTPUT);
  pinMode(lit1, OUTPUT);
  pinMode(btn1, INPUT);
  Serial.begin(9600);
  bitWrite( sFlags, shwCmd, 1);
}

void loop() {
   if (bitRead( sFlags, comRdy) == 0 ){
     tmp1 = tmp1 + 1;//Waits for Com to open
     if( tmp1 > 10000 ){
         bitWrite( sFlags, comRdy, 1);
         Serial.println("Push Button for Commands");
       }
   }
  
  delay(1);
  litCnt--;//Blinking light
  if (litCnt == 0){
    litCnt = litSet;
    if (bitRead( sFlags, lit1On) == 0 ){
      digitalWrite(lit1, HIGH);
      bitWrite( sFlags, lit1On, 1);
      }
    else {
      digitalWrite(lit1, LOW);
      bitWrite( sFlags, lit1On, 0);
      }
    }

//Run full test on the servo
if ( cntSetSrv == 0 && bitRead( sFlags, runTest) == 1 ){
    if( bitRead( sFlags, autRunP) == 1){
      bitWrite( sFlags, autRunP, 0);
      Serial.println("Auto-Runnig Servo Test");
      Serial.print("High Angle ");
      Serial.println(svr1Hang);
      Serial.print("Low Range ");
      Serial.println(svr1Lrng);
      Serial.print("Current UPD ");
      Serial.println(curUPD, 4);
      Serial.print("Push Button ");
      Serial.println("To Stop Test");
      }
    cntTest--;//Servo Test
    if( cntTest == 0 ){
      cntTest = testSet;
      if( testA == 1){
        sAngle = 0;
        testA = 2;
        }
      else if( testA == 2 ){
        sAngle = 90;
        testA = 3;
        }
      else if( testA == 3 ){
        sAngle = svr1Hang;
        testA = 1;
        }
      pulsePin( servo1, sAngle );
      if( bitRead( sFlags, shwAngle) == 1){
        Serial.print("Angle ");
        Serial.print(sAngle);
        Serial.print(", US ");
        Serial.println(pulsAng);
        }
      }
    }

//Set and Refresh the servo  
  if ( bitRead( sFlags, svr1On) == 1 ){
    if( cntSetSrv > 0 ){
      rshSetSrv--;
      if( rshSetSrv <= 0 ){
        rshSetSrv = svrSetRsh;
        cntSetSrv--;
        pulsePin( servo1, sAngle );
        }
      }
    else {
      reFresh--;
      if( reFresh <= 0 ){
        reFresh = rFrshRate;
        pulsePin( servo1, sAngle );
        }      
      }
    }
  
  //After angle is set turn off the servo
  if( cntSetSrv == 0 && bitRead( sFlags, svrOff) == 1 ){
    bitWrite( sFlags, svr1On, 0);
    bitWrite( sFlags, svrOff, 0);
    bitWrite( sFlags, shwCmd, 1);
    Serial.println("Servo is Off");
    }
 
  //When setting a small angle set bigger jump
  //first then the angle.
  if( cntSetSrv == 0 && bitRead( sFlags, stLtlAng) == 1 ){
    bitWrite( sFlags, stLtlAng, 0);
    sAngle = tmpAng;
    pulsePin( servo1, sAngle );
    }

doBtn://Run a port button
      //B1 10K to ground, 220 to port
      //B2 VDD
  btnIn = digitalRead(btn1);
  if (btnIn == 1 && bitRead( sFlags, btnDwn) == 0 ){ //&& bitRead( sFlags, btnDwn) == 0
    cmd1 = 0;
    bitWrite( sFlags, btnDwn, 1);
    if ( bitRead( sFlags, setUPD) == 1 ){
      Serial.println("Enter New UPD(float), 0 to stop");
      fTmp1 = getFlt();
      if( fTmp1 == 0 ){
        Serial.println("UPD test stopped");
        bitWrite( sFlags, setUPD, 0);
        bitWrite( sFlags, runTest, 0);
        bitWrite( sFlags, svrOff, 1);
        bitWrite( sFlags, setA90, 1);
        }
      else {
        Serial.print("New UPD ");
        Serial.println(fTmp1, 4);
        curUPD = fTmp1;
        }
      }
    else if( bitRead( sFlags, runTest) == 1){
      bitWrite( sFlags, runTest, 0);
      Serial.println("Test stopped");
      bitWrite( sFlags, svrOff, 1);
      bitWrite( sFlags, setUPD, 0);
      bitWrite( sFlags, setA90, 1);
      }
    else if( bitRead( sFlags, fTrue90) == 1 ){
      bitWrite( sFlags, fTrue90, 0);
      sAngle = tmpAng;
      lastAng = 2;
      pulsePin( servo1, sAngle );
      bitWrite( sFlags, shwCmd, 1);
      }
    else {
      Serial.println("10 Angle");
      Serial.println("20 Low Range");
      Serial.println("30 UPD");
      Serial.println("35 set up UPD");
      Serial.println("40 High Angle");
      Serial.println("50 Run Test");
      Serial.println("55 Auto Run");
      Serial.println("60 True 90");
      Serial.println("70 Info");      
      Serial.println("75 show Angle");      
      Serial.println("100 Off Servo");
      Serial.println("Enter Command");
      cmd1 = getInt();
      }
    }//Button Read
  
  //Commands -----------------------
  if( cmd1 == 0 ) goto chkBtn;  
  if( cmd1 == 10 ){
    Serial.println("Enter Angle");
    sAngle = getInt();
    Serial.print("Angle ");
    Serial.print(sAngle);
    Serial.println(" set.");
    chkLtAng();
    lastAng = 2;
    pulsePin( servo1, sAngle );
    bitWrite( sFlags, shwCmd, 1);
    }
  else if( cmd1 == 20 ){
    Serial.print("Low Range is ");
    Serial.println(svr1Lrng);
    Serial.println("Enter Low Range");
    svr1Lrng = getInt();
    Serial.print("Low Range ");
    Serial.print(svr1Lrng);
    Serial.println(" set.");
    if( bitRead( sFlags, autRunT) == 1){
      bitWrite( sFlags, autRunP, 1);
      bitWrite( sFlags, runTest, 1);
      }
    else {
      bitWrite( sFlags, setA90, 1);
      bitWrite( sFlags, shwCmd, 1);
      }
    }
  else if( cmd1 == 30 ){
    Serial.println("set UPD");
    curUPD = getFlt();
    Serial.print("UPD ");
    Serial.println(curUPD, 4);
    if( bitRead( sFlags, autRunT) == 1){
      bitWrite( sFlags, autRunP, 1);
      bitWrite( sFlags, runTest, 1);
      }
    else {
      bitWrite( sFlags, setA90, 1);
      bitWrite( sFlags, shwCmd, 1);
      }
    }
  else if( cmd1 == 35 ){
    Serial.println("Running set UPD");
    Serial.println("Push button to set UPD(float)");
    Serial.println("  or 0 to stop");
    Serial.println("Set low range first");
    Serial.println("Set servo horn to zero");
    Serial.print("Current UPD ");
    Serial.println(curUPD, 4);
    testA = 1;
    cntTest = 1;
    bitWrite( sFlags, setUPD, 1);
    bitWrite( sFlags, runTest, 1);
    bitWrite( sFlags, shwCmd, 1);
    }
  else if( cmd1 == 40 ){
    Serial.print("High Angle is ");
    Serial.println(svr1Hang);
    Serial.println("Enter High Angle");
    svr1Hang = getInt();
    Serial.print("High Angle ");
    Serial.print(svr1Hang);
    Serial.println(" set.");
    if( bitRead( sFlags, autRunT) == 1){
      bitWrite( sFlags, autRunP, 1);
      bitWrite( sFlags, runTest, 1);
      }
    else {
      bitWrite( sFlags, setA90, 1);
      bitWrite( sFlags, shwCmd, 1);
      }
    }
  else if( cmd1 == 50 ){
    Serial.println("Runnig Servo Test");
    Serial.print("High Angle ");
    Serial.println(svr1Hang);
    Serial.print("Low Range ");
    Serial.println(svr1Lrng);
    Serial.print("Current UPD ");
    Serial.println(curUPD, 4);
    Serial.print("To Stop Test ");
    Serial.println("Push Button");
    bitWrite( sFlags, runTest, 1);
    testA = 1;
    cntTest = 1;
    bitWrite( sFlags, shwCmd, 1);
    }
  else if( cmd1 == 55 ){
    if( bitRead( sFlags, autRunT) == 1){
      bitWrite( sFlags, autRunT, 0);
      bitWrite( sFlags, autRunP, 0);
      Serial.println("Auto Test Off");
      }
    else {
      bitWrite( sFlags, autRunT, 1);
      bitWrite( sFlags, autRunP, 1);
      Serial.println("Auto Test On");
      }
    bitWrite( sFlags, shwCmd, 1);
    }
  else if( cmd1 == 60 ){
    Serial.println("Enter Angle in us");
    tmp1 = getInt();
    Serial.println("Angle-");
    Serial.println(tmp1);
    tmpAng = sAngle;
    sAngle = tmp1;
    lastAng = tmp1;
    bitWrite( sFlags, fTrue90, 1);
    bitWrite( sFlags, shwCmd, 1);
    cntSetSrv = svrSetCnt;
    rshSetSrv = svrSetRsh;
    pulsAng = sAngle;
    pulsePin( servo1, sAngle );
    }
  else if( cmd1 == 70 ){
    Serial.println("Servo Info");
    Serial.print("High Angle ");
    Serial.println(svr1Hang);
    Serial.print("Low Range ");
    Serial.println(svr1Lrng);
    Serial.print("Current UPD ");
    Serial.println(curUPD, 4);
    bitWrite( sFlags, shwCmd, 1);
    }
  else if( cmd1 == 75 ){
    //Show angle detail
    bitWrite( sFlags, shwCmd, 1);
    if( bitRead( sFlags, shwAngle) == 0){
      bitWrite( sFlags, shwAngle, 1);
      Serial.println("Angle deail On");
      }
    else {
      bitWrite( sFlags, shwAngle, 0);
      Serial.println("Angle deail Off");
      }
    }
  else if( cmd1 == 100 ){
    Serial.println("Turning Off Servo");
    bitWrite( sFlags, svrOff, 1);
    bitWrite( sFlags, shwCmd, 1);
    }
  else {
    Serial.println("Try another..");
    bitWrite( sFlags, shwCmd, 1);
    }//Command Functions
  cmd1 = 0;
   
chkBtn://set 90 on the servo
  if(bitRead( sFlags, setA90) == 1 ){
    bitWrite( sFlags, setA90, 0);
    lastAng = 2;//Clear last angle
    sAngle = 90;
    pulsePin( servo1, sAngle );
    }
  
  //Print the command    
  if(bitRead( sFlags, shwCmd) == 1 ){
    bitWrite( sFlags, shwCmd, 0);
    Serial.println("Push Button for Commands");
    }
  
  //Clear button down flag
  //when the user lets go of it
  btnIn = digitalRead(btn1);
  if (btnIn == 0 && bitRead( sFlags, btnDwn) == 1){
     bitWrite( sFlags, btnDwn, 0);
    }
}//Main Loop

//Subroutines ***********************
int getInt() {
  tmp2 = 0;
  while( tmp2 == 0 ) {
    tmp2 = Serial.available();
    if( tmp2 > 0 ) {
      tmp2 = Serial.parseInt();
      break;
      }    
    }
  return tmp2; 
  }
  
float getFlt(){
  tmp1 = 0;
  while( tmp1 == 0 ) {
    tmp1 = Serial.available();
    if( tmp1 > 0 ) {
      fTmp2 = Serial.parseFloat();
      break;
      }    
    }
  return fTmp2; 
  }
  
void pulsePin( int pPin, int pAng ){
  if( bitRead(sFlags, svr1On) == 0 ){
    bitWrite( sFlags, svr1On, 1);
    }
  if( lastAng != pAng ) {
    cntSetSrv = svrSetCnt;
    rshSetSrv = svrSetRsh;
    lastAng = pAng; 
    if( pAng == 0 ){
      pAng = svr1Lrng;
      }
    else {
      pAng = pAng * curUPD;//Angle * 5.556(us per degree)
      pAng = pAng + svr1Lrng;//Add Low Range to make
      }                      //servo angle
    pulsAng = (unsigned int)pAng;
    }
  digitalWrite(pPin, HIGH);//Set Servo Angle
  delayMicroseconds(pulsAng);
  digitalWrite(pPin, LOW);
  return;
  }

void chkLtAng(){
  if( sAngle < lastAng ){
    tmp1 = sAngle - lastAng;
    bitWrite( sFlags, nwAngLess, 1);
    }
  else {
    tmp1 = lastAng - sAngle;
    bitWrite( sFlags, nwAngLess, 0);
    }
  if( tmp1 < 10 ){
    tmpAng = sAngle;
    bitWrite( sFlags, stLtlAng, 1);
    if( bitRead( sFlags, nwAngLess) == 1 ){
      sAngle = sAngle - 20;
      if( sAngle < 0 ) sAngle = 20;
      }
    else {
      sAngle = sAngle + 20;
      if( sAngle > svr1Hang ) sAngle = svr1Hang - 20;
      }
    }
  return;
  }
