//Pines de conexión del driver
int Pin_Motor_Der_A = 6;
int Pin_Motor_Der_B = 9;
int Pin_Motor_Izq_A = 10;
int Pin_Motor_Izq_B = 11;


int tiempo=0;


char cmd[100];
int cmdIndex;

int derSpeed=0, izqSpeed=0;


boolean cmdStartsWith(const char *st) {

  for(int i=0; ; i++) {
    
    if(st[i]==0) return true;
    if(cmd[i]==0) return false;
    if(cmd[i]!=st[i]) return false;;
  }
  
  return false;
}



void exeCmd() {
  
  if(cmdStartsWith("der ")) {
    derSpeed = atoi(cmd+4);
    tiempo=0;
  }

  if(cmdStartsWith("izq ")) {
    izqSpeed = atoi(cmd+4);
    tiempo=0;
  }

  Mover(derSpeed, izqSpeed);
}


void setup() {
  // inicializar la comunicación serial a 9600 bits por segundo:
  Serial.begin(9600);
  // configuramos los pines como salida
  pinMode(Pin_Motor_Der_A, OUTPUT);
  pinMode(Pin_Motor_Der_B, OUTPUT);
  pinMode(Pin_Motor_Izq_A, OUTPUT);
  pinMode(Pin_Motor_Izq_B, OUTPUT);

  Mover_Stop();

  cmdIndex = 0;

}

void loop() {

  if(Serial.available()) {
    
    char c = (char)Serial.read();
    
    if(c=='\n') {
      cmd[cmdIndex] = 0;
      exeCmd();  // execute the command
      cmdIndex = 0; // reset the cmdIndex
    } else {      
      cmd[cmdIndex] = c;
      if(cmdIndex<99) cmdIndex++;
    }
      
  }

  else {
    if(tiempo<200) { // 200 cilcos de 1ms 
      tiempo=tiempo+1;
    }
    else {  //ya transcurrió 200ms (200 ciclos)
      Mover_Stop();
    }
       
    delay(1); //pasusa de 1ms por ciclo
  }

}



void Mover(int16_t derSpeed, int16_t izqSpeed) { // speed -255 to 255 (0 = stop)

  if(derSpeed < 0) {
    derSpeed = -derSpeed;
    digitalWrite (Pin_Motor_Der_A, LOW );
    analogWrite (Pin_Motor_Der_B, derSpeed );
  }
  else {
    analogWrite (Pin_Motor_Der_A, derSpeed);
    digitalWrite (Pin_Motor_Der_B, LOW);
  }

  if(izqSpeed < 0) {
    izqSpeed = -izqSpeed;
    digitalWrite (Pin_Motor_Izq_A, LOW );
    analogWrite (Pin_Motor_Izq_B, izqSpeed );
  }
  else {
    analogWrite (Pin_Motor_Izq_A, izqSpeed);
    digitalWrite (Pin_Motor_Izq_B, LOW);
  }
  
}


void Mover_Stop() {
  digitalWrite (Pin_Motor_Der_A, LOW);
  digitalWrite (Pin_Motor_Der_B, LOW);
  digitalWrite (Pin_Motor_Izq_A, LOW);
  digitalWrite (Pin_Motor_Izq_B, LOW);
}
