#include <Adafruit_GFX.h>
#include <gfxfont.h>

#include <Adafruit_SSD1306.h>


#include <Wire.h>
#define buttonup       A2
#define buttonhold     A1
#define buttonlightup  A3
 #define lux0        0.25168
 #define lux1        0.12584
 #define lux2        0.06292
 #define lux3        0.0314
 #define lux4        0.01573
 #define lux5        0.00786
 #define multiplyer       255
#define writeaddress 0x10
#define lightpin 12
#define offset 50
/////////////////////////////////////////////display/////////////////////////////////////////////////////////////////////////
#define OLED_RESET 4
Adafruit_SSD1306 display(OLED_RESET);

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// hold button at A1,senstivity button at a2

void setup() {
  pinMode(buttonup, INPUT_PULLUP);
  pinMode(buttonhold, INPUT_PULLUP);
  pinMode(buttonlightup, INPUT_PULLUP);
  pinMode(lightpin, OUTPUT);
  Wire.begin();             
  //Serial.begin(9600);      
////////////////////////////////////////////display//////////////////////////////////////////////////////////////////////////
display.begin(SSD1306_SWITCHCAPVCC, 0x3C);

  /////////////////////////////////////////////////////////////////////////////////////////////
  
}
 unsigned long     readingR   = 0;
 unsigned long     readingG   = 0;
 unsigned long     readingB   = 0;
 unsigned long     readingW   = 0;
 unsigned long     readingMax = 0;
 unsigned int     reading = 0;
 
 
unsigned int senstivity = 0;
int holdtrue=0;//variable that ckecks if hold mode is on
int lightState=0;//variable that tells if the led needs to be turned on or of
int holdexecute=1;//used to refresh display ones,when hold mode executes
int itiration=0;//adjusts refresh rate


void loop() 
{
double x=lux0;
double colorR=0;
double colorG=0;
double colorB=0;
double colorW=0;
  //////////////////////////////////////////////////////BUTTONS//////////////////////////////////////////
if (digitalRead(buttonlightup)==LOW)
                      {   delay(500);
                          if(lightState==LOW)
                          {lightState=HIGH;}
                          else{lightState=LOW;}
                         
                          }
                           digitalWrite(lightpin,lightState);
   
if (digitalRead(buttonhold)==LOW)
                       {  delay(500);
                          if(holdtrue==0)
                          {holdtrue=1;
                          holdexecute=0;
                          }
                          else{holdtrue=0;
                          }
                          }

if (digitalRead(buttonup)==LOW)
                       {   
senstivity++; if (senstivity>5){senstivity=0;}
if(senstivity==0){x=lux0;readingMax= 16496;}
if(senstivity==1){x=lux1;readingMax=  8248;}
if(senstivity==2){x=lux2;readingMax=  4124;}
if(senstivity==3){x=lux3;readingMax=  2062;}
if(senstivity==4){x=lux4;readingMax=  1031;}
if(senstivity==5){x=lux5;readingMax= 515.4;}
                          display.clearDisplay();
                          display.setCursor(0,0);
                          display.print("MAX (S) :");
                          display.print(readingMax);
                          display.print(" (");
                          display.print(senstivity);
                          display.print(")");
                          display.display();
                          delay(1500);
                          display.clearDisplay();
                          }
                         

                ///////////////////////////////////////////////////////////I2C//////////////////////////////////////
  Wire.beginTransmission(writeaddress);
  Wire.write(byte(0x00));
  Wire.write(byte(senstivity<<4));
 // Wire.write(byte(0x00));
  Wire.write(byte(0x00));
  Wire.endTransmission();      

 
  delay(10);                  
 //R
  Wire.beginTransmission(writeaddress); 
  Wire.write(0x08);    
  Wire.endTransmission(false);  
  Wire.requestFrom(0x10,2);
  while(Wire.available()) 
  {
    reading = Wire.read(); 
    reading =reading+ (Wire.read() * multiplyer);
    Wire.end();
    
}
readingR =reading;
delay(2);

//G

   
  Wire.beginTransmission(writeaddress); 
  Wire.write(0x09);    
  Wire.endTransmission(false);  
  Wire.requestFrom(0x10,2);
  while(Wire.available()) 
  {
    reading = Wire.read(); 
    reading =reading+ (Wire.read() * multiplyer);
    Wire.end();
}

readingG =reading;
delay(2);
 //B
  Wire.beginTransmission(writeaddress); 
  Wire.write(0x0A);    
  Wire.endTransmission(false);  
  Wire.requestFrom(0x10,2);
  while(Wire.available()) 
  {
    reading = Wire.read(); 
    reading =reading+ (Wire.read() * multiplyer);
    Wire.end();
  }

readingB =reading;
delay(2);
   //W
  Wire.beginTransmission(0x20); 
  Wire.write(0x0B);    
  Wire.endTransmission(false);  
  Wire.requestFrom(0x10,2);
  while(Wire.available()) 
  {
    reading = Wire.read(); 
    reading =reading+ (Wire.read() * multiplyer);
    Wire.end();
  }
    
readingW =reading;
delay(2);

///////////////////////////////////////////////////////////////////////lux calc/////////////////////////////////////////////////////////
if(senstivity==0)
{
  x=lux0;
readingMax= 16496;
}

if(senstivity==1)
{
x=lux1;
readingMax=8248;
}
if(senstivity==2)
{
x=lux2;
readingMax= 4124;
}
if(senstivity==3)
{
x=lux3;
readingMax=2062;
}
if(senstivity==4)
{
x=lux4;
readingMax=1031;
}
if(senstivity==5)
{
x=lux5;
readingMax= 515.4;
}

readingR=readingR*x;
readingG=readingG*x;
readingB=readingB*x;
readingW=readingW*x;
/*
  //////////////////////////////////////////////////////////debugger///////////////////////////////////
  Serial.println("r");  
  Serial.print(readingR); 

  Serial.println(" lux");
  Serial.println("g");
  Serial.print(readingG);
 
  Serial.println(" lux"); 
  Serial.println("b");
  Serial.print(readingB);

  Serial.println(" lux"); 
  Serial.println("w");
  Serial.print(readingW);
  
  Serial.println(" lux");
  Serial.println("sensval");
  Serial.println(readingMax);
  
*/
  ////////////////////////////////////////////////////////////display words///////////////////////////////////////////////////////////////////
  
  display.setTextSize(1);
  display.setTextColor(WHITE);
  display.setCursor(0,0);


  
  display.print("R:");
  display.print(readingR);
  if(readingR>readingMax-offset){display.print("!");} 
  display.println();
  display.print("G:");
  display.print(readingG);
  if(readingG>readingMax-offset){display.print("!");}
  display.println();
  display.print("B:");
  display.print(readingB);
  if(readingB>readingMax-offset){display.print("!  ");}  
  display.setCursor(55,17);
  display.print("W:");
  display.print(readingW);

  if(readingW>readingMax-offset){display.print("!");}
  display.println();
  display.setCursor(0,25);
  display.print("R:");
  display.print(readingR*255/readingMax);
  
  display.setCursor(32,25);
  display.print("G:");
  display.print(readingG*255/readingMax);
  
  display.setCursor(64,25);
  display.print("B:");
  display.print(readingB*255/readingMax);
  display.setCursor(96,25);
  display.print("W:");
  display.print(readingW*255/readingMax);
  

                       
                          
 


  ////////////////////////////////////////////////////////////display bars///////////////////////////////////////////////////////////////////
 // display.drawRect(50,0,78,14,WHITE); //x,y,size x,size y//this is max size and min locations of bar graphs
  display.drawRect(50,0,(readingR*78/readingMax),2,WHITE);
  display.drawRect(50,3,(readingG*78/readingMax),2,WHITE);
  display.drawRect(50,6,(readingB*78/readingMax),2,WHITE);
  display.drawRect(50,9,(readingW*78/readingMax),2,WHITE);
  if(itiration%10==1){
  if(holdtrue==0){
  display.display();
  }
 
if(holdexecute==0){
  display.setCursor(120,17);
  display.print("F");
  display.display();
  holdexecute++;}
  }
  itiration++;
  if(itiration>10){itiration=0;}
  ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    
  ///////////////////////////////////////
  display.clearDisplay();
}

