/*
  Example for receiving
  
  https://github.com/sui77/rc-switch/
  
  If you want to visualize a telegram copy the raw data and 
  paste it into http://test.sui.li/oszi/
*/

#include <RCSwitch.h>

RCSwitch rxSwitch = RCSwitch();

void setup() {
  Serial.begin(9600);
  rxSwitch.enableReceive(14);  // Receiver on interrupt 0 => that is pin #2
}

void loop() {
  if (rxSwitch.available()) {
    output(rxSwitch.getReceivedValue(), rxSwitch.getReceivedBitlength(), rxSwitch.getReceivedDelay(), rxSwitch.getReceivedRawdata(),rxSwitch.getReceivedProtocol());
    rxSwitch.resetAvailable();
  }
}
