package raspberry;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class PropertiesFile {
	String result = "";
	InputStream inputStream;
 
	public String getPropValues(String propertyKey) throws IOException {
		try {
			Properties prop = new Properties();
			String propFileName = "raspberry.properties";
 
			inputStream = getClass().getClassLoader().getResourceAsStream(propFileName);
 
			if (inputStream != null) {
				prop.load(inputStream);
			} else {
				throw new FileNotFoundException("property file '" + propFileName + "' not found in the classpath");
			}
 
			// get the property value and print it out
			result = prop.getProperty(propertyKey);
			System.out.println(propertyKey + "=" + result);
		} catch (Exception e) {
			System.out.println("Exception: " + e);
		} finally {
			inputStream.close();
		}
		return result;
	}
}
