var depth = 0;

window.onload = function() {
  var canvas = document.getElementById('canvas');
  paper.setup(canvas);
  draw(depth);

  // keypress listeners
  document.body.addEventListener("keypress", function(event) {
      switch(event.keyCode) {
          case 32: // space
              // iterate
              draw(++depth);
              break;
          case 115: // "s"
              // export to console as SVG string
              console.log(paper.project.exportSVG({asString : true}));
              break;
          default:
              break;
      }
  });
}

function drawSingleSquare(p,L,theta){
    theta *= 180/Math.PI;

    var Point = paper.Point;
    var Path = paper.Path;
    var Color = paper.Color;

    var pathPts = [
        new Point(L,0),
        new Point(L,L),
        new Point(0,L),
        new Point(0,0),
        new Point(Math.sqrt(2)/2*L,0).rotate(-45)
    ];

    var path = new Path(pathPts);
    path.translate(p);
    path.rotate(theta, p);
    path.fillColor = new Color(0,0,0,1);
    path.strokeColor = new Color(0,0,0,1);
    path.strokeWidth = 0.5; // aliasing fix
    path.closePath();

    return path;
}

function drawSquares(p,L,angle,iteration){

    if(iteration == 0) {
        drawSingleSquare(p,L,angle);
        paper.view.draw();
        return;
    }

    var Point = paper.Point;
    iteration--;

    L *= Math.sqrt(2)/2;

    //left
    var angleL = angle - Math.PI/4;
    var pL = p.add(new Point(
          L * Math.sin(angleL),
        - L * Math.cos(angleL)
    ));
    drawSquares(pL,L,angleL,iteration);

    //right
    var angleR = angle + Math.PI/4;
    var pR = p.add(new Point(
          2 * L * Math.sin(angleR),
        - 2 * L * Math.cos(angleR)
    ));
    drawSquares(pR,L,angleR,iteration);
}

function draw(depth){
    var L = 100;
    var p = new paper.Point(window.innerWidth/2 - L/2, window.innerHeight - L);
    var angle = 0;
    drawSquares(p,L,angle,depth);
}
