"""---------------------------------------------"""
"""|PYGAME AND PARTICLE PHOTON ROBOT CONTROLLER|"""
"""---------------------------------------------"""

#import modules
import pygame, sys, random
from spyrk import SparkCloud
from pygame.locals import *

pygame.init()
print("Initialized Pygame")

#create and name frame
width = 300
height = 300
canvas = pygame.display.set_mode((width, height))
pygame.display.set_caption("Pygame Robot Controller")

#create FPS clock
fpsClock = pygame.time.Clock()
FPS = 30

#variables
serDataL = "0"
serDataR = "0"
serDataOld = "00"
running = True
file = []


#get Photon connection data from config
fileGet = open("config/pyPhoton.txt", "r")
for line in fileGet:
    line = line.replace("\n", "")
    file.append(line)
fileGet.close()

#save Photon connection data
username = file[0]
pwd = file[1]
device = file[2]

#connect to Particle cloud
particle = SparkCloud(username, pwd)

print("\nConnected to Particle cloud, scanning for device '" + device + "'...\n")

#only start running if the device is online
if particle.devices[device].connected:
    print("\nDevice '" + device + "' found, proceeding.")
    try:
        while running:
            for event in pygame.event.get():
                #'x' the window
                if event.type == pygame.QUIT:
                    running = False

                #movement handlers
                if event.type == pygame.KEYDOWN:
                    if event.key == pygame.K_RETURN or event.key == pygame.K_ESCAPE:
                        running = False
                    elif event.key == pygame.K_w:
                        serDataL = "1"
                    elif event.key == pygame.K_s:
                        serDataL = "2"

                    elif event.key == pygame.K_i:
                        serDataR = "1"
                    elif event.key == pygame.K_k:
                        serDataR = "2"

                    if event.key == pygame.K_SPACE:
                        serDataL = "9"
                        serDataR = "9"
                        
                elif event.type == pygame.KEYUP:
                    if event.key == pygame.K_w:
                        serDataL = "0"
                    elif event.key == pygame.K_s:
                        serDataL = "0"

                    elif event.key == pygame.K_i:
                        serDataR = "0"
                    elif event.key == pygame.K_k:
                        serDataR = "0"

                    if event.key == pygame.K_SPACE:
                        serDataL = "0"
                        serDataR = "0"

            #decipher positions, then construct data packet
            serData = serDataL + serDataR
            if serData != serDataOld:
                if serData == "00":
                    serDC = "0"
                    
                elif serData == "10":
                    serDC = "1"
                    
                elif serData == "20":
                    serDC = "2"
                    
                elif serData == "01":
                    serDC = "3"

                elif serData == "02":
                    serDC = "4"
                    
                elif serData == "11":
                    serDC = "5"
                    
                elif serData == "21":
                    serDC = "6"
                    
                elif serData == "12":
                    serDC = "7"
                    
                elif serData == "22":
                    serDC = "8"

                elif serData == "99":
                    serDC = "9"

                #print data and send to Photon   
                print serData + "   " + serDC
                particle.devices[device].updateMotors(serDC)
                
                serDataOld = serData

            #tick clock, and update and clear display
            fpsClock.tick(FPS)
            pygame.display.update()
            canvas.fill((0,0,0))
            
    except KeyboardInterrupt:
        print("Quitting due to KeyboardInterrupt (CTRL+C).")
        
    #turn motors off and close pygame
    print("00   0")
    particle.devices[device].updateMotors("0")

    print(" ")
    print("Done.")
    
else:
    print("Quitting because device '" + device + "' is offline.")

#quit program
pygame.quit()
sys.exit(0)
