// https://www.rhydolabz.com/wiki/?p=12663
// https://github.com/madsci1016/Arduino-PS2X
// http://www.billporter.info/2010/06/05/playstation-2-controller-arduino-library-v1-0/
// https://www.arduino.cc/en/Reference/KeyboardModifiers
#include <PS2X_lib.h>                         /* PS2 Controller Library */
#include <Keyboard.h>
PS2X ps2x;                                    /* create PS2 Controller Class*/
byte Type = 0;
byte vibrate = 0;
int RX = 0, RY = 0, LX = 0, LY = 0;
void setup() {

  Keyboard.begin();
  ps2x.config_gamepad(10, 16, 14, 15, false, false); /* setup pins and settings:  GamePad(clock, command, attention, data, Pressures?, Rumble?) check for error*/
  Type = ps2x.readType();                       /* Reading type of the PS2 Ccontroller */

}
void loop() {

  ps2x.read_gamepad(false, vibrate);   /* read controller and set large motor to spin at 'vibrate' speed */

  LY = ps2x.Analog(PSS_LY);          /* Reading Left stick Y axis */
  LX = ps2x.Analog(PSS_LX);          /* Reading Left stick X axis */
  RY = ps2x.Analog(PSS_RY);          /* Reading Right stick Y axis */
  RX = ps2x.Analog(PSS_RX);          /* Reading Right stick X axis */

  if ((LY <= 40)) {                    /* standardize to 3 digit by checking less than 10 */
  }
  if ((LY >= 9 && LY <= 199)) {        /* standardize to 3 digit by checking between 10-99 */
  }
  if ((LY >= 199)) {                    /* standardize to 3 digit by checking less than 10 */
  }
  if ((LX <= 40)) {                    /* standardize to 3 digit by checking less than 10 */
  }
  if ((LX >= 199)) {                    /* standardize to 3 digit by checking less than 10 */
  }
  if ((LX >= 9 && LX <= 199)) {        /* standardize to 3 digit by checking between 10-99 */
  }
  if ((RY <= 9)) {                    /* standardize to 3 digit by checking less than 10 */
  }
  if ((RY >= 9 && RY <= 99)) {        /* standardize to 3 digit by checking between 10-99 */
  }
  if ((RX <= 9)) {                    /* standardize to 3 digit by checking less than 10 */
  }
  if ((RX >= 9 && RX <= 99)) {        /* standardize to 3 digit by checking between 10-99 */
  }
  if (ps2x.NewButtonState()) {       /* will be TRUE if any button changes state  */

    if (ps2x.Button(PSB_START)) {    /* will be TRUE as long START button is pressed */
      Keyboard.press(177); //esc
    } else {
      Keyboard.release(177);
    }

    if (ps2x.Button(PSB_SELECT)) {           /* will be TRUE as long SELECT button is pressed */
      Keyboard.press(177); //esc
    } else {
      Keyboard.release(177);
    }

    if (ps2x.Button(PSB_PAD_UP)) {           /* will be TRUE as long as UP button is pressed */
      Keyboard.press('w');
    } else {
      Keyboard.release('w');
    }

    if (ps2x.Button(PSB_PAD_RIGHT)) {        /* will be TRUE as long as RIGHT button is pressed */
      Keyboard.press('d');
    } else {
      Keyboard.release('d');
    }

    if (ps2x.Button(PSB_PAD_LEFT)) {         /* will be TRUE as long as LEFT button is pressed */
      Keyboard.press('a');
    } else {
      Keyboard.release('a');
    }

    if (ps2x.Button(PSB_PAD_DOWN)) {         /* will be TRUE as long as DOWN button is pressed */
      Keyboard.press('s');
    } else {
      Keyboard.release('s');
    }

    if (ps2x.Button(PSB_L1)) {               /* will be TRUE as long as L1 button is pressed */
      Keyboard.press('q');
    } else {
      Keyboard.release('q');
    }

    if (ps2x.Button(PSB_R1)) {               /* will be TRUE as long as R1 button is pressed */
      Keyboard.press(129); // walk shift
    } else {
      Keyboard.release(129);
    }

    if (ps2x.Button(PSB_L2)) {               /* will be TRUE as long as L2 button is pressed */
      Keyboard.press('/');
    } else {
      Keyboard.release('/');
    }

    if (ps2x.Button(PSB_R2)) {
      if (ps2x.Button(PSB_PAD_LEFT)) {
        Keyboard.press('x'); //
      }
      if (ps2x.Button(PSB_PAD_RIGHT)) {
        Keyboard.press('c'); //
      }
      Keyboard.press(128);
    } else {
      Keyboard.release(128);
      Keyboard.release('x'); //
      Keyboard.release('c'); //
    }

    if (ps2x.Button(PSB_L3)) {               /* will be TRUE as long as L3 button is pressed */
      Keyboard.press(128);
    } else {
      Keyboard.release(128);
    }

    if (ps2x.Button(PSB_R3)) {               /* will be TRUE as long as R3 button is pressed */
      Keyboard.press(128);
    } else {
      Keyboard.release(128);
    }

    if (ps2x.Button(PSB_GREEN)) {            /* will be TRUE as long as GREEN/Triangle button is pressed */
      Keyboard.press(32); //space
    } else {
      Keyboard.release(32);
    }

    if (ps2x.Button(PSB_BLUE)) {              /* will be TRUE as long as BLUE/CROSS/X button is pressed */
      Keyboard.press(128); // l ctrl
    }
    else {
      Keyboard.release(128);
    }

    if (ps2x.Button(PSB_RED)) {             /* will be TRUE as long as RED/Circle button is pressed */
      Keyboard.press(213); // end
    }
    else {
      Keyboard.release(213); //end
    }

    if (ps2x.Button(PSB_PINK)) {             /* will be TRUE as long as PINK/Squre button is pressed */
      Keyboard.press(130); // l alt
    } else {
      Keyboard.release(130);
    }

  }
  else;
}
