/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.media.mp3;

import ch.randelshofer.media.mp3.MP3ElementaryInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class MP3AudioInputStream
extends AudioInputStream {
    private MP3ElementaryInputStream in;

    public MP3AudioInputStream(File file) throws IOException {
        this(new BufferedInputStream(new FileInputStream(file)));
    }

    public MP3AudioInputStream(InputStream inputStream) throws IOException {
        super(null, new AudioFormat(MP3ElementaryInputStream.MP3, 44100.0f, 16, 2, 626, 38.28125f, true), -1L);
        this.in = new MP3ElementaryInputStream(inputStream);
        if (this.in.getNextFrame() == null) {
            throw new IOException("Stream is not an MP3 elementary stream");
        }
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public AudioFormat getFormat() {
        return this.in.getFormat();
    }

    @Override
    public long getFrameLength() {
        return -1L;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public int read() throws IOException {
        throw new IOException("cannot read a single byte if frame size > 1");
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.in.getFrame() == null && this.in.getNextFrame() == null) {
            return -1;
        }
        if (this.in.getStreamPosition() != this.in.getFrame().getFrameOffset() && this.in.getNextFrame() == null) {
            return -1;
        }
        int n3 = 0;
        int n4 = this.in.getFrame().getFrameSize();
        while (n2 >= n4) {
            this.in.readFully(byArray, n, n4);
            n2 -= n4;
            n3 += n4;
            n += n4;
            if (this.in.getNextFrame() == null) break;
            n4 = this.in.getFrame().getFrameSize();
        }
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        return this.in.skip(l);
    }

    @Override
    public void mark(int n) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }
}

