/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class SeekableByteArrayOutputStream
extends ByteArrayOutputStream {
    private int pos;

    public SeekableByteArrayOutputStream() {
        this(32);
    }

    public SeekableByteArrayOutputStream(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative initial size: " + n);
        }
        this.buf = new byte[n];
    }

    @Override
    public synchronized void write(int n) {
        int n2 = Math.max(this.pos + 1, this.count);
        if (n2 > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, n2));
        }
        this.buf[this.pos++] = (byte)n;
        this.count = n2;
    }

    @Override
    public synchronized void write(byte[] byArray, int n, int n2) {
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        int n3 = Math.max(this.pos + n2, this.count);
        if (n3 > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, n3));
        }
        System.arraycopy(byArray, n, this.buf, this.pos, n2);
        this.pos += n2;
        this.count = n3;
    }

    @Override
    public synchronized void reset() {
        this.count = 0;
        this.pos = 0;
    }

    public void seek(long l) throws IOException {
        this.pos = (int)l;
    }

    public long getStreamPosition() throws IOException {
        return this.pos;
    }

    public void toOutputStream(OutputStream outputStream) throws IOException {
        outputStream.write(this.buf, 0, this.count);
    }
}

