/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.pdex;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.compiler.IProblem;
import processing.app.ui.ErrorTable;
import processing.mode.java.pdex.ErrorMessageSimplifier;

public class Problem
implements ErrorTable.Entry {
    private IProblem iProblem;
    private int tabIndex;
    private int lineNumber;
    private int startOffset;
    private int stopOffset;
    private String message;
    private int type;
    private String[] importSuggestions;
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    private static final Pattern tokenRegExp = Pattern.compile("\\b token\\b");

    public Problem(IProblem iProblem, int tabIndex, int lineNumber) {
        this.iProblem = iProblem;
        if (iProblem.isError()) {
            this.type = 1;
        } else if (iProblem.isWarning()) {
            this.type = 2;
        }
        this.tabIndex = tabIndex;
        this.lineNumber = lineNumber;
        this.message = Problem.process(iProblem);
        this.message = ErrorMessageSimplifier.getSimplifiedErrorMessage(this);
    }

    public void setPDEOffsets(int startOffset, int stopOffset) {
        this.startOffset = startOffset;
        this.stopOffset = stopOffset;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getStopOffset() {
        return this.stopOffset;
    }

    public String toString() {
        return new String("TAB " + this.tabIndex + ",LN " + this.lineNumber + "LN START OFF: " + this.startOffset + ",LN STOP OFF: " + this.stopOffset + ",PROB: " + this.message);
    }

    public boolean isError() {
        return this.type == 1;
    }

    public boolean isWarning() {
        return this.type == 2;
    }

    public String getMessage() {
        return this.message;
    }

    public IProblem getIProblem() {
        return this.iProblem;
    }

    public int getTabIndex() {
        return this.tabIndex;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getSourceLineNumber() {
        return this.iProblem.getSourceLineNumber();
    }

    public void setType(int ProblemType) {
        if (ProblemType == 1) {
            this.type = 1;
        } else if (ProblemType == 2) {
            this.type = 2;
        } else {
            throw new IllegalArgumentException("Illegal Problem type passed to Problem.setType(int)");
        }
    }

    public String[] getImportSuggestions() {
        return this.importSuggestions;
    }

    public void setImportSuggestions(String[] a) {
        this.importSuggestions = a;
    }

    public static String process(IProblem problem) {
        return Problem.process(problem.getMessage());
    }

    public static String process(String message) {
        if (message == null) {
            return null;
        }
        Matcher matcher = tokenRegExp.matcher(message);
        message = matcher.replaceAll("");
        return message;
    }

    public static String splitCamelCaseWord(String word) {
        String newWord = "";
        int i = 1;
        while (i < word.length()) {
            if (Character.isUpperCase(word.charAt(i))) {
                newWord = String.valueOf(newWord) + word.substring(0, i) + " ";
                word = word.substring(i);
                i = 1;
            }
            ++i;
        }
        newWord = String.valueOf(newWord) + word;
        return newWord.trim();
    }
}

