/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.pdex;

import com.google.classpath.ClassPath;
import com.google.classpath.RegExpResourceFilter;
import com.google.classpath.ResourceFilter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import processing.app.Language;
import processing.app.Messages;
import processing.app.Platform;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.syntax.SyntaxDocument;
import processing.app.ui.Toolkit;
import processing.mode.java.JavaEditor;
import processing.mode.java.JavaMode;
import processing.mode.java.pdex.ASTUtils;
import processing.mode.java.pdex.CompletionGenerator;
import processing.mode.java.pdex.PreprocessedSketch;
import processing.mode.java.pdex.PreprocessingService;
import processing.mode.java.pdex.Problem;

public class PDEX {
    private static final boolean SHOW_DEBUG_TREE = false;
    private boolean enabled = true;
    private ErrorChecker errorChecker;
    private InspectMode inspectMode;
    private ShowUsage showUsage;
    private Rename rename;
    private DebugTree debugTree;
    private PreprocessingService pps;
    protected final DocumentListener sketchChangedListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent e) {
            PDEX.this.sketchChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            PDEX.this.sketchChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            PDEX.this.sketchChanged();
        }
    };

    public PDEX(JavaEditor editor, PreprocessingService pps) {
        this.pps = pps;
        this.enabled = !editor.hasJavaTabs();
        this.errorChecker = new ErrorChecker(editor, pps);
        this.inspectMode = new InspectMode(editor, pps);
        this.showUsage = new ShowUsage(editor, pps);
        this.rename = new Rename(editor, pps);
        SketchCode[] sketchCodeArray = editor.getSketch().getCode();
        int n = sketchCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SketchCode code = sketchCodeArray[n2];
            Document document = code.getDocument();
            this.addDocumentListener(document);
            ++n2;
        }
        this.sketchChanged();
    }

    public void addDocumentListener(Document doc) {
        if (doc != null) {
            doc.addDocumentListener(this.sketchChangedListener);
        }
    }

    public void sketchChanged() {
        this.errorChecker.notifySketchChanged();
        this.pps.notifySketchChanged();
    }

    public void preferencesChanged() {
        this.sketchChanged();
    }

    public void hasJavaTabsChanged(boolean hasJavaTabs) {
        boolean bl = this.enabled = !hasJavaTabs;
        if (!this.enabled) {
            this.showUsage.hide();
        }
    }

    public void dispose() {
        this.inspectMode.dispose();
        this.errorChecker.dispose();
        this.showUsage.dispose();
        this.rename.dispose();
        if (this.debugTree != null) {
            this.debugTree.dispose();
        }
    }

    public void documentChanged(Document newDoc) {
        this.addDocumentListener(newDoc);
    }

    private static class DebugTree {
        final JDialog window;
        final JTree tree;
        final Consumer<PreprocessedSketch> updateListener = this::buildAndUpdateTree;

        DebugTree(JavaEditor editor, final PreprocessingService pps) {
            this.window = new JDialog((Frame)((Object)editor));
            this.tree = new JTree(){

                @Override
                public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    DefaultMutableTreeNode treeNode;
                    Object o;
                    if (value instanceof DefaultMutableTreeNode && (o = (treeNode = (DefaultMutableTreeNode)value).getUserObject()) instanceof ASTNode) {
                        ASTNode node = (ASTNode)o;
                        return CompletionGenerator.getNodeAsString(node);
                    }
                    return super.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
                }
            };
            this.window.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent e) {
                    pps.unregisterListener(updateListener);
                    tree.setModel(null);
                }
            });
            this.window.setDefaultCloseOperation(1);
            this.window.setBounds(new Rectangle(680, 100, 460, 620));
            this.window.setTitle("AST View - " + editor.getSketch().getName());
            JScrollPane sp = new JScrollPane();
            sp.setViewportView(this.tree);
            this.window.add(sp);
            pps.whenDone(this.updateListener);
            pps.registerListener(this.updateListener);
            this.tree.addTreeSelectionListener(e -> {
                if (this.tree.getLastSelectedPathComponent() == null) {
                    return;
                }
                DefaultMutableTreeNode tnode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
                if (tnode.getUserObject() instanceof ASTNode) {
                    ASTNode node = (ASTNode)tnode.getUserObject();
                    pps.whenDone(ps -> {
                        PreprocessedSketch.SketchInterval si = ps.mapJavaToSketch(node);
                        if (!ps.inRange(si)) {
                            return;
                        }
                        EventQueue.invokeLater(() -> editor.highlight(sketchInterval.tabIndex, sketchInterval.startTabOffset, sketchInterval.stopTabOffset));
                    });
                }
            });
        }

        void dispose() {
            if (this.window != null) {
                this.window.dispose();
            }
        }

        void buildAndUpdateTree(PreprocessedSketch ps) {
            CompilationUnit cu = ps.compilationUnit;
            if (cu.types().isEmpty()) {
                Messages.loge((String)"No Type found in CU");
                return;
            }
            final ArrayDeque treeNodeStack = new ArrayDeque();
            ASTNode type0 = (ASTNode)cu.types().get(0);
            type0.accept(new ASTVisitor(){

                public boolean preVisit2(ASTNode node) {
                    treeNodeStack.push(new DefaultMutableTreeNode(node));
                    return super.preVisit2(node);
                }

                public void postVisit(ASTNode node) {
                    if (treeNodeStack.size() > 1) {
                        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)treeNodeStack.pop();
                        ((DefaultMutableTreeNode)treeNodeStack.peek()).add(treeNode);
                    }
                }
            });
            DefaultMutableTreeNode codeTree = (DefaultMutableTreeNode)treeNodeStack.pop();
            EventQueue.invokeLater(() -> {
                if (this.tree.hasFocus() || this.window.hasFocus()) {
                    return;
                }
                this.tree.setModel(new DefaultTreeModel(codeTree));
                ((DefaultTreeModel)this.tree.getModel()).reload();
                this.tree.validate();
                if (!this.window.isVisible()) {
                    this.window.setVisible(true);
                }
            });
        }
    }

    private static class ErrorChecker {
        private static final long DELAY_BEFORE_UPDATE = 650L;
        private ScheduledExecutorService scheduler;
        private volatile ScheduledFuture<?> scheduledUiUpdate = null;
        private volatile long nextUiUpdate = 0L;
        private final Consumer<PreprocessedSketch> errorHandlerListener = this::handleSketchProblems;
        private JavaEditor editor;

        public ErrorChecker(JavaEditor editor, PreprocessingService pps) {
            this.editor = editor;
            this.scheduler = Executors.newSingleThreadScheduledExecutor();
            pps.registerListener(this.errorHandlerListener);
        }

        public void notifySketchChanged() {
            this.nextUiUpdate = System.currentTimeMillis() + 650L;
        }

        public void dispose() {
            if (this.scheduler != null) {
                this.scheduler.shutdownNow();
            }
        }

        private void handleSketchProblems(PreprocessedSketch ps) {
            Map<String, List<Problem>> undefinedTypeProblems;
            IProblem[] iproblems = ps.compilationUnit.getProblems();
            List problems = Arrays.stream(iproblems).filter(iproblem -> !iproblem.isWarning() || JavaMode.warningsEnabled).filter(iproblem -> !iproblem.getMessage().contains("Syntax error, insert \":: IdentifierOrNew\"")).map(iproblem -> {
                int stop;
                int start = iproblem.getSourceStart();
                PreprocessedSketch.SketchInterval in = ps.mapJavaToSketch(start, stop = iproblem.getSourceEnd() + 1);
                if (in == PreprocessedSketch.SketchInterval.BEFORE_START) {
                    return null;
                }
                int line = ps.tabOffsetToTabLine(in.tabIndex, in.startTabOffset);
                Problem p = new Problem((IProblem)iproblem, in.tabIndex, line);
                p.setPDEOffsets(in.startTabOffset, in.stopTabOffset);
                return p;
            }).filter(p -> p != null).collect(Collectors.toList());
            if (JavaMode.importSuggestEnabled && !(undefinedTypeProblems = problems.stream().filter(p -> {
                int id = p.getIProblem().getID();
                return id == 0x1000002 || id == 0x22000032 || id == 33554515;
            }).collect(Collectors.groupingBy(p -> p.getIProblem().getArguments()[0]))).isEmpty()) {
                ClassPath cp = ps.searchClassPath;
                undefinedTypeProblems.entrySet().stream().forEach(entry -> {
                    String missingClass = (String)entry.getKey();
                    List affectedProblems = (List)entry.getValue();
                    String[] suggestions = ErrorChecker.getImportSuggestions(cp, missingClass);
                    affectedProblems.forEach(p -> p.setImportSuggestions(suggestions));
                });
            }
            if (this.scheduledUiUpdate != null) {
                this.scheduledUiUpdate.cancel(true);
            }
            long delay = this.nextUiUpdate - System.currentTimeMillis();
            Runnable uiUpdater = () -> {
                if (this.nextUiUpdate > 0L && System.currentTimeMillis() >= this.nextUiUpdate) {
                    EventQueue.invokeLater(() -> this.editor.setProblemList(problems));
                }
            };
            this.scheduledUiUpdate = this.scheduler.schedule(uiUpdater, delay, TimeUnit.MILLISECONDS);
        }

        public static String[] getImportSuggestions(ClassPath cp, String className) {
            RegExpResourceFilter regf = new RegExpResourceFilter(Pattern.compile(".*"), Pattern.compile("(.*\\$)?" + className + "\\.class", 2));
            String[] resources = cp.findResources("", (ResourceFilter)regf);
            return (String[])Arrays.stream(resources).map(res -> res.substring(0, res.length() - 6)).map(res -> res.replace('/', '.')).map(res -> res.replace('$', '.')).sorted((o1, o2) -> {
                boolean o2StartsWithJava;
                boolean o1StartsWithJava = o1.startsWith("java");
                if (o1StartsWithJava != (o2StartsWithJava = o2.startsWith("java"))) {
                    if (o1StartsWithJava) {
                        return -1;
                    }
                    return 1;
                }
                return o1.compareTo((String)o2);
            }).toArray(String[]::new);
        }
    }

    private class InspectMode {
        boolean inspectModeEnabled;
        boolean isMouse1Down;
        boolean isMouse2Down;
        boolean isHotkeyDown;
        Predicate<MouseEvent> mouseEventHotkeyTest = Platform.isMacOS() ? InputEvent::isMetaDown : InputEvent::isControlDown;
        Predicate<KeyEvent> keyEventHotkeyTest = Platform.isMacOS() ? e -> e.getKeyCode() == 157 : e -> e.getKeyCode() == 17;
        JavaEditor editor;
        PreprocessingService pps;

        InspectMode(final JavaEditor editor, PreprocessingService pps) {
            this.editor = editor;
            this.pps = pps;
            editor.getJavaTextArea().getPainter().addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    InspectMode.this.isMouse1Down = InspectMode.this.isMouse1Down || e.getButton() == 1;
                    InspectMode.this.isMouse2Down = InspectMode.this.isMouse2Down || e.getButton() == 2;
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    boolean releasingMouse2;
                    boolean releasingMouse1 = e.getButton() == 1;
                    boolean bl = releasingMouse2 = e.getButton() == 2;
                    if (JavaMode.inspectModeHotkeyEnabled && InspectMode.this.inspectModeEnabled && InspectMode.this.isMouse1Down && releasingMouse1) {
                        InspectMode.this.handleInspect(e);
                    } else if (!InspectMode.this.inspectModeEnabled && InspectMode.this.isMouse2Down && releasingMouse2) {
                        InspectMode.this.handleInspect(e);
                    }
                    InspectMode.this.isMouse1Down = InspectMode.this.isMouse1Down && !releasingMouse1;
                    InspectMode.this.isMouse2Down = InspectMode.this.isMouse2Down && !releasingMouse2;
                }
            });
            editor.getJavaTextArea().getPainter().addMouseMotionListener((MouseMotionListener)new MouseAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (editor.isSelectionActive()) {
                        InspectMode.this.inspectModeEnabled = false;
                        InspectMode.this.isMouse2Down = false;
                    }
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    InspectMode.this.isMouse1Down = false;
                    InspectMode.this.isMouse2Down = false;
                    InspectMode.this.inspectModeEnabled = InspectMode.this.isHotkeyDown = InspectMode.this.mouseEventHotkeyTest.test(e);
                }
            });
            editor.getJavaTextArea().addMouseWheelListener(new MouseAdapter(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                    if (InspectMode.this.isMouse1Down) {
                        InspectMode.this.inspectModeEnabled = false;
                    }
                }
            });
            editor.getJavaTextArea().addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    InspectMode.this.isHotkeyDown = InspectMode.this.isHotkeyDown || InspectMode.this.keyEventHotkeyTest.test(e);
                    InspectMode.this.inspectModeEnabled = InspectMode.this.inspectModeEnabled || !InspectMode.this.isMouse1Down && InspectMode.this.isHotkeyDown;
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    InspectMode.this.isHotkeyDown = InspectMode.this.isHotkeyDown && !InspectMode.this.keyEventHotkeyTest.test(e);
                    InspectMode.this.inspectModeEnabled = InspectMode.this.inspectModeEnabled && InspectMode.this.isHotkeyDown;
                }
            });
        }

        void handleInspect(MouseEvent evt) {
            int off = this.editor.getJavaTextArea().xyToOffset(evt.getX(), evt.getY());
            if (off < 0) {
                return;
            }
            int tabIndex = this.editor.getSketch().getCurrentCodeIndex();
            this.pps.whenDoneBlocking(ps -> this.handleInspect((PreprocessedSketch)ps, tabIndex, off));
        }

        private void handleInspect(PreprocessedSketch ps, int tabIndex, int offset) {
            CompilationUnit root = ps.compilationUnit;
            int javaOffset = ps.tabOffsetToJavaOffset(tabIndex, offset);
            SimpleName simpleName = ASTUtils.getSimpleNameAt((ASTNode)root, javaOffset, javaOffset);
            if (simpleName == null) {
                Messages.log((String)"no simple name found at click location");
                return;
            }
            IBinding binding = ASTUtils.resolveBinding(simpleName);
            if (binding == null) {
                Messages.log((String)"binding not resolved");
                return;
            }
            String key = binding.getKey();
            ASTNode decl = ps.compilationUnit.findDeclaringNode(key);
            if (decl == null) {
                Messages.log((String)"decl not found, showing usage instead");
                PDEX.this.showUsage.findUsageAndUpdateTree(ps, binding);
                return;
            }
            SimpleName declName = null;
            switch (binding.getKind()) {
                case 2: {
                    declName = ((TypeDeclaration)decl).getName();
                    break;
                }
                case 4: {
                    declName = ((MethodDeclaration)decl).getName();
                    break;
                }
                case 3: {
                    declName = ((VariableDeclaration)decl).getName();
                }
            }
            if (declName == null) {
                Messages.log((String)("decl name not found " + decl));
                return;
            }
            if (declName.equals((Object)simpleName)) {
                PDEX.this.showUsage.findUsageAndUpdateTree(ps, binding);
            } else {
                Messages.log((String)("found declaration, offset " + decl.getStartPosition() + ", name: " + declName));
                PreprocessedSketch.SketchInterval si = ps.mapJavaToSketch((ASTNode)declName);
                if (!ps.inRange(si)) {
                    return;
                }
                EventQueue.invokeLater(() -> this.editor.highlight(sketchInterval.tabIndex, sketchInterval.startTabOffset, sketchInterval.stopTabOffset));
            }
        }

        void dispose() {
        }
    }

    private class Rename {
        final JDialog window;
        final JTextField textField;
        final JLabel oldNameLabel;
        final JavaEditor editor;
        final PreprocessingService pps;
        IBinding binding;
        PreprocessedSketch ps;

        Rename(JavaEditor editor, PreprocessingService pps) {
            this.editor = editor;
            this.pps = pps;
            JMenuItem renameItem = new JMenuItem(Language.text((String)"editor.popup.rename"));
            renameItem.addActionListener(e -> this.handleRename());
            editor.getTextArea().getRightClickPopup().add(renameItem);
            this.window = new JDialog((Frame)((Object)editor));
            this.window.setTitle("Enter new name:");
            this.window.setDefaultCloseOperation(1);
            this.window.setModal(true);
            this.window.setResizable(false);
            this.window.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent e) {
                    Rename.this.binding = null;
                    Rename.this.ps = null;
                }
            });
            this.window.setSize(250, 130);
            this.window.setLayout(new BoxLayout(this.window.getContentPane(), 1));
            Toolkit.setIcon((Window)this.window);
            this.textField = new JTextField();
            this.textField.setPreferredSize(new Dimension(150, 60));
            this.oldNameLabel = new JLabel();
            this.oldNameLabel.setText("Old Name: ");
            JPanel panelTop = new JPanel();
            panelTop.setLayout(new BoxLayout(panelTop, 1));
            panelTop.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            panelTop.add(this.textField);
            panelTop.add(Box.createRigidArea(new Dimension(0, 10)));
            panelTop.add(this.oldNameLabel);
            this.window.add(panelTop);
            JButton showUsageButton = new JButton("Show Usage");
            showUsageButton.addActionListener(e -> {
                PDEX.this.showUsage.findUsageAndUpdateTree(this.ps, this.binding);
                this.window.setVisible(false);
            });
            JButton renameButton = new JButton("Rename");
            renameButton.addActionListener(e -> {
                boolean isNewNameValid;
                if (this.textField.getText().length() == 0) {
                    return;
                }
                String newName = this.textField.getText().trim();
                boolean bl = isNewNameValid = newName.length() >= 1 && newName.chars().limit(1L).allMatch(Character::isUnicodeIdentifierStart) && newName.chars().skip(1L).allMatch(Character::isUnicodeIdentifierPart);
                if (!isNewNameValid) {
                    JOptionPane.showMessageDialog(new JFrame(), "'" + newName + "' isn't a valid name.", "Uh oh..", -1);
                } else {
                    this.rename(this.ps, this.binding, newName);
                    this.window.setVisible(false);
                }
            });
            JPanel panelBottom = new JPanel();
            panelBottom.setLayout(new BoxLayout(panelBottom, 0));
            panelBottom.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            panelBottom.add(Box.createHorizontalGlue());
            panelBottom.add(showUsageButton);
            panelBottom.add(Box.createRigidArea(new Dimension(15, 0)));
            panelBottom.add(renameButton);
            this.window.add(panelBottom);
            this.window.setMinimumSize(this.window.getSize());
        }

        void handleRename() {
            int startOffset = this.editor.getSelectionStart();
            int stopOffset = this.editor.getSelectionStop();
            int tabIndex = this.editor.getSketch().getCurrentCodeIndex();
            this.pps.whenDoneBlocking(ps -> this.handleRename((PreprocessedSketch)ps, tabIndex, startOffset, stopOffset));
        }

        void handleRename(PreprocessedSketch ps, int tabIndex, int startTabOffset, int stopTabOffset) {
            int stopJavaOffset;
            if (ps.hasSyntaxErrors) {
                this.editor.statusMessage("Can't perform action until syntax errors are fixed", 3);
                return;
            }
            CompilationUnit root = ps.compilationUnit;
            int startJavaOffset = ps.tabOffsetToJavaOffset(tabIndex, startTabOffset);
            SimpleName name = ASTUtils.getSimpleNameAt((ASTNode)root, startJavaOffset, stopJavaOffset = ps.tabOffsetToJavaOffset(tabIndex, stopTabOffset));
            if (name == null) {
                this.editor.statusMessage("Highlight the class/function/variable name first", 0);
                return;
            }
            IBinding binding = ASTUtils.resolveBinding(name);
            if (binding == null) {
                this.editor.statusMessage(String.valueOf(name.getIdentifier()) + " isn't defined in this sketch, " + "so it cannot be renamed", 1);
                return;
            }
            ASTNode decl = ps.compilationUnit.findDeclaringNode(binding.getKey());
            if (decl == null) {
                this.editor.statusMessage(String.valueOf(name.getIdentifier()) + " isn't defined in this sketch, " + "so it cannot be renamed", 1);
                return;
            }
            EventQueue.invokeLater(() -> {
                if (!this.window.isVisible()) {
                    this.ps = ps;
                    this.binding = binding;
                    this.oldNameLabel.setText("Current name: " + binding.getName());
                    this.textField.setText(binding.getName());
                    this.textField.requestFocus();
                    this.textField.selectAll();
                    int x = this.editor.getX() + (this.editor.getWidth() - this.window.getWidth()) / 2;
                    int y = this.editor.getY() + (this.editor.getHeight() - this.window.getHeight()) / 2;
                    this.window.setLocation(x, y);
                    this.window.setVisible(true);
                    this.window.toFront();
                }
            });
        }

        void rename(PreprocessedSketch ps, IBinding binding, String newName) {
            ASTNode decl;
            IMethodBinding method;
            CompilationUnit root = ps.compilationUnit;
            if (binding.getKind() == 4 && (method = (IMethodBinding)binding).isConstructor()) {
                binding = method.getDeclaringClass();
            }
            if ((decl = root.findDeclaringNode(binding.getKey())) == null) {
                return;
            }
            PDEX.this.showUsage.hide();
            ArrayList<SimpleName> occurrences = new ArrayList<SimpleName>();
            occurrences.addAll(ASTUtils.findAllOccurrences((ASTNode)root, binding.getKey()));
            if (binding.getKind() == 2) {
                ITypeBinding type = (ITypeBinding)binding;
                IMethodBinding[] methods = type.getDeclaredMethods();
                Arrays.stream(methods).filter(IMethodBinding::isConstructor).flatMap(c -> ASTUtils.findAllOccurrences((ASTNode)root, c.getKey()).stream()).forEach(occurrences::add);
            }
            Map<Integer, List<PreprocessedSketch.SketchInterval>> mappedNodes = occurrences.stream().map(ps::mapJavaToSketch).filter(ps::inRange).collect(Collectors.groupingBy(interval -> interval.tabIndex));
            Sketch sketch = ps.sketch;
            this.editor.startCompoundEdit();
            mappedNodes.entrySet().forEach(entry -> {
                int tabIndex = (Integer)entry.getKey();
                SketchCode sketchCode = sketch.getCode(tabIndex);
                SyntaxDocument document = (SyntaxDocument)sketchCode.getDocument();
                List nodes = (List)entry.getValue();
                nodes.stream().sorted(Comparator.comparing(si -> si.startTabOffset).reversed()).forEach(si -> {
                    int documentLength = document.getLength();
                    if (si.startTabOffset >= 0 && si.startTabOffset <= documentLength && si.stopTabOffset >= 0 && si.stopTabOffset <= documentLength) {
                        int length = si.stopTabOffset - si.startTabOffset;
                        try {
                            document.remove(si.startTabOffset, length);
                            document.insertString(si.startTabOffset, newName, null);
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                });
                try {
                    sketchCode.setProgram(document.getText(0, document.getLength()));
                }
                catch (BadLocationException badLocationException) {}
                sketchCode.setModified(true);
            });
            this.editor.stopCompoundEdit();
            this.editor.repaintHeader();
            int currentTabIndex = sketch.getCurrentCodeIndex();
            int currentOffset = this.editor.getCaretOffset();
            int precedingIntervals = (int)mappedNodes.getOrDefault(currentTabIndex, Collections.emptyList()).stream().filter(interval -> interval.stopTabOffset < currentOffset).count();
            int intervalLengthDiff = newName.length() - binding.getName().length();
            int offsetDiff = precedingIntervals * intervalLengthDiff;
            this.editor.getTextArea().setCaretPosition(currentOffset + offsetDiff);
        }

        void dispose() {
            if (this.window != null) {
                this.window.dispose();
            }
        }
    }

    private static class ShowUsage {
        final JDialog window;
        final JTree tree;
        final JavaEditor editor;
        final PreprocessingService pps;
        final Consumer<PreprocessedSketch> reloadListener;
        IBinding binding;

        ShowUsage(JavaEditor editor, final PreprocessingService pps) {
            this.editor = editor;
            this.pps = pps;
            JMenuItem showUsageItem = new JMenuItem(Language.text((String)"editor.popup.show_usage"));
            showUsageItem.addActionListener(e -> this.handleShowUsage());
            editor.getTextArea().getRightClickPopup().add(showUsageItem);
            this.reloadListener = this::reloadShowUsage;
            this.window = new JDialog((Frame)((Object)editor));
            this.window.setDefaultCloseOperation(1);
            this.window.setAutoRequestFocus(false);
            this.window.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent e) {
                    binding = null;
                    tree.setModel(null);
                    pps.unregisterListener(reloadListener);
                }

                @Override
                public void componentShown(ComponentEvent e) {
                    pps.registerListener(reloadListener);
                }
            });
            this.window.setSize(300, 400);
            this.window.setFocusableWindowState(false);
            Toolkit.setIcon((Window)this.window);
            JScrollPane sp2 = new JScrollPane();
            this.tree = new JTree();
            DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)this.tree.getCellRenderer();
            renderer.setLeafIcon(null);
            renderer.setClosedIcon(null);
            renderer.setOpenIcon(null);
            renderer.setBackgroundSelectionColor(new Color(228, 248, 246));
            renderer.setBorderSelectionColor(new Color(0, 0, 0, 0));
            renderer.setTextSelectionColor(Color.BLACK);
            sp2.setViewportView(this.tree);
            this.window.add(sp2);
            this.tree.addTreeSelectionListener(e -> {
                if (this.tree.getLastSelectedPathComponent() == null) {
                    return;
                }
                DefaultMutableTreeNode tnode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
                if (tnode.getUserObject() instanceof ShowUsageTreeNode) {
                    ShowUsageTreeNode node = (ShowUsageTreeNode)tnode.getUserObject();
                    editor.highlight(node.tabIndex, node.startTabOffset, node.stopTabOffset);
                }
            });
        }

        void handleShowUsage() {
            int startOffset = this.editor.getSelectionStart();
            int stopOffset = this.editor.getSelectionStop();
            int tabIndex = this.editor.getSketch().getCurrentCodeIndex();
            this.pps.whenDoneBlocking(ps -> this.handleShowUsage((PreprocessedSketch)ps, tabIndex, startOffset, stopOffset));
        }

        void handleShowUsage(PreprocessedSketch ps, int tabIndex, int startTabOffset, int stopTabOffset) {
            int stopJavaOffset;
            int startJavaOffset = ps.tabOffsetToJavaOffset(tabIndex, startTabOffset);
            SimpleName name = ASTUtils.getSimpleNameAt((ASTNode)ps.compilationUnit, startJavaOffset, stopJavaOffset = ps.tabOffsetToJavaOffset(tabIndex, stopTabOffset));
            if (name == null) {
                this.editor.statusMessage("Cannot find any name under cursor", 0);
                return;
            }
            IBinding binding = ASTUtils.resolveBinding(name);
            if (binding == null) {
                this.editor.statusMessage("Cannot find usages, try to fix errors in your code first", 0);
                return;
            }
            this.findUsageAndUpdateTree(ps, binding);
        }

        void findUsageAndUpdateTree(PreprocessedSketch ps, IBinding binding) {
            this.binding = binding;
            String bindingType = "";
            switch (binding.getKind()) {
                case 4: {
                    IMethodBinding method = (IMethodBinding)binding;
                    if (method.isConstructor()) {
                        bindingType = "Constructor";
                        break;
                    }
                    bindingType = "Method";
                    break;
                }
                case 2: {
                    bindingType = "Type";
                    break;
                }
                case 3: {
                    IVariableBinding variable = (IVariableBinding)binding;
                    bindingType = variable.isField() ? "Field" : (variable.isParameter() ? "Parameter" : (variable.isEnumConstant() ? "Enum constant" : "Local variable"));
                }
            }
            String bindingKey = binding.getKey();
            List intervals = ASTUtils.findAllOccurrences((ASTNode)ps.compilationUnit, bindingKey).stream().map(ps::mapJavaToSketch).filter(ps::inRange).filter(in -> in.startPdeOffset < in.stopPdeOffset).collect(Collectors.toList());
            int usageCount = intervals.size();
            String elementName = intervals.stream().findAny().map(si -> preprocessedSketch.pdeCode.substring(si.startPdeOffset, si.stopPdeOffset)).orElseGet(() -> ((IBinding)binding).getName());
            DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(String.valueOf(bindingType) + ": " + elementName);
            intervals.stream().map(in -> ShowUsageTreeNode.fromSketchInterval(ps, in)).collect(Collectors.groupingBy(node -> node.tabIndex)).entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(entry -> {
                Integer tabIndex = (Integer)entry.getKey();
                List nodes = (List)entry.getValue();
                int count = nodes.size();
                String usageLabel = count == 1 ? "usage" : "usages";
                String tabLabel = "<html><font color=#222222>" + preprocessedSketch.sketch.getCode(tabIndex.intValue()).getPrettyName() + "</font> <font color=#999999>" + count + " " + usageLabel + "</font></html>";
                DefaultMutableTreeNode tabNode = new DefaultMutableTreeNode(tabLabel);
                nodes.stream().map(DefaultMutableTreeNode::new).forEach(tabNode::add);
                return tabNode;
            }).forEach(rootNode::add);
            DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
            EventQueue.invokeLater(() -> {
                this.tree.setModel(treeModel);
                int i = 0;
                while (i < this.tree.getRowCount()) {
                    this.tree.expandRow(i);
                    ++i;
                }
                this.tree.setRootVisible(true);
                if (!this.window.isVisible()) {
                    this.window.setVisible(true);
                    GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    GraphicsDevice defaultScreen = ge.getDefaultScreenDevice();
                    Rectangle rect = defaultScreen.getDefaultConfiguration().getBounds();
                    int maxX = (int)rect.getMaxX() - this.window.getWidth();
                    int x = Math.min(this.editor.getX() + this.editor.getWidth(), maxX);
                    int y = x == maxX ? 10 : this.editor.getY();
                    this.window.setLocation(x, y);
                }
                this.window.toFront();
                this.window.setTitle("Usage of \"" + elementName + "\" : " + usageCount + " time(s)");
            });
        }

        void reloadShowUsage(PreprocessedSketch ps) {
            if (this.binding != null) {
                this.findUsageAndUpdateTree(ps, this.binding);
            }
        }

        void hide() {
            this.window.setVisible(false);
        }

        void dispose() {
            if (this.window != null) {
                this.window.dispose();
            }
        }
    }

    private static class ShowUsageTreeNode {
        final int tabIndex;
        final int startTabOffset;
        final int stopTabOffset;
        final String text;

        ShowUsageTreeNode(int tabIndex, int startTabOffset, int stopTabOffset, String text) {
            this.tabIndex = tabIndex;
            this.startTabOffset = startTabOffset;
            this.stopTabOffset = stopTabOffset;
            this.text = text;
        }

        static ShowUsageTreeNode fromSketchInterval(PreprocessedSketch ps, PreprocessedSketch.SketchInterval in) {
            int lineStartPdeOffset = ps.pdeCode.lastIndexOf(10, in.startPdeOffset) + 1;
            int lineStopPdeOffset = ps.pdeCode.indexOf(10, in.stopPdeOffset);
            if (lineStopPdeOffset == -1) {
                lineStopPdeOffset = ps.pdeCode.length();
            }
            int highlightStartOffset = in.startPdeOffset - lineStartPdeOffset;
            int highlightStopOffset = in.stopPdeOffset - lineStartPdeOffset;
            int tabLine = ps.tabOffsetToTabLine(in.tabIndex, in.startTabOffset);
            String line = ps.pdeCode.substring(lineStartPdeOffset, lineStopPdeOffset);
            String pre = line.substring(0, highlightStartOffset).replace("&", "&amp;").replace(">", "&gt;").replace("<", "&lt;");
            String highlight = line.substring(highlightStartOffset, highlightStopOffset).replace("&", "&amp;").replace(">", "&gt;").replace("<", "&lt;");
            String post = line.substring(highlightStopOffset).replace("&", "&amp;").replace(">", "&gt;").replace("<", "&lt;");
            line = String.valueOf(pre) + "<font color=#222222><b>" + highlight + "</b></font>" + post;
            line = line.trim();
            String text = "<html><font color=#bbbbbb>" + (tabLine + 1) + "</font> <font color=#777777>" + line + "</font></html>";
            return new ShowUsageTreeNode(in.tabIndex, in.startTabOffset, in.stopTabOffset, text);
        }

        public String toString() {
            return this.text;
        }
    }
}

