/*
 * Decompiled with CFR 0.152.
 */
package processing.io;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import processing.io.NativeInterface;

public class PWM {
    int channel;
    String chip;

    public PWM(String string) {
        NativeInterface.loadLibrary();
        int n = string.indexOf("/pwm");
        if (n == -1) {
            throw new IllegalArgumentException("Unsupported channel");
        }
        this.chip = string.substring(0, n);
        this.channel = Integer.parseInt(string.substring(n + 4));
        if (NativeInterface.isSimulated()) {
            return;
        }
        String string2 = "/sys/class/pwm/" + this.chip + "/export";
        int n2 = NativeInterface.writeFile(string2, Integer.toString(this.channel));
        if (n2 < 0) {
            if (n2 == -2) {
                System.err.println("Make sure your kernel is compiled with PWM_SYSFS enabled and you have the necessary PWM driver for your platform");
            }
            if (n2 == -22) {
                System.err.println("PWM channel " + string + " does not seem to be available on your platform");
            }
            if (n2 != -16) {
                throw new RuntimeException(String.valueOf(string2) + ": " + NativeInterface.getError(n2));
            }
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public void clear() {
        if (NativeInterface.isSimulated()) {
            return;
        }
        String string = String.format("/sys/class/pwm/%s/pwm%d/enable", this.chip, this.channel);
        int n = NativeInterface.writeFile(string, "0");
        if (n < 0) {
            throw new RuntimeException(NativeInterface.getError(n));
        }
    }

    public void close() {
        if (NativeInterface.isSimulated()) {
            return;
        }
        String string = "/sys/class/pwm/" + this.chip + "/export";
        int n = NativeInterface.writeFile(string, Integer.toString(this.channel));
        if (n < 0) {
            if (n == -2) {
                System.err.println("Make sure your kernel is compiled with PWM_SYSFS enabled and you have the necessary PWM driver for your platform");
            }
            throw new RuntimeException(NativeInterface.getError(n));
        }
    }

    public static String[] list() {
        Object object;
        if (NativeInterface.isSimulated()) {
            return new String[]{"pwmchip0/pwm0", "pwmchip0/pwm1"};
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File("/sys/class/pwm");
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            File[] fileArray2 = fileArray;
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = fileArray2[n2];
                try {
                    Path path = Paths.get("/sys/class/pwm/" + ((File)object).getName() + "/npwm", new String[0]);
                    String string = new String(Files.readAllBytes(path));
                    int n3 = Integer.parseInt(string.trim());
                    int n4 = 0;
                    while (n4 < n3) {
                        arrayList.add(String.valueOf(((File)object).getName()) + "/pwm" + n4);
                        ++n4;
                    }
                }
                catch (Exception exception) {}
                ++n2;
            }
        }
        object = arrayList.toArray(new String[arrayList.size()]);
        Arrays.sort((Object[])object);
        return object;
    }

    public void set(int n, float f) {
        if (NativeInterface.isSimulated()) {
            return;
        }
        String string = String.format("/sys/class/pwm/%s/pwm%d/period", this.chip, this.channel);
        int n2 = NativeInterface.writeFile(string, String.format("%d", 1000000000 / n));
        if (n2 < 0) {
            throw new RuntimeException(String.valueOf(string) + ": " + NativeInterface.getError(n2));
        }
        string = String.format("/sys/class/pwm/%s/pwm%d/duty_cycle", this.chip, this.channel);
        if ((double)f < 0.0 || 1.0 < (double)f) {
            System.err.println("Duty cycle must be between 0.0 and 1.0.");
            throw new IllegalArgumentException("Illegal argument");
        }
        n2 = NativeInterface.writeFile(string, String.format("%d", (int)(1.0E9f * f / (float)n)));
        if (n2 < 0) {
            throw new RuntimeException(String.valueOf(string) + ": " + NativeInterface.getError(n2));
        }
        string = String.format("/sys/class/pwm/%s/pwm%d/enable", this.chip, this.channel);
        n2 = NativeInterface.writeFile(string, "1");
        if (n2 < 0) {
            throw new RuntimeException(String.valueOf(string) + ": " + NativeInterface.getError(n2));
        }
    }

    public void set(float f) {
        this.set(1000, f);
    }
}

