/*
 * Decompiled with CFR 0.152.
 */
package processing.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.Socket;
import processing.core.PApplet;

public class Client
implements Runnable {
    PApplet parent;
    Method clientEventMethod;
    Method disconnectEventMethod;
    Thread thread;
    Socket socket;
    int port;
    String host;
    public InputStream input;
    public OutputStream output;
    byte[] buffer = new byte[32768];
    int bufferIndex;
    int bufferLast;
    boolean disposeRegistered = false;

    public Client(PApplet pApplet, String string, int n) {
        this.parent = pApplet;
        this.host = string;
        this.port = n;
        try {
            this.socket = new Socket(this.host, this.port);
            this.input = this.socket.getInputStream();
            this.output = this.socket.getOutputStream();
            this.thread = new Thread(this);
            this.thread.start();
            pApplet.registerMethod("dispose", (Object)this);
            this.disposeRegistered = true;
            try {
                this.clientEventMethod = pApplet.getClass().getMethod("clientEvent", Client.class);
            }
            catch (Exception exception) {}
            try {
                this.disconnectEventMethod = pApplet.getClass().getMethod("disconnectEvent", Client.class);
            }
            catch (Exception exception) {}
        }
        catch (ConnectException connectException) {
            connectException.printStackTrace();
            this.dispose();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.dispose();
        }
    }

    public Client(PApplet pApplet, Socket socket) throws IOException {
        this.parent = pApplet;
        this.socket = socket;
        this.input = socket.getInputStream();
        this.output = socket.getOutputStream();
        this.thread = new Thread(this);
        this.thread.start();
        try {
            this.disconnectEventMethod = pApplet.getClass().getMethod("disconnectEvent", Client.class);
        }
        catch (Exception exception) {}
    }

    public void stop() {
        if (this.disconnectEventMethod != null && this.thread != null) {
            try {
                this.disconnectEventMethod.invoke((Object)this.parent, this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.disconnectEventMethod = null;
            }
        }
        if (this.disposeRegistered) {
            this.parent.unregisterMethod("dispose", (Object)this);
            this.disposeRegistered = false;
        }
        this.dispose();
    }

    public void dispose() {
        this.thread = null;
        try {
            if (this.input != null) {
                this.input.close();
                this.input = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            if (this.output != null) {
                this.output.close();
                this.output = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean active() {
        return this.thread != null;
    }

    public String ip() {
        if (this.socket != null) {
            return this.socket.getInetAddress().getHostAddress();
        }
        return null;
    }

    public int available() {
        return this.bufferLast - this.bufferIndex;
    }

    public void clear() {
        this.bufferLast = 0;
        this.bufferIndex = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() {
        if (this.bufferIndex == this.bufferLast) {
            return -1;
        }
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int n = this.buffer[this.bufferIndex++] & 0xFF;
            if (this.bufferIndex == this.bufferLast) {
                this.bufferIndex = 0;
                this.bufferLast = 0;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return n;
        }
    }

    public char readChar() {
        if (this.bufferIndex == this.bufferLast) {
            return '\uffff';
        }
        return (char)this.read();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytes() {
        if (this.bufferIndex == this.bufferLast) {
            return null;
        }
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int n = this.bufferLast - this.bufferIndex;
            byte[] byArray2 = new byte[n];
            System.arraycopy(this.buffer, this.bufferIndex, byArray2, 0, n);
            this.bufferIndex = 0;
            this.bufferLast = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return byArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytes(int n) {
        if (this.bufferIndex == this.bufferLast) {
            return null;
        }
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int n2 = this.bufferLast - this.bufferIndex;
            if (n2 > n) {
                n2 = n;
            }
            byte[] byArray2 = new byte[n2];
            System.arraycopy(this.buffer, this.bufferIndex, byArray2, 0, n2);
            this.bufferIndex += n2;
            if (this.bufferIndex == this.bufferLast) {
                this.bufferIndex = 0;
                this.bufferLast = 0;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return byArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readBytes(byte[] byArray) {
        if (this.bufferIndex == this.bufferLast) {
            return 0;
        }
        byte[] byArray2 = this.buffer;
        synchronized (this.buffer) {
            int n = this.bufferLast - this.bufferIndex;
            if (n > byArray.length) {
                n = byArray.length;
            }
            System.arraycopy(this.buffer, this.bufferIndex, byArray, 0, n);
            this.bufferIndex += n;
            if (this.bufferIndex == this.bufferLast) {
                this.bufferIndex = 0;
                this.bufferLast = 0;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytesUntil(int n) {
        if (this.bufferIndex == this.bufferLast) {
            return null;
        }
        byte by = (byte)n;
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int n2;
            int n3;
            block8: {
                n3 = -1;
                n2 = this.bufferIndex;
                while (n2 < this.bufferLast) {
                    if (this.buffer[n2] == by) {
                        n3 = n2;
                        break;
                    }
                    ++n2;
                }
                if (n3 != -1) break block8;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return null;
            }
            n2 = n3 - this.bufferIndex + 1;
            byte[] byArray2 = new byte[n2];
            System.arraycopy(this.buffer, this.bufferIndex, byArray2, 0, n2);
            this.bufferIndex += n2;
            if (this.bufferIndex == this.bufferLast) {
                this.bufferIndex = 0;
                this.bufferLast = 0;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return byArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readBytesUntil(int n, byte[] byArray) {
        if (this.bufferIndex == this.bufferLast) {
            return 0;
        }
        byte by = (byte)n;
        byte[] byArray2 = this.buffer;
        synchronized (this.buffer) {
            int n2;
            block10: {
                int n3;
                block9: {
                    n3 = -1;
                    n2 = this.bufferIndex;
                    while (n2 < this.bufferLast) {
                        if (this.buffer[n2] == by) {
                            n3 = n2;
                            break;
                        }
                        ++n2;
                    }
                    if (n3 != -1) break block9;
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return 0;
                }
                n2 = n3 - this.bufferIndex + 1;
                if (n2 <= byArray.length) break block10;
                System.err.println("readBytesUntil() byte buffer is too small for the " + n2 + " bytes up to and including char " + n);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return -1;
            }
            System.arraycopy(this.buffer, this.bufferIndex, byArray, 0, n2);
            this.bufferIndex += n2;
            if (this.bufferIndex == this.bufferLast) {
                this.bufferIndex = 0;
                this.bufferLast = 0;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return n2;
        }
    }

    public String readString() {
        if (this.bufferIndex == this.bufferLast) {
            return null;
        }
        return new String(this.readBytes());
    }

    public String readStringUntil(int n) {
        byte[] byArray = this.readBytesUntil(n);
        if (byArray == null) {
            return null;
        }
        return new String(byArray);
    }

    public void write(int n) {
        try {
            this.output.write(n & 0xFF);
            this.output.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.stop();
        }
    }

    public void write(byte[] byArray) {
        try {
            this.output.write(byArray);
            this.output.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.stop();
        }
    }

    public void write(String string) {
        this.write(string.getBytes());
    }
}

