/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.ImageObserver;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import processing.app.Language;
import processing.app.Messages;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.Util;

public class Toolkit {
    static final java.awt.Toolkit awtToolkit = java.awt.Toolkit.getDefaultToolkit();
    static final int SHORTCUT_KEY_MASK = awtToolkit.getMenuShortcutKeyMask();
    public static final KeyStroke WINDOW_CLOSE_KEYSTROKE = KeyStroke.getKeyStroke(87, SHORTCUT_KEY_MASK);
    static final int SHORTCUT_ALT_KEY_MASK = 8 | SHORTCUT_KEY_MASK;
    static final int SHORTCUT_SHIFT_KEY_MASK = 1 | SHORTCUT_KEY_MASK;
    static List<Image> iconImages;
    static Boolean highResProp;
    static final char GREEK_SMALL_LETTER_ALPHA = '\u03b1';
    static final char GREEK_CAPITAL_LETTER_OMEGA = '\u03a9';
    static Font monoFont;
    static Font monoBoldFont;
    static Font sansFont;
    static Font sansBoldFont;

    public static int getButtonWidth() {
        return Integer.parseInt(Language.text("preferences.button.width"));
    }

    public static JMenuItem newJMenuItem(String title, int what) {
        JMenuItem menuItem = new JMenuItem(title);
        int modifiers = awtToolkit.getMenuShortcutKeyMask();
        menuItem.setAccelerator(KeyStroke.getKeyStroke(what, modifiers));
        return menuItem;
    }

    public static JMenuItem newJMenuItem(Action action, int what) {
        JMenuItem menuItem = new JMenuItem(action);
        int modifiers = awtToolkit.getMenuShortcutKeyMask();
        menuItem.setAccelerator(KeyStroke.getKeyStroke(what, modifiers));
        return menuItem;
    }

    public static JMenuItem newJMenuItemShift(String title, int what) {
        JMenuItem menuItem = new JMenuItem(title);
        int modifiers = awtToolkit.getMenuShortcutKeyMask();
        menuItem.setAccelerator(KeyStroke.getKeyStroke(what, modifiers |= 1));
        return menuItem;
    }

    public static JMenuItem newJMenuItemShift(Action action, int what) {
        JMenuItem menuItem = new JMenuItem(action);
        int modifiers = awtToolkit.getMenuShortcutKeyMask();
        menuItem.setAccelerator(KeyStroke.getKeyStroke(what, modifiers |= 1));
        return menuItem;
    }

    public static JMenuItem newJMenuItemAlt(String title, int what) {
        JMenuItem menuItem = new JMenuItem(title);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(what, SHORTCUT_ALT_KEY_MASK));
        return menuItem;
    }

    public static JCheckBoxMenuItem newJCheckBoxMenuItem(String title, int what) {
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(title);
        int modifiers = awtToolkit.getMenuShortcutKeyMask();
        menuItem.setAccelerator(KeyStroke.getKeyStroke(what, modifiers));
        return menuItem;
    }

    public static void addDisabledItem(JMenu menu, String title) {
        JMenuItem item = new JMenuItem(title);
        item.setEnabled(false);
        menu.add(item);
    }

    public static void setMenuMnemonics(JMenuItem ... menu) {
        JMenuItem jmi;
        if (Platform.isMacOS()) {
            return;
        }
        if (menu.length == 0) {
            return;
        }
        String[] kdePreDefStrs = new String[]{"&file", "&new", "&open", "open&recent", "&save", "save&as", "saveacop&y", "saveas&template", "savea&ll", "reloa&d", "&print", "printpre&view", "&import", "e&xport", "&closefile", "clos&eallfiles", "&quit", "&edit", "&undo", "re&do", "cu&t", "&copy", "&paste", "&delete", "select&all", "dese&lect", "&find", "find&next", "findpre&vious", "&replace", "&gotoline", "&view", "&newview", "close&allviews", "&splitview", "&removeview", "splitter&orientation", "&horizontal", "&vertical", "view&mode", "&fullscreenmode", "&zoom", "zoom&in", "zoom&out", "zoomtopage&width", "zoomwhole&page", "zoom&factor", "&insert", "&format", "&go", "&up", "&back", "&forward", "&home", "&go", "&previouspage", "&nextpage", "&firstpage", "&lastpage", "read&updocument", "read&downdocument", "&back", "&forward", "&gotopage", "&bookmarks", "&addbookmark", "bookmark&tabsasfolder", "&editbookmarks", "&newbookmarksfolder", "&tools", "&settings", "&toolbars", "configure&shortcuts", "configuretool&bars", "&configure.*", "&help", ".+&handbook", "&whatsthis", "report&bug", "&aboutprocessing", "about&kde", "&beenden", "&suchen", "&preferncias", "&sair", "&rechercher"};
        Pattern[] kdePreDefPats = new Pattern[kdePreDefStrs.length];
        int i = 0;
        while (i < kdePreDefStrs.length) {
            kdePreDefPats[i] = Pattern.compile(kdePreDefStrs[i].replace("&", ""));
            ++i;
        }
        Pattern nonAAlpha = Pattern.compile("[^A-Za-z]");
        FontMetrics fmTmp = null;
        JMenuItem[] jMenuItemArray = menu;
        int n = menu.length;
        int n2 = 0;
        while (n2 < n) {
            JMenuItem m = jMenuItemArray[n2];
            if (m != null) {
                fmTmp = m.getFontMetrics(m.getFont());
                break;
            }
            ++n2;
        }
        if (fmTmp == null) {
            return;
        }
        final FontMetrics fm = fmTmp;
        Comparator<Character> charComparator = new Comparator<Character>(){
            char[] baddies = "qypgjaeiouQAEIOU".toCharArray();

            @Override
            public int compare(Character ch1, Character ch2) {
                float w1 = fm.charWidth(ch1.charValue());
                float w2 = fm.charWidth(ch2.charValue());
                char[] cArray = this.baddies;
                int n = this.baddies.length;
                int n2 = 0;
                while (n2 < n) {
                    char bad = cArray[n2];
                    if (bad == ch1.charValue()) {
                        w1 *= 0.66f;
                    }
                    if (bad == ch2.charValue()) {
                        w2 *= 0.66f;
                    }
                    ++n2;
                }
                return (int)Math.signum(w2 - w1);
            }
        };
        ArrayList<Character> taken = new ArrayList<Character>(menu.length);
        JMenuItem[] jMenuItemArray2 = menu;
        int n3 = menu.length;
        int n4 = 0;
        while (n4 < n3) {
            jmi = jMenuItemArray2[n4];
            if (jmi != null && jmi.getText() != null) {
                jmi.setMnemonic(0);
                String asciiName = nonAAlpha.matcher(jmi.getText()).replaceAll("");
                String lAsciiName = asciiName.toLowerCase();
                int i2 = 0;
                while (i2 < kdePreDefStrs.length) {
                    if (kdePreDefPats[i2].matcher(lAsciiName).matches()) {
                        char mnem = asciiName.charAt(kdePreDefStrs[i2].indexOf("&"));
                        jmi.setMnemonic(mnem);
                        jmi.setDisplayedMnemonicIndex(jmi.getText().indexOf(mnem));
                        taken.add(Character.valueOf((char)(mnem | 0x20)));
                        break;
                    }
                    ++i2;
                }
            }
            ++n4;
        }
        jMenuItemArray2 = menu;
        n3 = menu.length;
        n4 = 0;
        while (n4 < n3) {
            block31: {
                jmi = jMenuItemArray2[n4];
                if (jmi != null && jmi.getText() != null && jmi.getMnemonic() == 0) {
                    String cleanString = jmi.getText();
                    if (cleanString.startsWith("sketchbook \u2192 ")) {
                        cleanString = cleanString.substring(13);
                    }
                    if (cleanString.length() != 0) {
                        char ascii2nd;
                        ArrayList<Character> banned = new ArrayList<Character>();
                        int i3 = 0;
                        while (i3 < cleanString.length()) {
                            if (cleanString.charAt(i3) == '_') {
                                if (i3 > 0) {
                                    banned.add(Character.valueOf(Character.toLowerCase(cleanString.charAt(i3 - 1))));
                                }
                                if (i3 + 1 < cleanString.length()) {
                                    banned.add(Character.valueOf(Character.toLowerCase(cleanString.charAt(i3 + 1))));
                                }
                            }
                            ++i3;
                        }
                        Object[] objectArray = cleanString.split("[^\\p{IsAlphabetic}]");
                        int n5 = objectArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            char firstChar;
                            String wd = objectArray[n6];
                            if (wd.length() != 0 && !taken.contains(Character.valueOf(Character.toLowerCase(firstChar = wd.charAt(0)))) && !banned.contains(Character.valueOf(Character.toLowerCase(firstChar))) && 'A' <= firstChar && firstChar <= 'Z') {
                                jmi.setMnemonic(firstChar);
                                jmi.setDisplayedMnemonicIndex(jmi.getText().indexOf(firstChar));
                                taken.add(Character.valueOf((char)(firstChar | 0x20)));
                                break block31;
                            }
                            ++n6;
                        }
                        objectArray = cleanString.split("[^\\p{IsAlphabetic}]");
                        n5 = objectArray.length;
                        n6 = 0;
                        while (n6 < n5) {
                            char firstChar;
                            String wd = objectArray[n6];
                            if (wd.length() != 0 && !taken.contains(Character.valueOf(Character.toLowerCase(firstChar = wd.charAt(0)))) && !banned.contains(Character.valueOf(Character.toLowerCase(firstChar))) && 'a' <= firstChar && firstChar <= 'z') {
                                jmi.setMnemonic(firstChar);
                                jmi.setDisplayedMnemonicIndex(jmi.getText().indexOf(firstChar));
                                taken.add(Character.valueOf(firstChar));
                                break block31;
                            }
                            ++n6;
                        }
                        cleanString = nonAAlpha.matcher(jmi.getText()).replaceAll("");
                        if (cleanString.length() >= 2 && !taken.contains(Character.valueOf((char)((ascii2nd = cleanString.charAt(1)) | 0x20))) && !banned.contains(Character.valueOf((char)(ascii2nd | 0x20))) && fm.charWidth('A') <= 2 * fm.charWidth(ascii2nd)) {
                            jmi.setMnemonic(ascii2nd);
                            jmi.setDisplayedMnemonicIndex(jmi.getText().indexOf(ascii2nd));
                            taken.add(Character.valueOf((char)(ascii2nd | 0x20)));
                        } else {
                            char[] cleanChars = cleanString.toCharArray();
                            Character[] cleanCharas = new Character[cleanChars.length];
                            i = 0;
                            while (i < cleanChars.length) {
                                cleanCharas[i] = new Character(cleanChars[i]);
                                ++i;
                            }
                            Arrays.sort(cleanCharas, charComparator);
                            objectArray = cleanCharas;
                            n5 = cleanCharas.length;
                            n6 = 0;
                            while (n6 < n5) {
                                char mnem = ((Character)objectArray[n6]).charValue();
                                if (!taken.contains(Character.valueOf(Character.toLowerCase(mnem))) && !banned.contains(Character.valueOf(Character.toLowerCase(mnem)))) {
                                    jmi.setMnemonic(mnem);
                                    jmi.setDisplayedMnemonicIndex(jmi.getText().indexOf(mnem));
                                    taken.add(Character.valueOf(Character.toLowerCase(mnem)));
                                    break block31;
                                }
                                ++n6;
                            }
                            char[] cArray = jmi.getText().replaceAll("[^0-9]", "").toCharArray();
                            objectArray = cArray;
                            n5 = cArray.length;
                            n6 = 0;
                            while (n6 < n5) {
                                Object digit = objectArray[n6];
                                if (!taken.contains(Character.valueOf((char)digit)) && !banned.contains(Character.valueOf((char)digit))) {
                                    jmi.setMnemonic(48 + digit - 48);
                                    taken.add(Character.valueOf((char)digit));
                                    break;
                                }
                                ++n6;
                            }
                        }
                    }
                }
            }
            ++n4;
        }
        jMenuItemArray2 = menu;
        n3 = menu.length;
        n4 = 0;
        while (n4 < n3) {
            jmi = jMenuItemArray2[n4];
            if (jmi instanceof JMenu) {
                Toolkit.setMenuMnemsInside((JMenu)jmi);
            }
            ++n4;
        }
    }

    public static void setMenuMnemonics(JMenuBar menubar) {
        JMenuItem[] items = new JMenuItem[menubar.getMenuCount()];
        int i = 0;
        while (i < items.length) {
            items[i] = menubar.getMenu(i);
            ++i;
        }
        Toolkit.setMenuMnemonics(items);
    }

    public static void setMenuMnemonics(JPopupMenu menu) {
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        Component[] componentArray = menu.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c instanceof JMenuItem) {
                items.add((JMenuItem)c);
            }
            ++n2;
        }
        Toolkit.setMenuMnemonics(items.toArray(new JMenuItem[items.size()]));
    }

    public static void setMenuMnemsInside(JMenu menu) {
        JMenuItem[] items = new JMenuItem[menu.getItemCount()];
        int i = 0;
        while (i < items.length) {
            items[i] = menu.getItem(i);
            ++i;
        }
        Toolkit.setMenuMnemonics(items);
    }

    public static Dimension getScreenSize() {
        return awtToolkit.getScreenSize();
    }

    public static Image getLibImage(String filename) {
        ImageIcon icon = Toolkit.getLibIcon(filename);
        return icon == null ? null : icon.getImage();
    }

    public static ImageIcon getLibIcon(String filename) {
        File file = Platform.getContentFile("lib/" + filename);
        if (!file.exists()) {
            return null;
        }
        return new ImageIcon(file.getAbsolutePath());
    }

    public static ImageIcon getIconX(File dir, String base) {
        return Toolkit.getIconX(dir, base, 0);
    }

    public static ImageIcon getIconX(File dir, String base, int size) {
        final int scale = Toolkit.highResDisplay() ? 2 : 1;
        String filename = size == 0 ? String.valueOf(base) + "-" + scale + "x.png" : String.valueOf(base) + "-" + size * scale + ".png";
        File file = new File(dir, filename);
        if (!file.exists()) {
            return null;
        }
        ImageIcon outgoing = new ImageIcon(file.getAbsolutePath()){

            @Override
            public int getIconWidth() {
                return super.getIconWidth() / scale;
            }

            @Override
            public int getIconHeight() {
                return super.getIconHeight() / scale;
            }

            @Override
            public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
                ImageObserver imageObserver = this.getImageObserver();
                if (imageObserver == null) {
                    imageObserver = c;
                }
                g.drawImage(this.getImage(), x, y, this.getIconWidth(), this.getIconHeight(), imageObserver);
            }
        };
        return outgoing;
    }

    public static ImageIcon getLibIconX(String base) {
        return Toolkit.getLibIconX(base, 0);
    }

    public static ImageIcon getLibIconX(String base, int size) {
        return Toolkit.getIconX(Platform.getContentFile("lib"), base, size);
    }

    public static void setIcon(Frame frame) {
        Toolkit.setIcon((Window)frame);
    }

    public static void setIcon(Window window) {
        if (!Platform.isMacOS()) {
            if (iconImages == null) {
                int[] sizes;
                iconImages = new ArrayList<Image>();
                int[] nArray = sizes = new int[]{16, 32, 48, 64, 128, 256, 512};
                int n = sizes.length;
                int n2 = 0;
                while (n2 < n) {
                    int sz = nArray[n2];
                    iconImages.add(Toolkit.getLibImage("icons/pde-" + sz + ".png"));
                    ++n2;
                }
            }
            window.setIconImages(iconImages);
        }
    }

    public static Shape createRoundRect(float x1, float y1, float x2, float y2, float tl, float tr, float br, float bl) {
        GeneralPath path = new GeneralPath();
        if (tr != 0.0f) {
            path.moveTo(x2 - tr, y1);
            path.quadTo(x2, y1, x2, y1 + tr);
        } else {
            path.moveTo(x2, y1);
        }
        if (br != 0.0f) {
            path.lineTo(x2, y2 - br);
            path.quadTo(x2, y2, x2 - br, y2);
        } else {
            path.lineTo(x2, y2);
        }
        if (bl != 0.0f) {
            path.lineTo(x1 + bl, y2);
            path.quadTo(x1, y2, x1, y2 - bl);
        } else {
            path.lineTo(x1, y2);
        }
        if (tl != 0.0f) {
            path.lineTo(x1, y1 + tl);
            path.quadTo(x1, y1, x1 + tl, y1);
        } else {
            path.lineTo(x1, y1);
        }
        path.closePath();
        return path;
    }

    public static void registerWindowCloseKeys(JRootPane root, ActionListener disposer) {
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        root.registerKeyboardAction(disposer, stroke, 2);
        int modifiers = awtToolkit.getMenuShortcutKeyMask();
        stroke = KeyStroke.getKeyStroke(87, modifiers);
        root.registerKeyboardAction(disposer, stroke, 2);
    }

    public static void beep() {
        awtToolkit.beep();
    }

    public static Clipboard getSystemClipboard() {
        return awtToolkit.getSystemClipboard();
    }

    public static Graphics2D prepareGraphics(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (Toolkit.highResDisplay()) {
            g2.scale(2.0, 2.0);
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (Toolkit.highResDisplay()) {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
        }
        return g2;
    }

    public static boolean highResDisplay() {
        if (highResProp == null) {
            highResProp = Toolkit.checkRetina();
        }
        return highResProp;
    }

    private static boolean checkRetina() {
        if (Platform.isMacOS()) {
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice device = env.getDefaultScreenDevice();
            try {
                Field field = device.getClass().getDeclaredField("scale");
                if (field != null) {
                    field.setAccessible(true);
                    Object scale = field.get(device);
                    if (scale instanceof Integer && (Integer)scale == 2) {
                        return true;
                    }
                }
            }
            catch (Exception exception) {}
        }
        return false;
    }

    private static List<Font> getMonoFontList() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fonts = ge.getAllFonts();
        ArrayList<Font> outgoing = new ArrayList<Font>();
        FontRenderContext frc = new FontRenderContext(new AffineTransform(), Preferences.getBoolean("editor.antialias"), true);
        Font[] fontArray = fonts;
        int n = fonts.length;
        int n2 = 0;
        while (n2 < n) {
            double w;
            Font font = fontArray[n2];
            if (font.getStyle() == 0 && font.canDisplay('i') && font.canDisplay('M') && font.canDisplay(' ') && font.canDisplay('.') && (w = font.getStringBounds(" ", frc).getWidth()) == font.getStringBounds("i", frc).getWidth() && w == font.getStringBounds("M", frc).getWidth() && w == font.getStringBounds(".", frc).getWidth()) {
                outgoing.add(font);
            }
            ++n2;
        }
        return outgoing;
    }

    public static String[] getMonoFontFamilies() {
        HashSet<String> families = new HashSet<String>();
        for (Font font : Toolkit.getMonoFontList()) {
            families.add(font.getFamily());
        }
        Object[] names = families.toArray(new String[0]);
        Arrays.sort(names);
        return names;
    }

    public static String getMonoFontName() {
        if (monoFont == null) {
            Toolkit.getMonoFont(12, 0);
        }
        return monoFont.getName();
    }

    public static Font getMonoFont(int size, int style) {
        if (monoFont == null) {
            try {
                monoFont = Toolkit.createFont("SourceCodePro-Regular.ttf", size);
                monoBoldFont = Toolkit.createFont("SourceCodePro-Bold.ttf", size);
                if (!(!"el".equals(Language.getLanguage()) || monoFont.canDisplay('\u03b1') && monoFont.canDisplay('\u03a9'))) {
                    monoFont = Toolkit.createFont("AnonymousPro-Regular.ttf", size);
                    monoBoldFont = Toolkit.createFont("AnonymousPro-Bold.ttf", size);
                }
                String lang = Language.getLanguage();
                if (Locale.CHINESE.getLanguage().equals(lang) || Locale.JAPANESE.getLanguage().equals(lang) || Locale.KOREAN.getLanguage().equals(lang)) {
                    sansFont = new Font("Monospaced", 0, size);
                    sansBoldFont = new Font("Monospaced", 1, size);
                }
            }
            catch (Exception e) {
                Messages.loge("Could not load mono font", e);
                monoFont = new Font("Monospaced", 0, size);
                monoBoldFont = new Font("Monospaced", 1, size);
            }
        }
        if (style == 1) {
            if (size == monoBoldFont.getSize()) {
                return monoBoldFont;
            }
            return monoBoldFont.deriveFont((float)size);
        }
        if (size == monoFont.getSize()) {
            return monoFont;
        }
        return monoFont.deriveFont((float)size);
    }

    public static Font getSansFont(int size, int style) {
        if (sansFont == null) {
            try {
                sansFont = Toolkit.createFont("SourceSansPro-Regular.ttf", size);
                sansBoldFont = Toolkit.createFont("SourceSansPro-Semibold.ttf", size);
                if (!(!"el".equals(Language.getLanguage()) || sansFont.canDisplay('\u03b1') && sansFont.canDisplay('\u03a9'))) {
                    sansFont = Toolkit.createFont("Carlito-Regular.ttf", size);
                    sansBoldFont = Toolkit.createFont("Carlito-Bold.ttf", size);
                }
                String lang = Language.getLanguage();
                if (Locale.CHINESE.getLanguage().equals(lang) || Locale.JAPANESE.getLanguage().equals(lang) || Locale.KOREAN.getLanguage().equals(lang)) {
                    sansFont = new Font("SansSerif", 0, size);
                    sansBoldFont = new Font("SansSerif", 1, size);
                }
            }
            catch (Exception e) {
                Messages.loge("Could not load sans font", e);
                sansFont = new Font("SansSerif", 0, size);
                sansBoldFont = new Font("SansSerif", 1, size);
            }
        }
        if (style == 1) {
            if (size == sansBoldFont.getSize()) {
                return sansBoldFont;
            }
            return sansBoldFont.deriveFont((float)size);
        }
        if (size == sansFont.getSize()) {
            return sansFont;
        }
        return sansFont.deriveFont((float)size);
    }

    private static Font createFont(String filename, int size) throws IOException, FontFormatException {
        File fontFile = new File(System.getProperty("java.home"), "lib/fonts/" + filename);
        if (!fontFile.exists()) {
            fontFile = new File(System.getProperty("user.dir"), "../build/shared/lib/fonts/" + filename);
        }
        if (!fontFile.exists()) {
            fontFile = new File(System.getProperty("user.dir"), "../../shared/lib/fonts/" + filename);
        }
        if (!fontFile.exists()) {
            String msg = "Could not find required fonts. ";
            msg = Util.containsNonASCII(Platform.getJavaHome().getAbsolutePath()) ? String.valueOf(msg) + "Trying moving Processing\nto a location with only ASCII characters in the path." : String.valueOf(msg) + "Please reinstall Processing.";
            Messages.showError("Font Sadness", msg, null);
        }
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(fontFile));
        Font font = Font.createFont(0, input);
        input.close();
        return font.deriveFont((float)size);
    }

    public static double getAscent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        FontRenderContext frc = g2.getFontRenderContext();
        return new TextLayout("H", g.getFont(), frc).getBounds().getHeight();
    }

    public static int getMenuItemIndex(JMenu menu, JMenuItem item) {
        int index = 0;
        Component[] componentArray = menu.getMenuComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            if (comp == item) {
                return index;
            }
            ++index;
            ++n2;
        }
        return -1;
    }
}

