/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import processing.app.Mode;
import processing.app.Sketch;
import processing.app.contrib.ContributionManager;
import processing.app.ui.Editor;
import processing.app.ui.Toolkit;

public class EditorFooter
extends Box {
    static final int HIGH = 32;
    static final int CURVE_RADIUS = 6;
    static final int TAB_TOP = 2;
    static final int TAB_BOTTOM = 29;
    static final int TAB_BETWEEN = 2;
    static final int MARGIN = 14;
    static final int ICON_WIDTH = 16;
    static final int ICON_HEIGHT = 16;
    static final int ICON_TOP = 7;
    static final int ICON_MARGIN = 7;
    static final int UNSELECTED = 0;
    static final int SELECTED = 1;
    Color[] textColor = new Color[2];
    Color[] tabColor = new Color[2];
    Color updateColor;
    int updateLeft;
    Editor editor;
    List<Tab> tabs = new ArrayList<Tab>();
    Font font;
    int fontAscent;
    Image offscreen;
    int sizeW;
    int sizeH;
    int imageW;
    int imageH;
    Image gradient;
    Color bgColor;
    JPanel cardPanel;
    CardLayout cardLayout;
    Controller controller;
    int updateCount;

    public EditorFooter(Editor eddie) {
        super(1);
        this.editor = eddie;
        this.updateMode();
        this.cardLayout = new CardLayout();
        this.cardPanel = new JPanel(this.cardLayout);
        this.add(this.cardPanel);
        this.controller = new Controller();
        this.add(this.controller);
    }

    public void addPanel(Component comp, String name) {
        this.addPanel(comp, name, null);
    }

    public void addPanel(Component comp, String name, String icon) {
        this.tabs.add(new Tab(comp, name, icon));
        this.cardPanel.add(name, comp);
    }

    public void setPanel(Component comp) {
        for (Tab tab : this.tabs) {
            if (tab.comp != comp) continue;
            this.cardLayout.show(this.cardPanel, tab.name);
            this.repaint();
        }
    }

    public void setNotification(Component comp, boolean note) {
        for (Tab tab : this.tabs) {
            if (tab.comp != comp) continue;
            tab.notification = note;
            this.repaint();
        }
    }

    public void setUpdateCount(int count) {
        this.updateCount = count;
        this.repaint();
    }

    public void updateMode() {
        Mode mode = this.editor.getMode();
        this.textColor[1] = mode.getColor("footer.text.selected.color");
        this.textColor[0] = mode.getColor("footer.text.unselected.color");
        this.font = mode.getFont("footer.text.font");
        this.tabColor[1] = mode.getColor("footer.tab.selected.color");
        this.tabColor[0] = mode.getColor("footer.tab.unselected.color");
        this.updateColor = mode.getColor("footer.updates.color");
        this.gradient = mode.makeGradient("footer", 400, 32);
        this.bgColor = mode.getColor("footer.gradient.bottom");
        this.setBackground(this.bgColor);
    }

    class Controller
    extends JComponent {
        Controller() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    int x = e.getX();
                    for (Tab tab : ((Controller)Controller.this).EditorFooter.this.tabs) {
                        if (!tab.contains(x)) continue;
                        ((Controller)Controller.this).EditorFooter.this.cardLayout.show(((Controller)Controller.this).EditorFooter.this.cardPanel, tab.name);
                        Controller.this.repaint();
                    }
                    if (((Controller)Controller.this).EditorFooter.this.updateCount > 0 && x > ((Controller)Controller.this).EditorFooter.this.updateLeft) {
                        ContributionManager.openUpdates();
                    }
                }
            });
        }

        @Override
        public void paintComponent(Graphics screen) {
            if (screen == null) {
                return;
            }
            Sketch sketch = EditorFooter.this.editor.getSketch();
            if (sketch == null) {
                return;
            }
            Dimension size = this.getSize();
            if (size.width != EditorFooter.this.sizeW || size.height != EditorFooter.this.sizeH) {
                if (size.width > EditorFooter.this.imageW || size.height > EditorFooter.this.imageH) {
                    EditorFooter.this.offscreen = null;
                } else {
                    EditorFooter.this.sizeW = size.width;
                    EditorFooter.this.sizeH = size.height;
                }
            }
            if (EditorFooter.this.offscreen == null) {
                EditorFooter.this.sizeW = size.width;
                EditorFooter.this.sizeH = size.height;
                EditorFooter.this.imageW = EditorFooter.this.sizeW;
                EditorFooter.this.imageH = EditorFooter.this.sizeH;
                EditorFooter.this.offscreen = Toolkit.highResDisplay() ? this.createImage(EditorFooter.this.imageW * 2, EditorFooter.this.imageH * 2) : this.createImage(EditorFooter.this.imageW, EditorFooter.this.imageH);
            }
            Graphics g = EditorFooter.this.offscreen.getGraphics();
            g.setFont(EditorFooter.this.font);
            if (EditorFooter.this.fontAscent == 0) {
                EditorFooter.this.fontAscent = (int)Toolkit.getAscent(g);
            }
            Graphics2D g2 = Toolkit.prepareGraphics(g);
            g.setColor(EditorFooter.this.tabColor[1]);
            g.fillRect(0, 0, EditorFooter.this.imageW, 2);
            g.drawImage(EditorFooter.this.gradient, 0, 2, EditorFooter.this.imageW, EditorFooter.this.imageH, this);
            for (Tab tab : EditorFooter.this.tabs) {
                tab.textWidth = (int)EditorFooter.this.font.getStringBounds(tab.name, g2.getFontRenderContext()).getWidth();
            }
            this.drawTabs(44, g2);
            this.drawUpdates(g2);
            screen.drawImage(EditorFooter.this.offscreen, 0, 0, EditorFooter.this.imageW, EditorFooter.this.imageH, null);
        }

        private void drawTabs(int left, Graphics2D g) {
            int x = left;
            for (Tab tab : EditorFooter.this.tabs) {
                tab.left = x;
                x += 14;
                if (tab.hasIcon()) {
                    x += 30;
                }
                tab.right = x += tab.textWidth + 14;
                tab.draw(g);
                x += 2;
            }
        }

        private void drawUpdates(Graphics2D g2) {
            if (EditorFooter.this.updateCount != 0) {
                FontRenderContext frc = g2.getFontRenderContext();
                String updatesStr = "" + EditorFooter.this.updateCount;
                double countWidth = EditorFooter.this.font.getStringBounds(updatesStr, frc).getWidth();
                if ((double)EditorFooter.this.fontAscent > countWidth) {
                    countWidth = EditorFooter.this.fontAscent;
                }
                float diameter = (float)(countWidth * (double)1.65f);
                float ex = (float)(this.getWidth() - 12) - diameter;
                float ey = ((float)this.getHeight() - diameter) / 2.0f;
                g2.setColor(EditorFooter.this.updateColor);
                g2.fill(new Ellipse2D.Float(ex, ey, diameter, diameter));
                g2.setColor(EditorFooter.this.textColor[1]);
                int baseline = (this.getHeight() + EditorFooter.this.fontAscent) / 2;
                g2.drawString(updatesStr, (int)((double)ex + ((double)diameter - countWidth) / 2.0), baseline);
                double updatesWidth = EditorFooter.this.font.getStringBounds("Updates", frc).getWidth();
                g2.setColor(EditorFooter.this.textColor[0]);
                EditorFooter.this.updateLeft = (int)((double)ex - updatesWidth - 5.0);
                g2.drawString("Updates", EditorFooter.this.updateLeft, baseline);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(300, 32);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(super.getMaximumSize().width, 32);
        }
    }

    class Tab {
        String name;
        Component comp;
        boolean notification;
        Image enabledIcon;
        Image selectedIcon;
        int left;
        int right;
        int textWidth;

        Tab(Component comp, String name, String icon) {
            this.comp = comp;
            this.name = name;
            if (icon != null) {
                Mode mode = EditorFooter.this.editor.getMode();
                this.enabledIcon = mode.loadImageX(String.valueOf(icon) + "-enabled");
                this.selectedIcon = mode.loadImageX(String.valueOf(icon) + "-selected");
                if (this.selectedIcon == null) {
                    this.selectedIcon = this.enabledIcon;
                }
            }
        }

        boolean contains(int x) {
            return x >= this.left && x <= this.right;
        }

        boolean isCurrent() {
            return this.comp.isVisible();
        }

        boolean isFirst() {
            return EditorFooter.this.tabs.get(0) == this;
        }

        boolean isLast() {
            return EditorFooter.this.tabs.get(EditorFooter.this.tabs.size() - 1) == this;
        }

        int getTextLeft() {
            int links = this.left;
            if (this.enabledIcon != null) {
                links += 23;
            }
            return links + (this.right - links - this.textWidth) / 2;
        }

        boolean hasIcon() {
            return this.enabledIcon != null;
        }

        void draw(Graphics g) {
            int state = this.isCurrent() ? 1 : 0;
            g.setColor(EditorFooter.this.tabColor[state]);
            Graphics2D g2 = (Graphics2D)g;
            g2.fill(Toolkit.createRoundRect(this.left, 2.0f, this.right, 29.0f, 0.0f, 0.0f, this.isLast() ? 6 : 0, this.isFirst() ? 6 : 0));
            if (this.hasIcon()) {
                Image icon = this.isCurrent() || this.notification ? this.selectedIcon : this.enabledIcon;
                g.drawImage(icon, this.left + 14, 7, 16, 16, null);
            }
            int textLeft = this.getTextLeft();
            if (this.notification && state == 0) {
                g.setColor(EditorFooter.this.textColor[1]);
            } else {
                g.setColor(EditorFooter.this.textColor[state]);
            }
            int tabHeight = 27;
            int baseline = 2 + (tabHeight + EditorFooter.this.fontAscent) / 2;
            g.drawString(this.name, textLeft, baseline);
        }
    }
}

