/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.MatteBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import processing.app.Base;
import processing.app.Mode;
import processing.app.Preferences;
import processing.app.ui.BufferedStyledDocument;
import processing.app.ui.Editor;
import processing.core.PApplet;

public class EditorConsole
extends JScrollPane {
    Editor editor;
    Timer flushTimer;
    JTextPane consoleTextPane;
    BufferedStyledDocument consoleDoc;
    MutableAttributeSet stdStyle;
    MutableAttributeSet errStyle;
    int maxLineCount;
    PrintStream sketchOut;
    PrintStream sketchErr;
    static PrintStream systemOut = System.out;
    static PrintStream systemErr = System.err;
    static PrintStream consoleOut;
    static PrintStream consoleErr;
    static OutputStream stdoutFile;
    static OutputStream stderrFile;
    static EditorConsole currentConsole;

    static {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyMMdd");
            String randy = PApplet.nf((int)((int)(1000.0 * Math.random())), (int)4);
            String stamp = String.valueOf(formatter.format(new Date())) + "_" + randy;
            File consoleDir = Base.getSettingsFile("console");
            consoleDir.mkdirs();
            File outFile = new File(consoleDir, String.valueOf(stamp) + ".out");
            stdoutFile = new FileOutputStream(outFile);
            File errFile = new File(consoleDir, String.valueOf(stamp) + ".err");
            stderrFile = new FileOutputStream(errFile);
            consoleOut = new PrintStream(new EditorConsoleStream(false, null));
            consoleErr = new PrintStream(new EditorConsoleStream(true, null));
            System.setOut(consoleOut);
            System.setErr(consoleErr);
        }
        catch (Exception e) {
            stdoutFile = null;
            stderrFile = null;
            consoleOut = null;
            consoleErr = null;
            System.setOut(systemOut);
            System.setErr(systemErr);
            e.printStackTrace(systemErr);
        }
    }

    public EditorConsole(Editor editor) {
        this.editor = editor;
        this.maxLineCount = Preferences.getInteger("console.length");
        this.consoleDoc = new BufferedStyledDocument(10000, this.maxLineCount);
        this.consoleTextPane = new JTextPane(this.consoleDoc);
        this.consoleTextPane.setEditable(false);
        this.updateMode();
        this.setViewportView(this.consoleTextPane);
        this.sketchOut = new PrintStream(new EditorConsoleStream(false, this));
        this.sketchErr = new PrintStream(new EditorConsoleStream(true, this));
        this.startTimer();
    }

    protected void flush() {
        if (this.consoleDoc.hasAppendage) {
            this.consoleDoc.insertAll();
            this.consoleTextPane.setCaretPosition(this.consoleDoc.getLength());
        }
    }

    protected void startTimer() {
        if (this.flushTimer == null) {
            this.flushTimer = new Timer(250, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    EditorConsole.this.flush();
                }
            });
            this.flushTimer.start();
        }
    }

    protected void stopTimer() {
        if (this.flushTimer != null) {
            this.flush();
            this.flushTimer.stop();
            this.flushTimer = null;
        }
    }

    public PrintStream getOut() {
        return this.sketchOut;
    }

    public PrintStream getErr() {
        return this.sketchErr;
    }

    protected void updateAppearance() {
        String fontFamily = Preferences.get("editor.font.family");
        int fontSize = Preferences.getInteger("console.font.size");
        StyleConstants.setFontFamily(this.stdStyle, fontFamily);
        StyleConstants.setFontSize(this.stdStyle, fontSize);
        StyleConstants.setFontFamily(this.errStyle, fontFamily);
        StyleConstants.setFontSize(this.errStyle, fontSize);
        this.clear();
    }

    protected void updateMode() {
        Mode mode = this.editor.getMode();
        SimpleAttributeSet standard = new SimpleAttributeSet();
        StyleConstants.setAlignment(standard, 0);
        this.consoleDoc.setParagraphAttributes(0, 0, standard, true);
        Font font = Preferences.getFont("console.font");
        Color bgColor = mode.getColor("console.color");
        Color fgColorOut = mode.getColor("console.output.color");
        Color fgColorErr = mode.getColor("console.error.color");
        this.setBorder(new MatteBorder(0, 44, 0, 0, bgColor));
        this.stdStyle = new SimpleAttributeSet();
        StyleConstants.setForeground(this.stdStyle, fgColorOut);
        StyleConstants.setBackground(this.stdStyle, bgColor);
        StyleConstants.setFontSize(this.stdStyle, font.getSize());
        StyleConstants.setFontFamily(this.stdStyle, font.getFamily());
        StyleConstants.setBold(this.stdStyle, font.isBold());
        StyleConstants.setItalic(this.stdStyle, font.isItalic());
        this.errStyle = new SimpleAttributeSet();
        StyleConstants.setForeground(this.errStyle, fgColorErr);
        StyleConstants.setBackground(this.errStyle, bgColor);
        StyleConstants.setFontSize(this.errStyle, font.getSize());
        StyleConstants.setFontFamily(this.errStyle, font.getFamily());
        StyleConstants.setBold(this.errStyle, font.isBold());
        StyleConstants.setItalic(this.errStyle, font.isItalic());
        if (UIManager.getLookAndFeel().getID().equals("Nimbus")) {
            this.getViewport().setBackground(bgColor);
            this.consoleTextPane.setOpaque(false);
            this.consoleTextPane.setBackground(new Color(0, 0, 0, 0));
        } else {
            this.consoleTextPane.setBackground(bgColor);
        }
        FontMetrics metrics = this.getFontMetrics(font);
        int height = metrics.getAscent() + metrics.getDescent();
        int lines = Preferences.getInteger("console.lines");
        int sizeFudge = 6;
        this.setPreferredSize(new Dimension(1024, height * lines + sizeFudge));
        this.setMinimumSize(new Dimension(1024, height * 4 + sizeFudge));
    }

    public static void setEditor(Editor editor) {
        if (currentConsole != null) {
            currentConsole.stopTimer();
        }
        currentConsole = editor.console;
        currentConsole.startTimer();
    }

    public static void handleQuit() {
        System.setOut(systemOut);
        System.setErr(systemErr);
        try {
            if (consoleOut != null) {
                consoleOut.close();
            }
            if (consoleErr != null) {
                consoleErr.close();
            }
            if (stdoutFile != null) {
                stdoutFile.close();
            }
            if (stderrFile != null) {
                stderrFile.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace(systemErr);
        }
    }

    public synchronized void message(String what, boolean err) {
        if (err) {
            systemErr.print(what);
        } else {
            systemOut.print(what);
        }
        if (!(err && (what.contains("invalid context 0x0") || what.contains("invalid drawable")) || err && what.contains("Make pbuffer:") || err && what.contains("XInitThreads() called for concurrent") || !err && what.contains("Listening for transport dt_socket at address"))) {
            this.consoleDoc.appendString(what, err ? this.errStyle : this.stdStyle);
        }
    }

    public void clear() {
        try {
            this.consoleDoc.remove(0, this.consoleDoc.getLength());
        }
        catch (BadLocationException badLocationException) {}
    }

    private static class EditorConsoleStream
    extends OutputStream {
        final boolean err;
        final byte[] single = new byte[1];
        EditorConsole console;

        public EditorConsoleStream(boolean err, EditorConsole console) {
            this.err = err;
            this.console = console;
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(byte[] b) {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int offset, int length) {
            OutputStream echo;
            if (this.console != null) {
                this.console.message(new String(b, offset, length), this.err);
            } else if (currentConsole != null) {
                currentConsole.message(new String(b, offset, length), this.err);
            } else if (this.err) {
                systemErr.write(b, offset, length);
            } else {
                systemOut.write(b, offset, length);
            }
            OutputStream outputStream = echo = this.err ? stderrFile : stdoutFile;
            if (echo != null) {
                try {
                    echo.write(b, offset, length);
                    echo.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public void write(int b) {
            this.single[0] = (byte)b;
            this.write(this.single, 0, 1);
        }
    }
}

