/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.text.BadLocationException;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import processing.app.Base;
import processing.app.Formatter;
import processing.app.Language;
import processing.app.Messages;
import processing.app.Mode;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.RunnerListener;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.SketchException;
import processing.app.Util;
import processing.app.contrib.ContributionManager;
import processing.app.syntax.JEditTextArea;
import processing.app.syntax.PdeInputHandler;
import processing.app.syntax.PdeTextAreaDefaults;
import processing.app.syntax.SyntaxDocument;
import processing.app.ui.ChangeDetector;
import processing.app.ui.EditorConsole;
import processing.app.ui.EditorException;
import processing.app.ui.EditorFooter;
import processing.app.ui.EditorHeader;
import processing.app.ui.EditorState;
import processing.app.ui.EditorStatus;
import processing.app.ui.EditorToolbar;
import processing.app.ui.ErrorTable;
import processing.app.ui.FindReplace;
import processing.app.ui.Recent;
import processing.app.ui.Toolkit;
import processing.core.PApplet;

public abstract class Editor
extends JFrame
implements RunnerListener {
    protected Base base;
    protected EditorState state;
    protected Mode mode;
    public static final int LEFT_GUTTER = 44;
    public static final int RIGHT_GUTTER = 12;
    public static final int GUTTER_MARGIN = 3;
    protected static final String EMPTY = "                                                                                                                                                                                                               ";
    private PageFormat pageFormat;
    private PrinterJob printerJob;
    private JMenu fileMenu;
    private JMenu sketchMenu;
    protected EditorHeader header;
    protected EditorToolbar toolbar;
    protected JEditTextArea textarea;
    protected EditorStatus status;
    protected JSplitPane splitPane;
    protected EditorFooter footer;
    protected EditorConsole console;
    protected ErrorTable errorTable;
    protected Sketch sketch;
    private Point sketchWindowLocation;
    private JMenuItem undoItem;
    private JMenuItem redoItem;
    protected UndoAction undoAction;
    protected RedoAction redoAction;
    protected CutAction cutAction;
    protected CopyAction copyAction;
    protected CopyAsHtmlAction copyAsHtmlAction;
    protected PasteAction pasteAction;
    protected List<UpdatableAction> editMenuUpdatable = new ArrayList<UpdatableAction>();
    private UndoManager undo;
    private CompoundEdit compoundEdit;
    private Timer timer;
    private TimerTask endUndoEvent;
    private boolean isInserting;
    private final Stack<Integer> caretUndoStack = new Stack();
    private final Stack<Integer> caretRedoStack = new Stack();
    private FindReplace find;
    JMenu toolsMenu;
    JMenu modePopup;
    Image backgroundGradient;
    static Font font;
    static Color textColor;
    static Color bgColorWarning;
    static Color bgColorError;

    protected Editor(final Base base, String path, EditorState state, final Mode mode) throws EditorException {
        super("Processing", state.checkConfig());
        this.base = base;
        this.state = state;
        this.mode = mode;
        base.checkFirstEditor(this);
        Toolkit.setIcon(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                base.handleClose(Editor.this, false);
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                base.handleActivated(Editor.this);
                Editor.this.fileMenu.insert(Recent.getMenu(), 2);
                Toolkit.setMenuMnemsInside(Editor.this.fileMenu);
                mode.insertImportMenu(Editor.this.sketchMenu);
                Toolkit.setMenuMnemsInside(Editor.this.sketchMenu);
                mode.insertToolbarRecentMenu();
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                Editor.this.fileMenu.remove(Recent.getMenu());
                mode.removeImportMenu(Editor.this.sketchMenu);
                mode.removeToolbarRecentMenu();
            }
        });
        this.timer = new Timer();
        this.buildMenuBar();
        JPanel contentPain = new JPanel();
        this.setContentPane(contentPain);
        contentPain.setLayout(new BorderLayout());
        Box box = Box.createVerticalBox();
        Box upper = Box.createVerticalBox();
        this.rebuildModePopup();
        this.toolbar = this.createToolbar();
        upper.add(this.toolbar);
        this.header = this.createHeader();
        upper.add(this.header);
        this.textarea = this.createTextArea();
        this.textarea.setRightClickPopup(new TextAreaPopup());
        this.textarea.setHorizontalOffset(6);
        int modifiers = Toolkit.awtToolkit.getMenuShortcutKeyMask();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(111, modifiers);
        this.textarea.getInputMap().put(keyStroke, "COMMENT_UNCOMMENT_ALT");
        this.textarea.getActionMap().put("COMMENT_UNCOMMENT_ALT", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.handleCommentUncomment();
            }
        });
        this.footer = this.createFooter();
        upper.add(this.textarea);
        this.splitPane = new JSplitPane(0, upper, this.footer);
        this.splitPane.setOneTouchExpandable(false);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setResizeWeight(1.0);
        this.splitPane.setBorder(null);
        UIManager.getDefaults().put("SplitPane.border", BorderFactory.createEmptyBorder());
        this.splitPane.setDividerSize(28);
        this.splitPane.setUI(new BasicSplitPaneUI(){

            @Override
            public BasicSplitPaneDivider createDefaultDivider() {
                Editor.this.status = new EditorStatus(this, Editor.this);
                return Editor.this.status;
            }
        });
        box.add(this.splitPane);
        contentPain.add(box);
        this.textarea.addCaretListener(new CaretListener(){
            String lastText;
            {
                this.lastText = Editor.this.textarea.getText();
            }

            @Override
            public void caretUpdate(CaretEvent e) {
                String newText = Editor.this.textarea.getText();
                if (this.lastText.equals(newText) && Editor.this.isDirectEdit() && !Editor.this.textarea.isOverwriteEnabled()) {
                    Editor.this.endTextEditHistory();
                }
                this.lastText = newText;
            }
        });
        this.textarea.addKeyListener(this.toolbar);
        contentPain.setTransferHandler(new FileDropHandler());
        this.pack();
        state.apply(this);
        int minWidth = Preferences.getInteger("editor.window.width.min");
        int minHeight = Preferences.getInteger("editor.window.height.min");
        this.setMinimumSize(new Dimension(minWidth, minHeight));
        this.applyPreferences();
        this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                Editor.this.textarea.requestFocusInWindow();
            }
        });
        this.handleOpenInternal(path);
        this.addWindowFocusListener(new ChangeDetector(this));
        if (Platform.isMacOS()) {
            try {
                Class<?> util = Class.forName("com.apple.eawt.FullScreenUtilities");
                Class[] params = new Class[]{Window.class, Boolean.TYPE};
                Method method = util.getMethod("setWindowCanFullScreen", params);
                method.invoke(util, this, true);
            }
            catch (Exception e) {
                Messages.loge("Could not enable OSX fullscreen", e);
            }
        }
    }

    protected JEditTextArea createTextArea() {
        return new JEditTextArea(new PdeTextAreaDefaults(this.mode), new PdeInputHandler());
    }

    public EditorFooter createFooter() {
        EditorFooter ef = new EditorFooter(this);
        this.console = new EditorConsole(this);
        ef.addPanel(this.console, Language.text("editor.footer.console"), "/lib/footer/console");
        return ef;
    }

    public void addErrorTable(EditorFooter ef) {
        JScrollPane scrollPane = new JScrollPane();
        this.errorTable = new ErrorTable(this);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        scrollPane.setViewportView(this.errorTable);
        ef.addPanel(scrollPane, Language.text("editor.footer.errors"), "/lib/footer/error");
    }

    public EditorState getEditorState() {
        return this.state;
    }

    public Base getBase() {
        return this.base;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void repaintHeader() {
        this.header.repaint();
    }

    public void rebuildHeader() {
        this.header.rebuild();
    }

    public void rebuildModePopup() {
        this.modePopup = new JMenu();
        ButtonGroup modeGroup = new ButtonGroup();
        for (final Mode m : this.base.getModeList()) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(m.getTitle());
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!Editor.this.sketch.isModified()) {
                        Editor.this.base.changeMode(m);
                    } else {
                        Messages.showWarning("Save", "Please save the sketch before changing the mode.");
                        Component[] componentArray = Editor.this.getModePopup().getComponents();
                        int n = componentArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Component c = componentArray[n2];
                            if (c instanceof JRadioButtonMenuItem && ((JRadioButtonMenuItem)c).getText() == Editor.this.mode.getTitle()) {
                                ((JRadioButtonMenuItem)c).setSelected(true);
                                break;
                            }
                            ++n2;
                        }
                    }
                }
            });
            this.modePopup.add(item);
            modeGroup.add(item);
            if (this.mode != m) continue;
            item.setSelected(true);
        }
        this.modePopup.addSeparator();
        JMenuItem addLib = new JMenuItem(Language.text("toolbar.add_mode"));
        addLib.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContributionManager.openModes();
            }
        });
        this.modePopup.add(addLib);
        Toolkit.setMenuMnemsInside(this.modePopup);
    }

    public JPopupMenu getModePopup() {
        return this.modePopup.getPopupMenu();
    }

    public EditorConsole getConsole() {
        return this.console;
    }

    public EditorHeader createHeader() {
        return new EditorHeader(this);
    }

    public abstract EditorToolbar createToolbar();

    public void rebuildToolbar() {
        this.toolbar.rebuild();
        this.toolbar.revalidate();
    }

    public abstract Formatter createFormatter();

    protected void setDividerLocation(int pos) {
        this.splitPane.setDividerLocation(pos);
    }

    protected int getDividerLocation() {
        return this.splitPane.getDividerLocation();
    }

    protected void applyPreferences() {
        this.textarea.getPainter().updateAppearance();
        this.textarea.repaint();
        this.console.updateAppearance();
    }

    protected void buildMenuBar() {
        JMenuBar menubar = new JMenuBar();
        this.fileMenu = this.buildFileMenu();
        menubar.add(this.fileMenu);
        menubar.add(this.buildEditMenu());
        menubar.add(this.buildSketchMenu());
        JMenu modeMenu = this.buildModeMenu();
        if (modeMenu != null) {
            menubar.add(modeMenu);
        }
        this.toolsMenu = new JMenu(Language.text("menu.tools"));
        this.base.populateToolsMenu(this.toolsMenu);
        menubar.add(this.toolsMenu);
        menubar.add(this.buildHelpMenu());
        Toolkit.setMenuMnemonics(menubar);
        this.setJMenuBar(menubar);
    }

    public abstract JMenu buildFileMenu();

    protected JMenu buildFileMenu(JMenuItem[] exportItems) {
        JMenu fileMenu = new JMenu(Language.text("menu.file"));
        JMenuItem item = Toolkit.newJMenuItem(Language.text("menu.file.new"), 78);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.base.handleNew();
            }
        });
        fileMenu.add(item);
        item = Toolkit.newJMenuItem(Language.text("menu.file.open"), 79);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.base.handleOpenPrompt();
            }
        });
        fileMenu.add(item);
        item = Toolkit.newJMenuItemShift(Language.text("menu.file.sketchbook"), 75);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.mode.showSketchbookFrame();
            }
        });
        fileMenu.add(item);
        item = Toolkit.newJMenuItemShift(Language.text("menu.file.examples"), 79);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.mode.showExamplesFrame();
            }
        });
        fileMenu.add(item);
        item = Toolkit.newJMenuItem(Language.text("menu.file.close"), 87);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.base.handleClose(Editor.this, false);
            }
        });
        fileMenu.add(item);
        item = Toolkit.newJMenuItem(Language.text("menu.file.save"), 83);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.handleSave(false);
            }
        });
        fileMenu.add(item);
        item = Toolkit.newJMenuItemShift(Language.text("menu.file.save_as"), 83);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.handleSaveAs();
            }
        });
        fileMenu.add(item);
        if (exportItems != null) {
            JMenuItem[] jMenuItemArray = exportItems;
            int n = exportItems.length;
            int n2 = 0;
            while (n2 < n) {
                JMenuItem ei = jMenuItemArray[n2];
                fileMenu.add(ei);
                ++n2;
            }
        }
        fileMenu.addSeparator();
        item = Toolkit.newJMenuItemShift(Language.text("menu.file.page_setup"), 80);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.handlePageSetup();
            }
        });
        fileMenu.add(item);
        item = Toolkit.newJMenuItem(Language.text("menu.file.print"), 80);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.handlePrint();
            }
        });
        fileMenu.add(item);
        if (!Platform.isMacOS()) {
            fileMenu.addSeparator();
            item = Toolkit.newJMenuItem(Language.text("menu.file.preferences"), 44);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.base.handlePrefs();
                }
            });
            fileMenu.add(item);
            fileMenu.addSeparator();
            item = Toolkit.newJMenuItem(Language.text("menu.file.quit"), 81);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.base.handleQuit();
                }
            });
            fileMenu.add(item);
        }
        return fileMenu;
    }

    protected JMenu buildEditMenu() {
        JMenu menu = new JMenu(Language.text("menu.edit"));
        this.undoAction = new UndoAction();
        this.undoItem = Toolkit.newJMenuItem(this.undoAction, 90);
        menu.add(this.undoItem);
        if (Platform.isWindows()) {
            this.redoAction = new RedoAction();
            this.redoItem = Toolkit.newJMenuItem(this.redoAction, 89);
        } else {
            this.redoAction = new RedoAction();
            this.redoItem = Toolkit.newJMenuItemShift(this.redoAction, 90);
        }
        menu.add(this.redoItem);
        menu.addSeparator();
        this.cutAction = new CutAction();
        JMenuItem item = Toolkit.newJMenuItem(this.cutAction, 88);
        this.editMenuUpdatable.add(this.cutAction);
        menu.add(item);
        this.copyAction = new CopyAction();
        item = Toolkit.newJMenuItem(this.copyAction, 67);
        this.editMenuUpdatable.add(this.copyAction);
        menu.add(item);
        this.copyAsHtmlAction = new CopyAsHtmlAction();
        item = Toolkit.newJMenuItemShift(this.copyAsHtmlAction, 67);
        this.editMenuUpdatable.add(this.copyAsHtmlAction);
        menu.add(item);
        this.pasteAction = new PasteAction();
        item = Toolkit.newJMenuItem(this.pasteAction, 86);
        this.editMenuUpdatable.add(this.pasteAction);
        menu.add(item);
        item = Toolkit.newJMenuItem(Language.text("menu.edit.select_all"), 65);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.textarea.selectAll();
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = Toolkit.newJMenuItem(Language.text("menu.edit.auto_format"), 84);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.handleAutoFormat();
            }
        });
        menu.add(item);
        item = Toolkit.newJMenuItem(Language.text("menu.edit.comment_uncomment"), 47);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.handleCommentUncomment();
            }
        });
        menu.add(item);
        item = Toolkit.newJMenuItem("\u2192 " + Language.text("menu.edit.increase_indent"), 93);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.handleIndentOutdent(true);
            }
        });
        menu.add(item);
        item = Toolkit.newJMenuItem("\u2190 " + Language.text("menu.edit.decrease_indent"), 91);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.handleIndentOutdent(false);
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = Toolkit.newJMenuItem(Language.text("menu.edit.find"), 70);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selection;
                if (Editor.this.find == null) {
                    Editor.this.find = new FindReplace(Editor.this);
                }
                if ((selection = Editor.this.getSelectedText()) != null && selection.length() != 0 && !selection.contains("\n")) {
                    Editor.this.find.setFindText(selection);
                }
                Editor.this.find.setVisible(true);
            }
        });
        menu.add(item);
        UpdatableAction action = new FindNextAction();
        item = Toolkit.newJMenuItem(action, 71);
        this.editMenuUpdatable.add(action);
        menu.add(item);
        action = new FindPreviousAction();
        item = Toolkit.newJMenuItemShift(action, 71);
        this.editMenuUpdatable.add(action);
        menu.add(item);
        action = new SelectionForFindAction();
        item = Toolkit.newJMenuItem(action, 69);
        this.editMenuUpdatable.add(action);
        menu.add(item);
        menu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent e) {
                for (UpdatableAction a : Editor.this.editMenuUpdatable) {
                    a.setEnabled(true);
                }
            }

            @Override
            public void menuDeselected(MenuEvent e) {
                for (UpdatableAction a : Editor.this.editMenuUpdatable) {
                    a.setEnabled(true);
                }
            }

            @Override
            public void menuSelected(MenuEvent e) {
                for (UpdatableAction a : Editor.this.editMenuUpdatable) {
                    a.updateState();
                }
            }
        });
        return menu;
    }

    public abstract JMenu buildSketchMenu();

    protected JMenu buildSketchMenu(JMenuItem[] runItems) {
        this.sketchMenu = new JMenu(Language.text("menu.sketch"));
        JMenuItem[] jMenuItemArray = runItems;
        int n = runItems.length;
        int n2 = 0;
        while (n2 < n) {
            JMenuItem mi = jMenuItemArray[n2];
            this.sketchMenu.add(mi);
            ++n2;
        }
        this.sketchMenu.addSeparator();
        this.sketchMenu.add(this.mode.getImportMenu());
        JMenuItem item = Toolkit.newJMenuItem(Language.text("menu.sketch.show_sketch_folder"), 75);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Platform.openFolder(Editor.this.sketch.getFolder());
            }
        });
        this.sketchMenu.add(item);
        item.setEnabled(Platform.openFolderAvailable());
        item = new JMenuItem(Language.text("menu.sketch.add_file"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.sketch.handleAddFile();
            }
        });
        this.sketchMenu.add(item);
        if (runItems != null && runItems.length != 0) {
            this.sketchMenu.addSeparator();
        }
        this.sketchMenu.addMenuListener(new MenuListener(){
            List<JMenuItem> menuList = new ArrayList<JMenuItem>();

            @Override
            public void menuSelected(MenuEvent event) {
                for (final Editor editor : Editor.this.base.getEditors()) {
                    JMenuItem item;
                    if (Editor.this.getSketch().getMainFilePath().equals(editor.getSketch().getMainFilePath())) {
                        item = new JCheckBoxMenuItem(editor.getSketch().getName());
                        item.setSelected(true);
                    } else {
                        item = new JMenuItem(editor.getSketch().getName());
                    }
                    item.setText(String.valueOf(editor.getSketch().getName()) + " (" + editor.getMode().getTitle() + ")");
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            editor.setState(0);
                            editor.setVisible(true);
                            editor.toFront();
                        }
                    });
                    Editor.this.sketchMenu.add(item);
                    this.menuList.add(item);
                    Toolkit.setMenuMnemsInside(Editor.this.sketchMenu);
                }
            }

            @Override
            public void menuDeselected(MenuEvent event) {
                for (JMenuItem item : this.menuList) {
                    Editor.this.sketchMenu.remove(item);
                }
                this.menuList.clear();
            }

            @Override
            public void menuCanceled(MenuEvent event) {
                this.menuDeselected(event);
            }
        });
        return this.sketchMenu;
    }

    public abstract void handleImportLibrary(String var1);

    public void librariesChanged() {
    }

    public void codeFolderChanged() {
    }

    public JMenu getToolMenu() {
        return this.toolsMenu;
    }

    public void clearToolMenu() {
        this.toolsMenu.removeAll();
        System.gc();
    }

    public void setUpdatesAvailable(int count) {
        this.footer.setUpdateCount(count);
    }

    public JMenu buildModeMenu() {
        return null;
    }

    public abstract JMenu buildHelpMenu();

    public void showReference(String filename) {
        File file = new File(this.mode.getReferenceFolder(), filename);
        this.showReferenceFile(file);
    }

    public void showReferenceFile(File file) {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Platform.openURL(file.toURI().toString());
    }

    public static void showChanges() {
        if (!Base.isCommandLine()) {
            Platform.openURL("https://github.com/processing/processing/wiki/Changes");
        }
    }

    public Sketch getSketch() {
        return this.sketch;
    }

    public JEditTextArea getTextArea() {
        return this.textarea;
    }

    public String getText() {
        return this.textarea.getText();
    }

    public String getText(int start, int stop) {
        return this.textarea.getText(start, stop - start);
    }

    public void setText(String what) {
        this.startCompoundEdit();
        this.textarea.setText(what);
        this.stopCompoundEdit();
    }

    public void insertText(String what) {
        this.startCompoundEdit();
        int caret = this.getCaretOffset();
        this.setSelection(caret, caret);
        this.textarea.setSelectedText(what);
        this.stopCompoundEdit();
    }

    public String getSelectedText() {
        return this.textarea.getSelectedText();
    }

    public void setSelectedText(String what) {
        this.textarea.setSelectedText(what);
    }

    public void setSelectedText(String what, boolean ever) {
        this.textarea.setSelectedText(what, ever);
    }

    public void setSelection(int start, int stop) {
        start = PApplet.constrain((int)start, (int)0, (int)this.textarea.getDocumentLength());
        stop = PApplet.constrain((int)stop, (int)0, (int)this.textarea.getDocumentLength());
        this.textarea.select(start, stop);
    }

    public int getCaretOffset() {
        return this.textarea.getCaretPosition();
    }

    public boolean isSelectionActive() {
        return this.textarea.isSelectionActive();
    }

    public int getSelectionStart() {
        return this.textarea.getSelectionStart();
    }

    public int getSelectionStop() {
        return this.textarea.getSelectionStop();
    }

    public String getLineText(int line) {
        return this.textarea.getLineText(line);
    }

    public void setLineText(int line, String what) {
        this.startCompoundEdit();
        this.textarea.select(this.getLineStartOffset(line), this.getLineStopOffset(line));
        this.textarea.setSelectedText(what);
        this.stopCompoundEdit();
    }

    public int getLineStartOffset(int line) {
        return this.textarea.getLineStartOffset(line);
    }

    public int getLineStopOffset(int line) {
        return this.textarea.getLineStopOffset(line);
    }

    public int getLineCount() {
        return this.textarea.getLineCount();
    }

    public void startCompoundEdit() {
        this.endTextEditHistory();
        this.compoundEdit = new CompoundEdit();
        this.caretUndoStack.push(this.textarea.getCaretPosition());
        this.caretRedoStack.clear();
    }

    public void stopCompoundEdit() {
        if (this.compoundEdit != null) {
            this.compoundEdit.end();
            this.undo.addEdit(this.compoundEdit);
            this.undoAction.updateUndoState();
            this.redoAction.updateRedoState();
            this.compoundEdit = null;
        }
    }

    public int getScrollPosition() {
        return this.textarea.getVerticalScrollPosition();
    }

    public void setCode(SketchCode code) {
        SyntaxDocument document = (SyntaxDocument)code.getDocument();
        if (document == null) {
            document = new SyntaxDocument(){

                @Override
                public void beginCompoundEdit() {
                    if (Editor.this.compoundEdit == null) {
                        Editor.this.startCompoundEdit();
                    }
                    super.beginCompoundEdit();
                }

                @Override
                public void endCompoundEdit() {
                    Editor.this.stopCompoundEdit();
                    super.endCompoundEdit();
                }
            };
            code.setDocument(document);
            document.setTokenMarker(this.mode.getTokenMarker());
            try {
                document.insertString(0, code.getProgram(), null);
            }
            catch (BadLocationException bl) {
                bl.printStackTrace();
            }
            document.addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    if (Editor.this.isInserting && Editor.this.isDirectEdit() && !Editor.this.textarea.isOverwriteEnabled()) {
                        Editor.this.endTextEditHistory();
                    }
                    Editor.this.isInserting = false;
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    if (!Editor.this.isInserting && !Editor.this.textarea.isOverwriteEnabled() && Editor.this.isDirectEdit()) {
                        Editor.this.endTextEditHistory();
                    }
                    if (!Editor.this.textarea.isOverwriteEnabled()) {
                        Editor.this.isInserting = true;
                    }
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    Editor.this.endTextEditHistory();
                }
            });
            document.addUndoableEditListener(new UndoableEditListener(){

                @Override
                public void undoableEditHappened(UndoableEditEvent e) {
                    if (Editor.this.endUndoEvent != null) {
                        Editor.this.endUndoEvent.cancel();
                        Editor.this.endUndoEvent = null;
                        Editor.this.startTimerEvent();
                    }
                    if (Editor.this.compoundEdit == null) {
                        Editor.this.startCompoundEdit();
                        Editor.this.startTimerEvent();
                    }
                    Editor.this.compoundEdit.addEdit(e.getEdit());
                    Editor.this.undoAction.updateUndoState();
                    Editor.this.redoAction.updateRedoState();
                }
            });
        }
        this.textarea.setDocument(document, code.getSelectionStart(), code.getSelectionStop(), code.getScrollPosition());
        this.textarea.requestFocusInWindow();
        this.undo = code.getUndo();
        this.undoAction.updateUndoState();
        this.redoAction.updateRedoState();
    }

    boolean isDirectEdit() {
        return this.endUndoEvent != null;
    }

    void startTimerEvent() {
        this.endUndoEvent = new TimerTask(){

            @Override
            public void run() {
                EventQueue.invokeLater(Editor.this::endTextEditHistory);
            }
        };
        this.timer.schedule(this.endUndoEvent, 3000L);
        this.timer.purge();
    }

    void endTextEditHistory() {
        if (this.endUndoEvent != null) {
            this.endUndoEvent.cancel();
            this.endUndoEvent = null;
        }
        this.stopCompoundEdit();
    }

    @Override
    public void removeNotify() {
        this.timer.cancel();
        super.removeNotify();
    }

    public void handleCut() {
        this.textarea.cut();
        this.sketch.setModified(true);
    }

    public void handleCopy() {
        this.textarea.copy();
    }

    public void handleCopyAsHTML() {
        this.textarea.copyAsHTML();
        this.statusNotice(Language.text("editor.status.copy_as_html"));
    }

    public void handlePaste() {
        this.textarea.paste();
        this.sketch.setModified(true);
    }

    public void handleSelectAll() {
        this.textarea.selectAll();
    }

    public void handleAutoFormat() {
        String source = this.getText();
        try {
            String formattedText = this.createFormatter().format(source);
            int selectionEnd = this.getSelectionStop();
            if (formattedText.length() < selectionEnd - 1) {
                selectionEnd = formattedText.length() - 1;
            }
            if (formattedText.equals(source)) {
                this.statusNotice(Language.text("editor.status.autoformat.no_changes"));
            } else {
                this.startCompoundEdit();
                int scrollPos = this.textarea.getVerticalScrollPosition();
                this.textarea.setText(formattedText);
                this.setSelection(selectionEnd, selectionEnd);
                if (scrollPos != this.textarea.getVerticalScrollPosition()) {
                    this.textarea.setVerticalScrollPosition(scrollPos);
                }
                this.stopCompoundEdit();
                this.sketch.setModified(true);
                this.statusNotice(Language.text("editor.status.autoformat.finished"));
            }
        }
        catch (Exception e) {
            this.statusError(e);
        }
    }

    public abstract String getCommentPrefix();

    protected void handleCommentUncomment() {
        this.startCompoundEdit();
        String prefix = this.getCommentPrefix();
        int prefixLen = prefix.length();
        int startLine = this.textarea.getSelectionStartLine();
        int stopLine = this.textarea.getSelectionStopLine();
        int lastLineStart = this.textarea.getLineStartOffset(stopLine);
        int selectionStop = this.textarea.getSelectionStop();
        if (selectionStop == lastLineStart && this.textarea.isSelectionActive()) {
            --stopLine;
        }
        boolean commented = true;
        int i = startLine;
        while (commented && i <= stopLine) {
            String lineText = this.textarea.getLineText(i).trim();
            if (lineText.length() != 0) {
                commented = lineText.startsWith(prefix);
            }
            ++i;
        }
        int lso = Math.abs(this.textarea.getLineStartNonWhiteSpaceOffset(startLine) - this.textarea.getLineStartOffset(startLine));
        int line = startLine;
        while (line <= stopLine) {
            int location = this.textarea.getLineStartNonWhiteSpaceOffset(line);
            String lineText = this.textarea.getLineText(line);
            if (lineText.trim().length() != 0) {
                if (commented) {
                    this.textarea.select(location, location + prefixLen);
                    this.textarea.setSelectedText("");
                } else {
                    location = this.textarea.getLineStartOffset(line) + lso;
                    this.textarea.select(location, location);
                    this.textarea.setSelectedText(prefix);
                }
            }
            ++line;
        }
        this.textarea.select(this.textarea.getLineStartOffset(startLine), this.textarea.getLineStopOffset(stopLine) - 1);
        this.stopCompoundEdit();
        this.sketch.setModified(true);
    }

    public void handleIndent() {
        this.handleIndentOutdent(true);
    }

    public void handleOutdent() {
        this.handleIndentOutdent(false);
    }

    public void handleIndentOutdent(boolean indent) {
        int tabSize = Preferences.getInteger("editor.tabs.size");
        String tabString = EMPTY.substring(0, tabSize);
        this.startCompoundEdit();
        int startLine = this.textarea.getSelectionStartLine();
        int stopLine = this.textarea.getSelectionStopLine();
        int lastLineStart = this.textarea.getLineStartOffset(stopLine);
        int selectionStop = this.textarea.getSelectionStop();
        if (selectionStop == lastLineStart && this.textarea.isSelectionActive()) {
            --stopLine;
        }
        int line = startLine;
        while (line <= stopLine) {
            int location = this.textarea.getLineStartOffset(line);
            if (indent) {
                this.textarea.select(location, location);
                this.textarea.setSelectedText(tabString);
            } else {
                int last = Math.min(location + tabSize, this.textarea.getDocumentLength());
                this.textarea.select(location, last);
                if (this.textarea.getSelectedText().equals(tabString)) {
                    this.textarea.setSelectedText("");
                }
            }
            ++line;
        }
        this.textarea.select(this.textarea.getLineStartOffset(startLine), this.textarea.getLineStopOffset(stopLine) - 1);
        this.stopCompoundEdit();
        this.sketch.setModified(true);
    }

    public static boolean checkParen(char[] array, int index, int stop) {
        while (index < stop) {
            switch (array[index]) {
                case '(': {
                    return true;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    ++index;
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return false;
    }

    protected boolean functionable(char c) {
        return c == '_' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    protected String referenceCheck(boolean selectIfFound) {
        int start = this.textarea.getSelectionStart();
        int stop = this.textarea.getSelectionStop();
        if (stop < start) {
            int temp = stop;
            stop = start;
            start = temp;
        }
        char[] c = this.textarea.getText().toCharArray();
        if (start == stop) {
            while (start > 0 && this.functionable(c[start - 1])) {
                --start;
            }
            while (stop < c.length && this.functionable(c[stop])) {
                ++stop;
            }
        }
        String text = new String(c, start, stop - start).trim();
        if (Editor.checkParen(c, stop, c.length)) {
            text = String.valueOf(text) + "_";
        }
        String ref = this.mode.lookupReference(text);
        if (selectIfFound) {
            this.textarea.select(start, stop);
        }
        return ref;
    }

    protected void handleFindReference() {
        String ref = this.referenceCheck(true);
        if (ref != null) {
            this.showReference(String.valueOf(ref) + ".html");
        } else {
            String text = this.textarea.getSelectedText().trim();
            if (text.length() == 0) {
                this.statusNotice(Language.text("editor.status.find_reference.select_word_first"));
            } else {
                this.statusNotice(Language.interpolate("editor.status.find_reference.not_available", text));
            }
        }
    }

    public void setSketchLocation(Point p) {
        this.sketchWindowLocation = p;
    }

    public Point getSketchLocation() {
        return this.sketchWindowLocation;
    }

    public boolean checkModified() {
        if (!this.sketch.isModified()) {
            return true;
        }
        this.toFront();
        if (!Platform.isMacOS()) {
            String prompt = Language.interpolate("close.unsaved_changes", this.sketch.getName());
            int result = JOptionPane.showConfirmDialog(this, prompt, Language.text("menu.file.close"), 1, 3);
            if (result == 0) {
                return this.handleSave(true);
            }
            if (result == 1) {
                return true;
            }
            if (result == 2 || result == -1) {
                return false;
            }
            throw new IllegalStateException();
        }
        JOptionPane pane = new JOptionPane("<html> <head> <style type=\"text/css\">b { font: 13pt \"Lucida Grande\" }p { font: 11pt \"Lucida Grande\"; margin-top: 8px }</style> </head><b>" + Language.interpolate("save.title", this.sketch.getName()) + "</b>" + "<p>" + Language.text("save.hint") + "</p>", 3);
        Object[] options = new String[]{Language.text("save.btn.save"), Language.text("prompt.cancel"), Language.text("save.btn.dont_save")};
        pane.setOptions(options);
        pane.setInitialValue(options[0]);
        pane.putClientProperty("Quaqua.OptionPane.destructiveOption", new Integer(2));
        JDialog dialog = pane.createDialog(this, null);
        dialog.setVisible(true);
        Object result = pane.getValue();
        if (result == options[0]) {
            return this.handleSave(true);
        }
        return result == options[2];
    }

    protected void handleOpenInternal(String path) throws EditorException {
        File file = new File(path);
        File parentFile = new File(file.getParent());
        String parentName = parentFile.getName();
        String defaultName = String.valueOf(parentName) + "." + this.mode.getDefaultExtension();
        File altFile = new File(file.getParent(), defaultName);
        if (!defaultName.equals(file.getName())) {
            if (altFile.exists()) {
                path = altFile.getAbsolutePath();
            } else {
                if (!this.mode.canEdit(file)) {
                    String modeName = this.mode.getTitle().equals("Java") ? "Processing" : String.valueOf(this.mode.getTitle()) + " Mode";
                    throw new EditorException(String.valueOf(modeName) + " can only open its own sketches\n" + "and other files ending in " + this.mode.getDefaultExtension());
                }
                String properParent = file.getName().substring(0, file.getName().lastIndexOf(46));
                Object[] options = new Object[]{Language.text("prompt.ok"), Language.text("prompt.cancel")};
                String prompt = "The file \"" + file.getName() + "\" needs to be inside\n" + "a sketch folder named \"" + properParent + "\".\n" + "Create this folder, move the file, and continue?";
                int result = JOptionPane.showOptionDialog(this, prompt, "Moving", 0, 3, null, options, options[0]);
                if (result == 0) {
                    File properFolder = new File(file.getParent(), properParent);
                    if (properFolder.exists()) {
                        throw new EditorException("A folder named \"" + properParent + "\" " + "already exists. Can't open sketch.");
                    }
                    if (!properFolder.mkdirs()) {
                        throw new EditorException("Could not create the sketch folder.");
                    }
                    File properPdeFile = new File(properFolder, file.getName());
                    File origPdeFile = new File(path);
                    try {
                        Util.copyFile(origPdeFile, properPdeFile);
                    }
                    catch (IOException e) {
                        throw new EditorException("Could not copy to a proper location.", e);
                    }
                    origPdeFile.delete();
                    path = properPdeFile.getAbsolutePath();
                } else {
                    throw new EditorException();
                }
            }
        }
        try {
            this.sketch = new Sketch(path, this);
        }
        catch (IOException e) {
            throw new EditorException("Could not create the sketch.", e);
        }
        this.header.rebuild();
        this.updateTitle();
        Preferences.save();
    }

    public void updateTitle() {
        this.setTitle(String.valueOf(this.sketch.getName()) + " | Processing " + Base.getVersionName());
        if (!this.sketch.isUntitled()) {
            File sketchFile = this.sketch.getMainFile();
            this.getRootPane().putClientProperty("Window.documentFile", sketchFile);
        } else {
            this.getRootPane().putClientProperty("Window.documentFile", null);
        }
    }

    public boolean handleSave(boolean immediately) {
        if (this.sketch.isUntitled()) {
            return this.handleSaveAs();
        }
        if (immediately) {
            this.handleSaveImpl();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Editor.this.handleSaveImpl();
                }
            });
        }
        return true;
    }

    protected void handleSaveImpl() {
        this.statusNotice(Language.text("editor.status.saving"));
        try {
            if (this.sketch.save()) {
                this.statusNotice(Language.text("editor.status.saving.done"));
            } else {
                this.statusEmpty();
            }
        }
        catch (Exception e) {
            this.statusError(e);
        }
    }

    public boolean handleSaveAs() {
        this.statusNotice(Language.text("editor.status.saving"));
        try {
            if (!this.sketch.saveAs()) {
                this.statusNotice(Language.text("editor.status.saving.canceled"));
                return false;
            }
        }
        catch (Exception e) {
            this.statusError(e);
        }
        return true;
    }

    public void handlePageSetup() {
        if (this.printerJob == null) {
            this.printerJob = PrinterJob.getPrinterJob();
        }
        if (this.pageFormat == null) {
            this.pageFormat = this.printerJob.defaultPage();
        }
        this.pageFormat = this.printerJob.pageDialog(this.pageFormat);
    }

    public void handlePrint() {
        this.statusNotice(Language.text("editor.status.printing"));
        if (this.printerJob == null) {
            this.printerJob = PrinterJob.getPrinterJob();
        }
        if (this.pageFormat != null) {
            this.printerJob.setPrintable(this.textarea.getPrintable(), this.pageFormat);
        } else {
            this.printerJob.setPrintable(this.textarea.getPrintable());
        }
        this.printerJob.setJobName(this.sketch.getCurrentCode().getPrettyName());
        if (this.printerJob.printDialog()) {
            try {
                this.printerJob.print();
                this.statusNotice(Language.text("editor.status.printing.done"));
            }
            catch (PrinterException pe) {
                this.statusError(Language.text("editor.status.printing.error"));
                pe.printStackTrace();
            }
        } else {
            this.statusNotice(Language.text("editor.status.printing.canceled"));
        }
    }

    public void prepareRun() {
        this.internalCloseRunner();
        this.statusEmpty();
        int i = 0;
        while (i < 10) {
            System.out.println();
            ++i;
        }
        if (Preferences.getBoolean("console.auto_clear")) {
            this.console.clear();
        }
        this.sketch.ensureExistence();
        SketchCode[] sketchCodeArray = this.sketch.getCode();
        int n = sketchCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SketchCode sc = sketchCodeArray[n2];
            try {
                sc.setProgram(sc.getDocumentText());
            }
            catch (BadLocationException badLocationException) {}
            ++n2;
        }
    }

    public abstract void internalCloseRunner();

    public abstract void deactivateRun();

    public ErrorTable getErrorTable() {
        return this.errorTable;
    }

    public void errorTableClick(Object item) {
    }

    public void errorTableDoubleClick(Object item) {
    }

    @Override
    public void statusError(String what) {
        this.status.error(what);
    }

    @Override
    public void statusError(Exception e) {
        String mess;
        e.printStackTrace();
        if (e instanceof SketchException) {
            SketchException re = (SketchException)e;
            if (re.hasCodeIndex()) {
                this.sketch.setCurrentCode(re.getCodeIndex());
            }
            if (re.hasCodeLine()) {
                int line = re.getCodeLine();
                if (line >= this.textarea.getLineCount() && this.textarea.getLineText(line = this.textarea.getLineCount() - 1).length() == 0) {
                    --line;
                }
                if (line < 0 || line >= this.textarea.getLineCount()) {
                    System.err.println("Bad error line: " + line);
                } else {
                    this.textarea.select(this.textarea.getLineStartOffset(line), this.textarea.getLineStopOffset(line) - 1);
                }
            }
        }
        if ((mess = e.getMessage()) != null) {
            String illState;
            String illString;
            String rxString;
            String javaLang = "java.lang.";
            if (mess.indexOf(javaLang) == 0) {
                mess = mess.substring(javaLang.length());
            }
            if (mess.startsWith(rxString = "RuntimeException: ")) {
                mess = mess.substring(rxString.length());
            }
            if (mess.startsWith(illString = "IllegalArgumentException: ")) {
                mess = mess.substring(illString.length());
            }
            if (mess.startsWith(illState = "IllegalStateException: ")) {
                mess = mess.substring(illState.length());
            }
            this.statusError(mess);
        }
    }

    @Override
    public void statusNotice(String msg) {
        if (msg == null) {
            new IllegalArgumentException("This code called statusNotice(null)").printStackTrace();
            msg = "";
        }
        this.status.notice(msg);
    }

    public void clearNotice(String msg) {
        if (this.status.message.equals(msg)) {
            this.statusEmpty();
        }
    }

    public String getStatusMessage() {
        return this.status.message;
    }

    public int getStatusMode() {
        return this.status.mode;
    }

    public void statusEmpty() {
        this.statusNotice(EMPTY);
    }

    @Override
    public void startIndeterminate() {
        this.status.startIndeterminate();
    }

    @Override
    public void stopIndeterminate() {
        this.status.stopIndeterminate();
    }

    @Override
    public void statusHalt() {
    }

    @Override
    public boolean isHalted() {
        return false;
    }

    public void statusToolTip(JComponent comp, String message, boolean error) {
        if (font == null) {
            font = Toolkit.getSansFont(9, 0);
            textColor = this.mode.getColor("errors.selection.fgcolor");
            bgColorWarning = this.mode.getColor("errors.selection.warning.bgcolor");
            bgColorError = this.mode.getColor("errors.selection.error.bgcolor");
        }
        Color bgColor = error ? bgColorError : bgColorWarning;
        String content = "<html><div style='margin: -3 -3 -3 -3; padding: 3 3 3 3; background: #" + PApplet.hex((int)bgColor.getRGB(), (int)8).substring(2) + ";" + "font-family: " + font.getFontName() + ", sans-serif;" + "font-size: " + font.getSize() + "px;'>" + message + "</div></html>";
        comp.setToolTipText(content);
    }

    class CopyAction
    extends UpdatableAction {
        public CopyAction() {
            super(Language.text("menu.edit.copy"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Editor.this.handleCopy();
        }

        @Override
        public boolean canDo() {
            return Editor.this.textarea.isSelectionActive();
        }
    }

    class CopyAsHtmlAction
    extends UpdatableAction {
        public CopyAsHtmlAction() {
            super(Language.text("menu.edit.copy_as_html"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Editor.this.handleCopyAsHTML();
        }

        @Override
        public boolean canDo() {
            return Editor.this.textarea.isSelectionActive();
        }
    }

    class CutAction
    extends UpdatableAction {
        public CutAction() {
            super(Language.text("menu.edit.cut"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Editor.this.handleCut();
        }

        @Override
        public boolean canDo() {
            return Editor.this.textarea.isSelectionActive();
        }
    }

    class FileDropHandler
    extends TransferHandler {
        FileDropHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return !Editor.this.sketch.isReadOnly();
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            int successful = 0;
            if (!this.canImport(support)) {
                return false;
            }
            try {
                Transferable transferable = support.getTransferable();
                DataFlavor uriListFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
                if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    int i = 0;
                    while (i < list.size()) {
                        File file = (File)list.get(i);
                        if (Editor.this.sketch.addFile(file)) {
                            ++successful;
                        }
                        ++i;
                    }
                } else if (transferable.isDataFlavorSupported(uriListFlavor)) {
                    String data = (String)transferable.getTransferData(uriListFlavor);
                    String[] pieces = PApplet.splitTokens((String)data, (String)"\r\n");
                    int i = 0;
                    while (i < pieces.length) {
                        if (!pieces[i].startsWith("#")) {
                            String path = null;
                            if (pieces[i].startsWith("file:///")) {
                                path = pieces[i].substring(7);
                            } else if (pieces[i].startsWith("file:/")) {
                                path = pieces[i].substring(5);
                            }
                            if (Editor.this.sketch.addFile(new File(path))) {
                                ++successful;
                            }
                        }
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                Messages.showWarning("Drag & Drop Problem", "An error occurred while trying to add files to the sketch.", e);
                return false;
            }
            Editor.this.statusNotice(Language.pluralize("editor.status.drag_and_drop.files_added", successful));
            return true;
        }
    }

    class FindNextAction
    extends UpdatableAction {
        public FindNextAction() {
            super(Language.text("menu.edit.find_next"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Editor.this.find != null) {
                Editor.this.find.findNext();
            }
        }

        @Override
        public boolean canDo() {
            return Editor.this.find != null && Editor.this.find.canFindNext();
        }
    }

    class FindPreviousAction
    extends UpdatableAction {
        public FindPreviousAction() {
            super(Language.text("menu.edit.find_previous"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Editor.this.find != null) {
                Editor.this.find.findPrevious();
            }
        }

        @Override
        public boolean canDo() {
            return Editor.this.find != null && Editor.this.find.canFindNext();
        }
    }

    class PasteAction
    extends UpdatableAction {
        public PasteAction() {
            super(Language.text("menu.edit.paste"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Editor.this.textarea.paste();
            Editor.this.sketch.setModified(true);
        }

        @Override
        public boolean canDo() {
            return Editor.this.getToolkit().getSystemClipboard().isDataFlavorAvailable(DataFlavor.stringFlavor);
        }
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super(Language.text("menu.edit.redo"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Editor.this.stopCompoundEdit();
            try {
                Editor.this.undo.redo();
            }
            catch (CannotRedoException cannotRedoException) {}
            try {
                Integer caret = (Integer)Editor.this.caretRedoStack.pop();
                Editor.this.caretUndoStack.push(caret);
                Editor.this.textarea.setCaretPosition(caret);
            }
            catch (Exception exception) {}
            this.updateRedoState();
            Editor.this.undoAction.updateUndoState();
            if (Editor.this.sketch != null) {
                Editor.this.sketch.setModified(!Editor.this.getText().equals(Editor.this.sketch.getCurrentCode().getSavedProgram()));
                SketchCode[] sketchCodeArray = Editor.this.sketch.getCode();
                int n = sketchCodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SketchCode sc = sketchCodeArray[n2];
                    try {
                        sc.setModified(!sc.getDocumentText().equals(sc.getSavedProgram()));
                    }
                    catch (BadLocationException badLocationException) {}
                    ++n2;
                }
                Editor.this.repaintHeader();
            }
        }

        protected void updateRedoState() {
            if (Editor.this.undo.canRedo()) {
                Editor.this.redoItem.setEnabled(true);
                String newRedoPresentationName = Language.text("menu.edit.redo");
                if (Editor.this.undo.getRedoPresentationName().equals("Redo addition")) {
                    newRedoPresentationName = String.valueOf(newRedoPresentationName) + " " + Language.text("menu.edit.action.addition");
                } else if (Editor.this.undo.getRedoPresentationName().equals("Redo deletion")) {
                    newRedoPresentationName = String.valueOf(newRedoPresentationName) + " " + Language.text("menu.edit.action.deletion");
                }
                Editor.this.redoItem.setText(newRedoPresentationName);
                this.putValue("Name", newRedoPresentationName);
            } else {
                this.setEnabled(false);
                Editor.this.redoItem.setEnabled(false);
                Editor.this.redoItem.setText(Language.text("menu.edit.redo"));
                this.putValue("Name", Language.text("menu.edit.redo"));
            }
        }
    }

    class SelectionForFindAction
    extends UpdatableAction {
        public SelectionForFindAction() {
            super(Language.text("menu.edit.use_selection_for_find"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Editor.this.find == null) {
                Editor.this.find = new FindReplace(Editor.this);
            }
            Editor.this.find.setFindText(Editor.this.getSelectedText());
        }

        @Override
        public boolean canDo() {
            return Editor.this.textarea.isSelectionActive();
        }
    }

    class TextAreaPopup
    extends JPopupMenu {
        JMenuItem cutItem = new JMenuItem(Language.text("menu.edit.cut"));
        JMenuItem copyItem;
        JMenuItem discourseItem;
        JMenuItem pasteItem;
        JMenuItem referenceItem;

        public TextAreaPopup() {
            this.cutItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.handleCut();
                }
            });
            this.add(this.cutItem);
            this.copyItem = new JMenuItem(Language.text("menu.edit.copy"));
            this.copyItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.handleCopy();
                }
            });
            this.add(this.copyItem);
            this.discourseItem = new JMenuItem(Language.text("menu.edit.copy_as_html"));
            this.discourseItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.handleCopyAsHTML();
                }
            });
            this.add(this.discourseItem);
            this.pasteItem = new JMenuItem(Language.text("menu.edit.paste"));
            this.pasteItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.handlePaste();
                }
            });
            this.add(this.pasteItem);
            JMenuItem item = new JMenuItem(Language.text("menu.edit.select_all"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.handleSelectAll();
                }
            });
            this.add(item);
            this.addSeparator();
            item = new JMenuItem(Language.text("menu.edit.comment_uncomment"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.handleCommentUncomment();
                }
            });
            this.add(item);
            item = new JMenuItem("\u2192 " + Language.text("menu.edit.increase_indent"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.handleIndentOutdent(true);
                }
            });
            this.add(item);
            item = new JMenuItem("\u2190 " + Language.text("menu.edit.decrease_indent"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.handleIndentOutdent(false);
                }
            });
            this.add(item);
            this.addSeparator();
            this.referenceItem = new JMenuItem(Language.text("find_in_reference"));
            this.referenceItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.handleFindReference();
                }
            });
            this.add(this.referenceItem);
            Toolkit.setMenuMnemonics(this);
        }

        @Override
        public void show(Component component, int x, int y) {
            this.cutItem.setEnabled(Editor.this.cutAction.canDo());
            this.copyItem.setEnabled(Editor.this.copyAction.canDo());
            this.discourseItem.setEnabled(Editor.this.copyAsHtmlAction.canDo());
            this.pasteItem.setEnabled(Editor.this.pasteAction.canDo());
            this.referenceItem.setEnabled(Editor.this.referenceCheck(false) != null);
            super.show(component, x, y);
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super(Language.text("menu.edit.undo"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Editor.this.stopCompoundEdit();
            try {
                Integer caret = (Integer)Editor.this.caretUndoStack.pop();
                Editor.this.caretRedoStack.push(caret);
                Editor.this.textarea.setCaretPosition(caret);
                Editor.this.textarea.scrollToCaret();
            }
            catch (Exception exception) {}
            try {
                Editor.this.undo.undo();
            }
            catch (CannotUndoException cannotUndoException) {}
            this.updateUndoState();
            Editor.this.redoAction.updateRedoState();
            if (Editor.this.sketch != null) {
                Editor.this.sketch.setModified(!Editor.this.getText().equals(Editor.this.sketch.getCurrentCode().getSavedProgram()));
                SketchCode[] sketchCodeArray = Editor.this.sketch.getCode();
                int n = sketchCodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SketchCode sc = sketchCodeArray[n2];
                    try {
                        sc.setModified(!sc.getDocumentText().equals(sc.getSavedProgram()));
                    }
                    catch (BadLocationException badLocationException) {}
                    ++n2;
                }
                Editor.this.repaintHeader();
            }
        }

        protected void updateUndoState() {
            if (Editor.this.undo.canUndo() || Editor.this.compoundEdit != null && Editor.this.compoundEdit.isInProgress()) {
                this.setEnabled(true);
                Editor.this.undoItem.setEnabled(true);
                String newUndoPresentationName = Language.text("menu.edit.undo");
                if (Editor.this.undo.getUndoPresentationName().equals("Undo addition")) {
                    newUndoPresentationName = String.valueOf(newUndoPresentationName) + " " + Language.text("menu.edit.action.addition");
                } else if (Editor.this.undo.getUndoPresentationName().equals("Undo deletion")) {
                    newUndoPresentationName = String.valueOf(newUndoPresentationName) + " " + Language.text("menu.edit.action.deletion");
                }
                Editor.this.undoItem.setText(newUndoPresentationName);
                this.putValue("Name", newUndoPresentationName);
            } else {
                this.setEnabled(false);
                Editor.this.undoItem.setEnabled(false);
                Editor.this.undoItem.setText(Language.text("menu.edit.undo"));
                this.putValue("Name", Language.text("menu.edit.undo"));
            }
        }
    }

    abstract class UpdatableAction
    extends AbstractAction {
        public UpdatableAction(String name) {
            super(name);
        }

        public abstract boolean canDo();

        public void updateState() {
            this.setEnabled(this.canDo());
        }
    }
}

