/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import processing.app.Messages;
import processing.app.Preferences;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.ui.Editor;

public class ChangeDetector
implements WindowFocusListener {
    private final Sketch sketch;
    private final Editor editor;
    private static final int MODIFICATION_WINDOW_MILLIS = Preferences.getInteger("editor.watcher.window");
    private static final boolean DEBUG = Preferences.getBoolean("editor.watcher.debug");

    public ChangeDetector(Editor editor) {
        this.sketch = editor.sketch;
        this.editor = editor;
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        if (Preferences.getBoolean("editor.watcher")) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (ChangeDetector.this.sketch != null) {
                        ChangeDetector.this.sketch.ensureExistence();
                        boolean alreadyPrompted = ChangeDetector.this.checkFileCount();
                        if (!alreadyPrompted) {
                            ChangeDetector.this.checkFileTimes();
                        }
                    }
                }
            }).start();
        }
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
    }

    private boolean checkFileCount() {
        ArrayList<String> filenames = new ArrayList<String>();
        this.sketch.getSketchCodeFiles(filenames, null);
        int fileCount = filenames.size();
        if (fileCount == this.sketch.getCodeCount()) {
            return false;
        }
        if (DEBUG) {
            System.out.println(String.valueOf(this.sketch.getName()) + " file count now " + fileCount + " instead of " + this.sketch.getCodeCount());
        }
        if (this.reloadPrompt()) {
            if (this.sketch.getMainFile().exists()) {
                this.reloadSketch();
            } else {
                try {
                    SketchCode[] sketchCodeArray = this.sketch.getCode();
                    int n = sketchCodeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SketchCode code = sketchCodeArray[n2];
                        code.setModified(true);
                        ++n2;
                    }
                    this.sketch.save();
                }
                catch (Exception e) {
                    this.showErrorEDT("Reload Failed", "The main file for this sketch was deleted\nand could not be rewritten.", e);
                }
            }
        } else {
            SketchCode[] sketchCodeArray = this.sketch.getCode();
            int n = sketchCodeArray.length;
            int n3 = 0;
            while (n3 < n) {
                SketchCode code = sketchCodeArray[n3];
                if (!code.getFile().exists()) {
                    this.setCodeModified(code);
                }
                ++n3;
            }
            this.rebuildHeaderEDT();
        }
        return true;
    }

    private void checkFileTimes() {
        ArrayList<SketchCode> reloadList = new ArrayList<SketchCode>();
        SketchCode[] sketchCodeArray = this.sketch.getCode();
        int n = sketchCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SketchCode code = sketchCodeArray[n2];
            File sketchFile = code.getFile();
            if (sketchFile.exists()) {
                long diff = sketchFile.lastModified() - code.getLastModified();
                if (diff > (long)MODIFICATION_WINDOW_MILLIS) {
                    if (DEBUG) {
                        System.out.println(String.valueOf(sketchFile.getName()) + " " + diff + "ms");
                    }
                    reloadList.add(code);
                }
            } else {
                if (DEBUG) {
                    System.out.println(String.valueOf(sketchFile.getName()) + " (file disappeared)");
                }
                reloadList.add(code);
            }
            ++n2;
        }
        if (reloadList.size() > 0) {
            if (this.reloadPrompt()) {
                this.reloadSketch();
            } else {
                for (SketchCode code : reloadList) {
                    this.setCodeModified(code);
                    code.setLastModified();
                }
                this.rebuildHeaderEDT();
            }
        }
    }

    private void setCodeModified(SketchCode sc) {
        sc.setModified(true);
        this.sketch.setModified(true);
    }

    private void reloadSketch() {
        this.sketch.reload();
        this.rebuildHeaderEDT();
    }

    private boolean reloadPrompt() {
        int response = this.blockingYesNoPrompt(this.editor, "File Modified", "Your sketch has been modified externally.<br>Would you like to reload the sketch?", "If you reload the sketch, any unsaved changes will be lost.");
        return response == 0;
    }

    private void showErrorEDT(final String title, final String message, final Exception e) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Messages.showError(title, message, e);
            }
        });
    }

    private int blockingYesNoPrompt(final Frame editor, final String title, final String message1, final String message2) {
        final int[] result = new int[]{-1};
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    result[0] = Messages.showYesNoQuestion(editor, title, message1, message2);
                }
            });
        }
        catch (InvocationTargetException e) {
            e.getTargetException().printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return result[0];
    }

    private void rebuildHeaderEDT() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((ChangeDetector)ChangeDetector.this).editor.header.rebuild();
            }
        });
    }
}

