/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;

class BufferedStyledDocument
extends DefaultStyledDocument {
    List<DefaultStyledDocument.ElementSpec> elements = new ArrayList<DefaultStyledDocument.ElementSpec>();
    int maxLineLength;
    int maxLineCount;
    int currentLineLength = 0;
    boolean needLineBreak = false;
    boolean hasAppendage = false;

    public BufferedStyledDocument(int maxLineLength, int maxLineCount) {
        this.maxLineLength = maxLineLength;
        this.maxLineCount = maxLineCount;
    }

    public synchronized void appendString(String str, AttributeSet a) {
        this.hasAppendage = true;
        while (str.length() > 0) {
            if (this.needLineBreak || this.currentLineLength > this.maxLineLength) {
                this.elements.add(new DefaultStyledDocument.ElementSpec(a, 2));
                this.elements.add(new DefaultStyledDocument.ElementSpec(a, 1));
                this.currentLineLength = 0;
            }
            if (str.indexOf(10) == -1) {
                this.elements.add(new DefaultStyledDocument.ElementSpec(a, 3, str.toCharArray(), 0, str.length()));
                this.currentLineLength += str.length();
                this.needLineBreak = false;
                str = str.substring(str.length());
                continue;
            }
            this.elements.add(new DefaultStyledDocument.ElementSpec(a, 3, str.toCharArray(), 0, str.indexOf(10) + 1));
            this.needLineBreak = true;
            str = str.substring(str.indexOf(10) + 1);
        }
    }

    public synchronized void insertAll() {
        DefaultStyledDocument.ElementSpec[] elementArray = new DefaultStyledDocument.ElementSpec[this.elements.size()];
        this.elements.toArray(elementArray);
        try {
            Element element = super.getDefaultRootElement();
            int lineCount = element.getElementCount();
            int overage = lineCount - this.maxLineCount;
            if (overage > 0) {
                Element lineElement = element.getElement(overage);
                if (lineElement == null) {
                    return;
                }
                int endOffset = lineElement.getEndOffset();
                super.remove(0, endOffset);
            }
            super.insert(super.getLength(), elementArray);
        }
        catch (BadLocationException badLocationException) {}
        this.elements.clear();
        this.hasAppendage = false;
    }
}

