/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import processing.app.Language;
import processing.app.Util;
import processing.app.contrib.ContributionType;
import processing.core.PApplet;
import processing.data.StringDict;
import processing.data.StringList;

public abstract class Contribution {
    static final String IMPORTS_PROPERTY = "imports";
    static final String CATEGORIES_PROPERTY = "categories";
    static final String MODES_PROPERTY = "modes";
    static final String AUTHORS_PROPERTY = "authors";
    static final String SPECIAL_CATEGORY = "Starred";
    static final String UNKNOWN_CATEGORY = "Unknown";
    static final List validCategories = Arrays.asList("3D", "Animation", "Data", "Geometry", "GUI", "Hardware", "I/O", "Math", "Simulation", "Sound", "Starred", "Typography", "Utilities", "Video & Vision", "Other");
    static final String FOUNDATION_AUTHOR = "The Processing Foundation";
    protected StringList categories;
    protected String name;
    protected String authors;
    protected String url;
    protected String sentence;
    protected String paragraph;
    protected int version;
    protected String prettyVersion;
    protected long lastUpdated;
    protected int minRevision;
    protected int maxRevision;
    protected StringList imports;

    protected StringList getCategories() {
        return this.categories;
    }

    protected String getCategoryStr() {
        StringBuilder sb = new StringBuilder();
        for (String category : this.categories) {
            sb.append(category);
            sb.append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    protected boolean hasCategory(String category) {
        if (category != null) {
            for (String c : this.categories) {
                if (!category.equalsIgnoreCase(c)) continue;
                return true;
            }
        }
        return false;
    }

    protected StringList getImports() {
        return this.imports;
    }

    protected boolean hasImport(String importName) {
        if (this.imports != null && importName != null) {
            for (String c : this.imports) {
                if (!importName.equals(c)) continue;
                return true;
            }
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getAuthorList() {
        return this.authors;
    }

    public String getUrl() {
        return this.url;
    }

    public String getSentence() {
        return this.sentence;
    }

    public String getParagraph() {
        return this.paragraph;
    }

    public int getVersion() {
        return this.version;
    }

    public String getPrettyVersion() {
        return this.prettyVersion;
    }

    public long getLastUpdated() {
        return this.lastUpdated;
    }

    public int getMinRevision() {
        return this.minRevision;
    }

    public int getMaxRevision() {
        return this.maxRevision;
    }

    public boolean isCompatible(int versionNum) {
        return (this.maxRevision == 0 || versionNum <= this.maxRevision) && versionNum >= this.minRevision;
    }

    public abstract ContributionType getType();

    public String getTypeName() {
        return this.getType().toString();
    }

    public abstract boolean isInstalled();

    boolean isRestartFlagged() {
        return false;
    }

    boolean isDeletionFlagged() {
        return false;
    }

    boolean isUpdateFlagged() {
        return false;
    }

    boolean isSpecial() {
        if (this.authors != null && this.authors.contains(FOUNDATION_AUTHOR)) {
            return true;
        }
        return this.categories != null && this.categories.hasValue(SPECIAL_CATEGORY);
    }

    public boolean isFoundation() {
        return FOUNDATION_AUTHOR.equals(this.authors);
    }

    public StringDict loadProperties(File contribFolder) {
        return Contribution.loadProperties(contribFolder, this.getType());
    }

    public static StringDict loadProperties(File contribFolder, ContributionType type) {
        File propertiesFile = new File(contribFolder, type.getPropertiesName());
        if (propertiesFile.exists()) {
            return Util.readSettings(propertiesFile);
        }
        return null;
    }

    static StringList unknownCategoryList() {
        return new StringList(new Object[]{UNKNOWN_CATEGORY});
    }

    static StringList parseCategories(StringDict properties) {
        StringList outgoing = new StringList();
        String categoryStr = properties.get(CATEGORIES_PROPERTY);
        if (categoryStr == null) {
            categoryStr = properties.get("category");
        }
        if (categoryStr != null) {
            String[] listing;
            String[] stringArray = listing = PApplet.trim((String[])PApplet.split((String)categoryStr, (char)','));
            int n = listing.length;
            int n2 = 0;
            while (n2 < n) {
                String category = stringArray[n2];
                if (validCategories.contains(category)) {
                    category = Contribution.translateCategory(category);
                    outgoing.append(category);
                }
                ++n2;
            }
        }
        if (outgoing.size() == 0) {
            return Contribution.unknownCategoryList();
        }
        return outgoing;
    }

    static StringList parseImports(StringDict properties) {
        StringList outgoing = new StringList();
        String importStr = properties.get(IMPORTS_PROPERTY);
        if (importStr != null) {
            String[] importList;
            String[] stringArray = importList = PApplet.trim((String[])PApplet.split((String)importStr, (char)','));
            int n = importList.length;
            int n2 = 0;
            while (n2 < n) {
                String importName = stringArray[n2];
                if (!importName.isEmpty()) {
                    outgoing.append(importName);
                }
                ++n2;
            }
        }
        return outgoing.size() > 0 ? outgoing : null;
    }

    private static String translateCategory(String cat) {
        String cleaned = cat.replaceAll("[\\W]+", "_").toLowerCase();
        return Language.text("contrib.category." + cleaned);
    }

    public static interface Filter {
        public boolean matches(Contribution var1);
    }
}

