/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import processing.app.Base;
import processing.app.Messages;
import processing.app.ui.Toolkit;
import processing.core.PApplet;
import processing.core.PConstants;

public class Preferences {
    static final String DEFAULTS_FILE = "defaults.txt";
    static final String PREFS_FILE = "preferences.txt";
    static Map<String, String> defaults;
    static Map<String, String> table;
    static File preferencesFile;

    static {
        table = new HashMap<String, String>();
    }

    public static void init() {
        boolean firstRun;
        try {
            Preferences.load(Base.getLibStream(DEFAULTS_FILE));
        }
        catch (Exception e) {
            Messages.showError(null, "Could not read default settings.\nYou'll need to reinstall Processing.", e);
        }
        defaults = new HashMap<String, String>(table);
        Preferences.setColor("run.window.bgcolor", SystemColor.control);
        preferencesFile = Base.getSettingsFile(PREFS_FILE);
        boolean bl = firstRun = !preferencesFile.exists();
        if (!firstRun) {
            try {
                Preferences.load(new FileInputStream(preferencesFile));
            }
            catch (Exception ex) {
                Messages.showError("Error reading preferences", "Error reading the preferences file. Please delete (or move)\n" + preferencesFile.getAbsolutePath() + " and restart Processing.", ex);
            }
        }
        if (Preferences.checkSketchbookPref() || firstRun) {
            Preferences.save();
        }
        PApplet.useNativeSelect = Preferences.getBoolean("chooser.files.native");
        System.setProperty("java.net.useSystemProxies", "true");
        Preferences.handleProxy("http", "http.proxyHost", "http.proxyPort");
        Preferences.handleProxy("https", "https.proxyHost", "https.proxyPort");
        Preferences.handleProxy("socks", "socksProxyHost", "socksProxyPort");
    }

    static void handleProxy(String protocol, String hostProp, String portProp) {
        String proxyHost = Preferences.get("proxy." + protocol + ".host");
        String proxyPort = Preferences.get("proxy." + protocol + ".port");
        if (proxyHost != null && proxyHost.length() != 0 && proxyPort != null && proxyPort.length() != 0) {
            System.setProperty(hostProp, proxyHost);
            System.setProperty(portProp, proxyPort);
        }
    }

    public static String getPreferencesPath() {
        return preferencesFile.getAbsolutePath();
    }

    public static void load(InputStream input) throws IOException {
        String[] lines;
        HashMap<String, String> platformSpecific = new HashMap<String, String>();
        String[] stringArray = lines = PApplet.loadStrings((InputStream)input);
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String value;
            String key;
            int equals;
            String line = stringArray[n2];
            if (line.length() != 0 && line.charAt(0) != '#' && (equals = line.indexOf(61)) != -1 && !Preferences.isPlatformSpecific(key = line.substring(0, equals).trim(), value = line.substring(equals + 1).trim(), platformSpecific)) {
                table.put(key, value);
            }
            ++n2;
        }
        for (String key : platformSpecific.keySet()) {
            table.put(key, (String)platformSpecific.get(key));
        }
    }

    protected static boolean isPlatformSpecific(String key, String value, Map<String, String> specific) {
        String[] stringArray = PConstants.platformNames;
        int n = PConstants.platformNames.length;
        int n2 = 0;
        while (n2 < n) {
            String platform = stringArray[n2];
            String ext = "." + platform;
            if (key.endsWith(ext)) {
                String thisPlatform = PConstants.platformNames[PApplet.platform];
                if (platform.equals(thisPlatform)) {
                    key = key.substring(0, key.lastIndexOf(ext));
                    specific.put(key, value);
                }
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void save() {
        if (preferencesFile == null) {
            return;
        }
        PrintWriter writer = PApplet.createWriter((File)preferencesFile);
        String[] keyList = table.keySet().toArray(new String[table.size()]);
        String[] stringArray = keyList = PApplet.sort((String[])keyList);
        int n = keyList.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            writer.println(String.valueOf(key) + "=" + table.get(key));
            ++n2;
        }
        writer.flush();
        writer.close();
    }

    public static String get(String attribute) {
        return table.get(attribute);
    }

    public static String getDefault(String attribute) {
        return defaults.get(attribute);
    }

    public static void set(String attribute, String value) {
        table.put(attribute, value);
    }

    public static void unset(String attribute) {
        table.remove(attribute);
    }

    public static boolean getBoolean(String attribute) {
        String value = Preferences.get(attribute);
        return Boolean.parseBoolean(value);
    }

    public static void setBoolean(String attribute, boolean value) {
        Preferences.set(attribute, value ? "true" : "false");
    }

    public static int getInteger(String attribute) {
        return Integer.parseInt(Preferences.get(attribute));
    }

    public static void setInteger(String key, int value) {
        Preferences.set(key, String.valueOf(value));
    }

    public static Color getColor(String name) {
        Color parsed = Color.GRAY;
        String s = Preferences.get(name);
        if (s != null && s.indexOf("#") == 0) {
            try {
                parsed = new Color(Integer.parseInt(s.substring(1), 16));
            }
            catch (Exception exception) {}
        }
        return parsed;
    }

    public static void setColor(String attr, Color what) {
        Preferences.set(attr, "#" + PApplet.hex((int)(what.getRGB() & 0xFFFFFF), (int)6));
    }

    public static Font getFont(String attr) {
        try {
            String[] pieces;
            boolean replace = false;
            String value = Preferences.get(attr);
            if (value == null) {
                value = Preferences.getDefault(attr);
                replace = true;
            }
            if ((pieces = PApplet.split((String)value, (char)',')).length != 3) {
                value = Preferences.getDefault(attr);
                pieces = PApplet.split((String)value, (char)',');
                replace = true;
            }
            String name = pieces[0];
            int style = 0;
            if (pieces[1].indexOf("bold") != -1) {
                style |= 1;
            }
            if (pieces[1].indexOf("italic") != -1) {
                style |= 2;
            }
            int size = PApplet.parseInt((String)pieces[2], (int)12);
            if (replace) {
                Preferences.set(attr, value);
            }
            if (!name.startsWith("processing.")) {
                return new Font(name, style, size);
            }
            if (pieces[0].equals("processing.sans")) {
                return Toolkit.getSansFont(size, style);
            }
            if (pieces[0].equals("processing.mono")) {
                return Toolkit.getMonoFont(size, style);
            }
        }
        catch (Exception exception) {
            Messages.log("Error with font " + Preferences.get(attr) + " for attribute " + attr);
        }
        return new Font("Dialog", 0, 12);
    }

    protected static boolean checkSketchbookPref() {
        String twoPath;
        if (Preferences.getSketchbookPath() == null && (twoPath = Preferences.get("sketchbook.path")) != null) {
            Preferences.setSketchbookPath(twoPath);
            return true;
        }
        return false;
    }

    public static String getOldSketchbookPath() {
        return Preferences.get("sketchbook.path");
    }

    public static String getSketchbookPath() {
        return Preferences.get("sketchbook.path.three");
    }

    protected static void setSketchbookPath(String path) {
        Preferences.set("sketchbook.path.three", path);
    }
}

