/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.tree.DefaultMutableTreeNode;
import processing.app.Base;
import processing.app.Language;
import processing.app.Library;
import processing.app.Messages;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.Settings;
import processing.app.SketchCode;
import processing.app.SketchException;
import processing.app.Util;
import processing.app.contrib.ContributionManager;
import processing.app.syntax.PdeKeywords;
import processing.app.syntax.SyntaxStyle;
import processing.app.syntax.TokenMarker;
import processing.app.ui.Editor;
import processing.app.ui.EditorException;
import processing.app.ui.EditorState;
import processing.app.ui.ExamplesFrame;
import processing.app.ui.Recent;
import processing.app.ui.SketchbookFrame;
import processing.app.ui.Toolkit;
import processing.core.PApplet;

public abstract class Mode {
    protected Base base;
    protected File folder;
    protected TokenMarker tokenMarker;
    protected Map<String, String> keywordToReference = new HashMap<String, String>();
    protected Settings theme;
    protected Map<String, List<Library>> importToLibraryTable;
    protected JMenu examplesMenu;
    protected JMenu importMenu;
    protected ExamplesFrame examplesFrame;
    protected SketchbookFrame sketchbookFrame;
    protected JMenu toolbarMenu;
    protected File examplesFolder;
    protected File librariesFolder;
    protected File referenceFolder;
    public List<Library> coreLibraries;
    public List<Library> contribLibraries;
    protected Library coreLibrary;
    protected ClassLoader classLoader;
    static final int BACKGROUND_WIDTH = 1025;
    static final int BACKGROUND_HEIGHT = 65;
    protected Image backgroundImage;
    protected int importMenuIndex = -1;

    public Mode(Base base, File folder) {
        this.base = base;
        this.folder = folder;
        this.tokenMarker = this.createTokenMarker();
        this.examplesFolder = new File(folder, "examples");
        this.librariesFolder = new File(folder, "libraries");
        this.referenceFolder = new File(folder, "reference");
        this.rebuildLibraryList();
        try {
            File[] fileArray = this.getKeywordFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.loadKeywords(file);
                ++n2;
            }
        }
        catch (IOException e) {
            Messages.showWarning("Problem loading keywords", "Could not load keywords file for " + this.getTitle() + " mode.", e);
        }
    }

    public File[] getKeywordFiles() {
        return new File[]{new File(this.folder, "keywords.txt")};
    }

    protected void loadKeywords(File keywordFile) throws IOException {
        this.loadKeywords(keywordFile, "#");
    }

    protected void loadKeywords(File keywordFile, String commentPrefix) throws IOException {
        BufferedReader reader = PApplet.createReader((File)keywordFile);
        String line = null;
        while ((line = reader.readLine()) != null) {
            String htmlFilename;
            String[] pieces;
            if (line.trim().startsWith(commentPrefix) || (pieces = PApplet.splitTokens((String)line)).length < 2) continue;
            String keyword = pieces[0];
            String coloring = pieces[1];
            if (coloring.length() > 0) {
                this.tokenMarker.addColoring(keyword, coloring);
            }
            if (pieces.length != 3 || (htmlFilename = pieces[2]).length() <= 0) continue;
            if (htmlFilename.endsWith("_")) {
                keyword = String.valueOf(keyword) + "_";
            }
            this.keywordToReference.put(keyword, htmlFilename);
        }
        reader.close();
    }

    public void setClassLoader(ClassLoader loader) {
        this.classLoader = loader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setupGUI() {
        try {
            this.theme = new Settings(Platform.getContentFile("lib/theme.txt"));
            File modeTheme = new File(this.folder, "theme/theme.txt");
            if (modeTheme.exists()) {
                this.theme.load(modeTheme);
            }
            this.theme.setColor("run.window.bgcolor", SystemColor.control);
        }
        catch (IOException e) {
            Messages.showError("Problem loading theme.txt", "Could not load theme.txt, please re-install Processing", e);
        }
    }

    public File getContentFile(String path) {
        return new File(this.folder, path);
    }

    public InputStream getContentStream(String path) throws FileNotFoundException {
        return new FileInputStream(this.getContentFile(path));
    }

    public abstract String getTitle();

    public String getIdentifier() {
        return this.getClass().getCanonicalName();
    }

    public abstract Editor createEditor(Base var1, String var2, EditorState var3) throws EditorException;

    public File getFolder() {
        return this.folder;
    }

    public File getExamplesFolder() {
        return this.examplesFolder;
    }

    public File getLibrariesFolder() {
        return this.librariesFolder;
    }

    public File getReferenceFolder() {
        return this.referenceFolder;
    }

    public void rebuildLibraryList() {
        HashMap<String, List<Library>> importToLibraryTable = new HashMap<String, List<Library>>();
        Library core = this.getCoreLibrary();
        if (core != null) {
            core.addPackageList(importToLibraryTable);
        }
        this.coreLibraries = Library.list(this.librariesFolder);
        File contribLibrariesFolder = Base.getSketchbookLibrariesFolder();
        this.contribLibraries = Library.list(contribLibrariesFolder);
        ArrayList<Library> foundationLibraries = new ArrayList<Library>();
        for (Library lib : this.contribLibraries) {
            if (!lib.isFoundation()) continue;
            foundationLibraries.add(lib);
        }
        this.coreLibraries.addAll(foundationLibraries);
        this.contribLibraries.removeAll(foundationLibraries);
        for (Library lib : this.coreLibraries) {
            lib.addPackageList(importToLibraryTable);
        }
        for (Library lib : this.contribLibraries) {
            lib.addPackageList(importToLibraryTable);
        }
        this.importToLibraryTable = Collections.unmodifiableMap(importToLibraryTable);
        if (this.base != null) {
            this.base.getEditors().forEach(Editor::librariesChanged);
        }
    }

    public Library getCoreLibrary() {
        return null;
    }

    public Library getLibrary(String pkgName) throws SketchException {
        List<Library> libraries = this.importToLibraryTable.get(pkgName);
        if (libraries == null) {
            return null;
        }
        if (libraries.size() > 1) {
            String primary = "More than one library is competing for this sketch.";
            String secondary = "The import " + pkgName + " points to multiple libraries:<br>";
            for (Library library : libraries) {
                String location = library.getPath();
                if (location.startsWith(this.getLibrariesFolder().getAbsolutePath())) {
                    location = "part of Processing";
                }
                secondary = String.valueOf(secondary) + "<b>" + library.getName() + "</b> (" + location + ")<br>";
            }
            secondary = String.valueOf(secondary) + "Extra libraries need to be removed before this sketch can be used.";
            Messages.showWarningTiered("Duplicate Library Problem", primary, secondary, null);
            throw new SketchException("Duplicate libraries found for " + pkgName + ".");
        }
        return libraries.get(0);
    }

    public JMenu getToolbarMenu() {
        if (this.toolbarMenu == null) {
            this.rebuildToolbarMenu();
        }
        return this.toolbarMenu;
    }

    public void insertToolbarRecentMenu() {
        if (this.toolbarMenu == null) {
            this.rebuildToolbarMenu();
        } else {
            this.toolbarMenu.insert(Recent.getToolbarMenu(), 1);
        }
    }

    public void removeToolbarRecentMenu() {
        this.toolbarMenu.remove(Recent.getToolbarMenu());
    }

    protected void rebuildToolbarMenu() {
        if (this.toolbarMenu == null) {
            this.toolbarMenu = new JMenu();
        } else {
            this.toolbarMenu.removeAll();
        }
        JMenuItem item = Toolkit.newJMenuItem("Open...", 79);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Mode.this.base.handleOpenPrompt();
            }
        });
        this.toolbarMenu.add(item);
        this.insertToolbarRecentMenu();
        item = Toolkit.newJMenuItemShift("Examples...", 79);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Mode.this.showExamplesFrame();
            }
        });
        this.toolbarMenu.add(item);
        item = new JMenuItem(Language.text("examples.add_examples"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContributionManager.openExamples();
            }
        });
        this.toolbarMenu.add(item);
        this.toolbarMenu.addSeparator();
        this.base.populateSketchbookMenu(this.toolbarMenu);
    }

    public void removeImportMenu(JMenu sketchMenu) {
        JMenu importMenu = this.getImportMenu();
        this.importMenuIndex = Toolkit.getMenuItemIndex(sketchMenu, importMenu);
        sketchMenu.remove(importMenu);
    }

    public void insertImportMenu(JMenu sketchMenu) {
        if (this.importMenuIndex != -1) {
            sketchMenu.insert(this.getImportMenu(), this.importMenuIndex);
        }
    }

    public JMenu getImportMenu() {
        if (this.importMenu == null) {
            this.rebuildImportMenu();
        }
        return this.importMenu;
    }

    public void rebuildImportMenu() {
        if (this.importMenu == null) {
            this.importMenu = new JMenu(Language.text("menu.library"));
        } else {
            this.importMenu.removeAll();
        }
        JMenuItem addLib = new JMenuItem(Language.text("menu.library.add_library"));
        addLib.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContributionManager.openLibraries();
            }
        });
        this.importMenu.add(addLib);
        this.importMenu.addSeparator();
        this.rebuildLibraryList();
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Mode.this.base.activeEditor.handleImportLibrary(e.getActionCommand());
            }
        };
        if (this.coreLibraries.size() == 0) {
            JMenuItem item = new JMenuItem(String.valueOf(this.getTitle()) + " " + Language.text("menu.library.no_core_libraries"));
            item.setEnabled(false);
            this.importMenu.add(item);
        } else {
            for (Library library : this.coreLibraries) {
                JMenuItem item = new JMenuItem(library.getName());
                item.addActionListener(listener);
                item.setActionCommand(library.getName());
                this.importMenu.add(item);
            }
        }
        if (this.contribLibraries.size() != 0) {
            this.importMenu.addSeparator();
            JMenuItem contrib = new JMenuItem(Language.text("menu.library.contributed"));
            contrib.setEnabled(false);
            this.importMenu.add(contrib);
            HashMap<String, JMenu> subfolders = new HashMap<String, JMenu>();
            for (Library library : this.contribLibraries) {
                JMenuItem item = new JMenuItem(library.getName());
                item.addActionListener(listener);
                item.setActionCommand(library.getName());
                String group = library.getGroup();
                if (group != null) {
                    JMenu subMenu = (JMenu)subfolders.get(group);
                    if (subMenu == null) {
                        subMenu = new JMenu(group);
                        this.importMenu.add(subMenu);
                        subfolders.put(group, subMenu);
                    }
                    subMenu.add(item);
                    continue;
                }
                this.importMenu.add(item);
            }
        }
    }

    public File[] getExampleCategoryFolders() {
        return this.examplesFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return dir.isDirectory() && name.charAt(0) != '.';
            }
        });
    }

    public void rebuildExamplesFrame() {
        if (this.examplesFrame != null) {
            boolean visible = this.examplesFrame.isVisible();
            Rectangle bounds = null;
            if (visible) {
                bounds = this.examplesFrame.getBounds();
                this.examplesFrame.setVisible(false);
            }
            this.examplesFrame = null;
            if (visible) {
                this.showExamplesFrame();
                this.examplesFrame.setBounds(bounds);
            }
        }
    }

    public void showExamplesFrame() {
        if (this.examplesFrame == null) {
            this.examplesFrame = new ExamplesFrame(this.base, this);
        }
        this.examplesFrame.setVisible();
    }

    public DefaultMutableTreeNode buildSketchbookTree() {
        DefaultMutableTreeNode sbNode = new DefaultMutableTreeNode(Language.text("sketchbook.tree"));
        try {
            this.base.addSketches(sbNode, Base.getSketchbookFolder(), false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sbNode;
    }

    public void rebuildSketchbookFrame() {
        boolean wasVisible = this.sketchbookFrame == null ? false : this.sketchbookFrame.isVisible();
        this.sketchbookFrame = null;
        if (wasVisible) {
            this.showSketchbookFrame();
        }
    }

    public void showSketchbookFrame() {
        if (this.sketchbookFrame == null) {
            this.sketchbookFrame = new SketchbookFrame(this.base, this);
        }
        this.sketchbookFrame.setVisible();
    }

    public ImageIcon loadIcon(String filename) {
        if (filename.startsWith("/lib/")) {
            return Toolkit.getLibIcon(filename.substring(5));
        }
        File file = new File(this.folder, filename);
        if (!file.exists()) {
            return null;
        }
        return new ImageIcon(file.getAbsolutePath());
    }

    public Image loadImage(String filename) {
        ImageIcon icon = this.loadIcon(filename);
        if (icon != null) {
            return icon.getImage();
        }
        return null;
    }

    public Image loadImageX(String filename) {
        int res = Toolkit.highResDisplay() ? 2 : 1;
        return this.loadImage(String.valueOf(filename) + "-" + res + "x.png");
    }

    public String lookupReference(String keyword) {
        return this.keywordToReference.get(keyword);
    }

    public TokenMarker getTokenMarker() {
        return this.tokenMarker;
    }

    protected TokenMarker createTokenMarker() {
        return new PdeKeywords();
    }

    public String getString(String attribute) {
        return this.theme.get(attribute);
    }

    public boolean getBoolean(String attribute) {
        return this.theme.getBoolean(attribute);
    }

    public int getInteger(String attribute) {
        return this.theme.getInteger(attribute);
    }

    public Color getColor(String attribute) {
        return this.theme.getColor(attribute);
    }

    public Font getFont(String attribute) {
        return this.theme.getFont(attribute);
    }

    public SyntaxStyle getStyle(String attribute) {
        String str = Preferences.get("editor.token." + attribute + ".style");
        if (str == null) {
            throw new IllegalArgumentException("No style found for " + attribute);
        }
        StringTokenizer st = new StringTokenizer(str, ",");
        String s = st.nextToken();
        if (s.indexOf("#") == 0) {
            s = s.substring(1);
        }
        Color color = new Color(Integer.parseInt(s, 16));
        s = st.nextToken();
        boolean bold = s.indexOf("bold") != -1;
        return new SyntaxStyle(color, bold);
    }

    public Image makeGradient(String attribute, int wide, int high) {
        int top = this.getColor(String.valueOf(attribute) + ".gradient.top").getRGB();
        int bot = this.getColor(String.valueOf(attribute) + ".gradient.bottom").getRGB();
        BufferedImage outgoing = new BufferedImage(wide, high, 1);
        int[] row = new int[wide];
        WritableRaster wr = outgoing.getRaster();
        int i = 0;
        while (i < high) {
            int rgb = PApplet.lerpColor((int)top, (int)bot, (float)((float)i / (float)(high - 1)), (int)1);
            Arrays.fill(row, rgb);
            wr.setDataElements(0, i, wide, 1, row);
            ++i;
        }
        return outgoing;
    }

    public boolean hideExtension(String what) {
        return what.equals(this.getDefaultExtension());
    }

    public boolean isDefaultExtension(SketchCode code) {
        return code.getExtension().equals(this.getDefaultExtension());
    }

    public boolean isDefaultExtension(String what) {
        return what.equals(this.getDefaultExtension());
    }

    public boolean canEdit(File f) {
        int dot = f.getName().lastIndexOf(46);
        if (dot < 0) {
            return false;
        }
        return this.validExtension(f.getName().substring(dot + 1));
    }

    public boolean validExtension(String what) {
        String[] ext = this.getExtensions();
        int i = 0;
        while (i < ext.length) {
            if (ext[i].equals(what)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public abstract String getDefaultExtension();

    public String getModuleExtension() {
        return this.getDefaultExtension();
    }

    public abstract String[] getExtensions();

    public abstract String[] getIgnorable();

    public Library findLibraryByName(String libName) {
        for (Library lib : this.coreLibraries) {
            if (!libName.equals(lib.getName())) continue;
            return lib;
        }
        for (Library lib : this.contribLibraries) {
            if (!libName.equals(lib.getName())) continue;
            return lib;
        }
        return null;
    }

    public void prepareExportFolder(File targetFolder) {
        if (targetFolder != null) {
            if (Preferences.getBoolean("export.delete_target_folder")) {
                Util.removeDir(targetFolder);
            }
            targetFolder.mkdirs();
        }
    }

    public String toString() {
        return this.getTitle();
    }
}

