<?php

class theme{

	var $name='Default';//can be used to scan through themes in the different directories...
	var $author='Ian';
	var $version='1.0';
		
	function get_options(){
		//read current configuration
		require('config.theme.php');
		//official array format arr[attribute_name][des]
		//						arr[attribute_name][type]
		//						arr[attribute_name][val]
		//breaks are allowed.
		//always use theme_ to name the variables to distinguish from other function vairables in the admin page...
		return array(
			array("des"=>"Colors (use CSS color codes)","type"=>"break"),
			"theme_background_color"=> array("des"=>"Theme background color code:","type"=>"text", "val"=>$theme_background_color),
			"theme_title_color"=> array("des"=>"Theme title color code:","type"=>"text", "val"=>$theme_title_color),	
		);
	
	}
	
	//function to set new options. This shouldn't need to be updated for new themes, as it gets it's veriabale from the function above.
	//adding new functions to the array above will pass them back here for automatic saving.
	//$config is a reference to an instance of the config file editor used in the admin.php interface.
	function set_options($config, $arr){
		$configFile=dirname(__FILE__).'/config.theme.php';
		//write the new values from $arr to config file....
		//shouldn't need to be modified for normal use....
		//load the config file
		$config->LoadFromFile($configFile);

		//loop through each value and replace in the config file.
		foreach($arr as $key => $val){
			switch($val['type']){
				case  "break":
					break;
				case "text":
					if(isset($_POST[$key])){
						$var=$config->GetVar($key);
						$config->SetVar($key, stripslashes($val['val']), $var[CE_VARCOMMENT]);
					}
					break;
				case "tf":
					if(isset($_POST[$key])){
						$var=$config->GetVar($key);
						$config->SetVar($key, stripslashes($val['val']), $var[CE_VARCOMMENT],true);
					}
					break;
			}
		}
		$config_php = $config->Save($configFile);
	}


}//class